/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.execution;

import java.util.List;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.process.instance.api.FlowNodeInstanceService;
import org.bonitasoft.engine.core.process.instance.api.ProcessInstanceService;
import org.bonitasoft.engine.core.process.instance.model.SFlowElementsContainerType;
import org.bonitasoft.engine.core.process.instance.model.SFlowNodeInstance;
import org.bonitasoft.engine.core.process.instance.model.SProcessInstance;
import org.bonitasoft.engine.core.process.instance.model.SStateCategory;
import org.bonitasoft.engine.core.process.instance.model.builder.BPMInstanceBuilders;
import org.bonitasoft.engine.core.process.instance.model.builder.SUserTaskInstanceBuilder;
import org.bonitasoft.engine.execution.AbstractProcessInstanceInterruptor;
import org.bonitasoft.engine.execution.ContainerRegistry;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.persistence.SBonitaSearchException;

public class TransactionContainedProcessInstanceInterruptor
extends AbstractProcessInstanceInterruptor {
    private final ProcessInstanceService processInstanceService;
    private final FlowNodeInstanceService flowNodeInstanceService;
    private final ContainerRegistry containerRegistry;

    public TransactionContainedProcessInstanceInterruptor(BPMInstanceBuilders bpmInstanceBuilders, ProcessInstanceService processInstanceService, FlowNodeInstanceService flowNodeInstanceService, ContainerRegistry containerRegistry, TechnicalLoggerService logger) {
        super(bpmInstanceBuilders, logger);
        this.processInstanceService = processInstanceService;
        this.flowNodeInstanceService = flowNodeInstanceService;
        this.containerRegistry = containerRegistry;
    }

    @Override
    protected void setProcessStateCategory(long processInstanceId, SStateCategory stateCategory) throws SBonitaException {
        SProcessInstance processInstance = this.processInstanceService.getProcessInstance(processInstanceId);
        this.processInstanceService.setStateCategory(processInstance, stateCategory);
    }

    @Override
    protected void resumeStableChildExecution(long childId, long processInstanceId, long userId) throws SBonitaException {
        SFlowNodeInstance flowNodeInstance = this.flowNodeInstanceService.getFlowNodeInstance(childId);
        SUserTaskInstanceBuilder flowNodeKeyProvider = this.getBpmInstanceBuilders().getSUserTaskInstanceBuilder();
        String containerType = SFlowElementsContainerType.PROCESS.name();
        long parentActivity = flowNodeInstance.getLogicalGroup(flowNodeKeyProvider.getParentActivityInstanceIndex());
        if (parentActivity > 0L) {
            containerType = SFlowElementsContainerType.FLOWNODE.name();
        }
        this.containerRegistry.executeFlowNode(flowNodeInstance.getId(), null, null, containerType, flowNodeInstance.getLogicalGroup(flowNodeKeyProvider.getParentProcessInstanceIndex()));
    }

    @Override
    protected List<SFlowNodeInstance> getChildren(long processInstanceId) throws SBonitaException {
        List<SFlowNodeInstance> flowNodeInstances = this.flowNodeInstanceService.searchFlowNodeInstances(SFlowNodeInstance.class, this.getQueryOptions(processInstanceId));
        return flowNodeInstances;
    }

    @Override
    protected List<SFlowNodeInstance> getChildrenExcept(long processInstanceId, long childExceptionId) throws SBonitaException {
        List<SFlowNodeInstance> flowNodeInstances = this.flowNodeInstanceService.searchFlowNodeInstances(SFlowNodeInstance.class, this.getQueryOptions(processInstanceId, childExceptionId));
        return flowNodeInstances;
    }

    @Override
    protected long getNumberOfChildren(long processInstanceId) throws SBonitaSearchException {
        QueryOptions countOptions = new QueryOptions(0, 1, null, this.getFilterOptions(processInstanceId, this.getBpmInstanceBuilders().getSUserTaskInstanceBuilder()), null);
        return this.flowNodeInstanceService.getNumberOfFlowNodeInstances(SFlowNodeInstance.class, countOptions);
    }

    @Override
    protected long getNumberOfChildrenExcept(long processInstanceId, long childExceptionId) throws SBonitaSearchException {
        QueryOptions countOptions = new QueryOptions(0, 1, null, this.getFilterOptions(processInstanceId, childExceptionId, this.getBpmInstanceBuilders().getSUserTaskInstanceBuilder()), null);
        return this.flowNodeInstanceService.getNumberOfFlowNodeInstances(SFlowNodeInstance.class, countOptions);
    }

    @Override
    protected void setChildStateCategory(long flowNodeInstanceId, SStateCategory stateCategory) throws SBonitaException {
        SFlowNodeInstance flowNodeInstance = this.flowNodeInstanceService.getFlowNodeInstance(flowNodeInstanceId);
        this.flowNodeInstanceService.setStateCategory(flowNodeInstance, stateCategory);
    }
}

