/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.execution.work;

import java.util.List;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.process.instance.api.event.EventInstanceService;
import org.bonitasoft.engine.core.process.instance.api.exceptions.event.trigger.SMessageInstanceNotFoundException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.event.trigger.SMessageInstanceReadException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.event.trigger.SMessageModificationException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.event.trigger.SWaitingEventModificationException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.event.trigger.SWaitingEventNotFoundException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.event.trigger.SWaitingEventReadException;
import org.bonitasoft.engine.core.process.instance.model.builder.BPMInstanceBuilders;
import org.bonitasoft.engine.core.process.instance.model.event.handling.SMessageInstance;
import org.bonitasoft.engine.core.process.instance.model.event.handling.SWaitingMessageEvent;
import org.bonitasoft.engine.execution.work.RestartException;
import org.bonitasoft.engine.execution.work.TenantRestartHandler;
import org.bonitasoft.engine.recorder.model.EntityUpdateDescriptor;
import org.bonitasoft.engine.service.PlatformServiceAccessor;
import org.bonitasoft.engine.service.TenantServiceAccessor;

public class BPMEventWorksHandler
implements TenantRestartHandler {
    @Override
    public void handleRestart(PlatformServiceAccessor platformServiceAccessor, TenantServiceAccessor tenantServiceAccessor) throws RestartException {
        EventInstanceService eventInstanceService = tenantServiceAccessor.getEventInstanceService();
        BPMInstanceBuilders instanceBuilders = tenantServiceAccessor.getBPMInstanceBuilders();
        try {
            List<SMessageInstance> inProgressMessageInstances = eventInstanceService.getInProgressMessageInstances();
            for (SMessageInstance sMessageInstance : inProgressMessageInstances) {
                this.resetMessageInstance(sMessageInstance, eventInstanceService, instanceBuilders);
            }
            List<SWaitingMessageEvent> inProgressWaitingEvents = eventInstanceService.getInProgressWaitingMessageEvents();
            for (SWaitingMessageEvent sWaitingEvent : inProgressWaitingEvents) {
                this.resetWaitingMessage(sWaitingEvent, eventInstanceService, instanceBuilders);
            }
        }
        catch (SBonitaException e) {
            this.handleException("Unable to reset MessageInstances / WaitingMessageEvents that were 'In Progress' when the node stopped", e);
        }
    }

    private void resetMessageInstance(SMessageInstance messageInstanceToUpdate, EventInstanceService eventInstanceService, BPMInstanceBuilders instanceBuilders) throws SMessageModificationException, SMessageInstanceNotFoundException, SMessageInstanceReadException {
        SMessageInstance messageInstance = eventInstanceService.getMessageInstance(messageInstanceToUpdate.getId());
        EntityUpdateDescriptor descriptor = new EntityUpdateDescriptor();
        descriptor.addField(instanceBuilders.getSMessageInstanceBuilder().getHandledKey(), false);
        eventInstanceService.updateMessageInstance(messageInstance, descriptor);
    }

    private void resetWaitingMessage(SWaitingMessageEvent waitingMessage, EventInstanceService eventInstanceService, BPMInstanceBuilders instanceBuilders) throws SWaitingEventModificationException, SWaitingEventNotFoundException, SWaitingEventReadException {
        SWaitingMessageEvent waitingMsg = eventInstanceService.getWaitingMessage(waitingMessage.getId());
        EntityUpdateDescriptor descriptor = new EntityUpdateDescriptor();
        descriptor.addField(instanceBuilders.getSWaitingMessageEventBuilder().getProgressKey(), 0);
        eventInstanceService.updateWaitingMessage(waitingMsg, descriptor);
    }

    private void handleException(String message, Exception e) throws RestartException {
        throw new RestartException(message, e);
    }
}

