/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.execution.work;

import java.util.List;
import org.bonitasoft.engine.bpm.connector.ConnectorEvent;
import org.bonitasoft.engine.core.expression.control.model.SExpressionContext;
import org.bonitasoft.engine.core.operation.model.SOperation;
import org.bonitasoft.engine.execution.work.ExecuteConnectorOfActivity;
import org.bonitasoft.engine.execution.work.ExecuteConnectorOfProcess;
import org.bonitasoft.engine.execution.work.ExecuteFlowNodeWork;
import org.bonitasoft.engine.execution.work.ExecuteMessageCoupleWork;
import org.bonitasoft.engine.execution.work.FailureHandlingBonitaWork;
import org.bonitasoft.engine.execution.work.LockProcessInstanceWork;
import org.bonitasoft.engine.execution.work.NotifyChildFinishedWork;
import org.bonitasoft.engine.execution.work.TxBonitaWork;
import org.bonitasoft.engine.work.BonitaWork;

public class WorkFactory {
    public static BonitaWork createExecuteConnectorOfActivity(long processDefinitionId, long flowNodeDefinitionId, long flowNodeInstanceId, long connectorInstanceId, String connectorDefinitionName) {
        return new FailureHandlingBonitaWork(new ExecuteConnectorOfActivity(processDefinitionId, flowNodeDefinitionId, flowNodeInstanceId, connectorInstanceId, connectorDefinitionName));
    }

    public static BonitaWork createExecuteConnectorOfProcess(long processDefinitionId, long connectorInstanceId, String connectorDefinitionName, long processInstanceId, long rootProcessInstanceId, ConnectorEvent activationEvent) {
        return new FailureHandlingBonitaWork(new ExecuteConnectorOfProcess(processDefinitionId, connectorInstanceId, connectorDefinitionName, processInstanceId, rootProcessInstanceId, activationEvent));
    }

    public static BonitaWork createExecuteFlowNodeWork(long flowNodeInstanceId, List<SOperation> operations, SExpressionContext contextDependency, long processInstanceId) {
        if (processInstanceId <= 0L) {
            throw new RuntimeException("It is forbidden to create a ExecuteFlowNodeWork with a processInstanceId equals to " + processInstanceId);
        }
        return new FailureHandlingBonitaWork(new LockProcessInstanceWork(new TxBonitaWork(new ExecuteFlowNodeWork(flowNodeInstanceId, operations, contextDependency, processInstanceId)), processInstanceId));
    }

    public static BonitaWork createExecuteMessageCoupleWork(long messageInstanceId, long waitingMessageId) {
        return new FailureHandlingBonitaWork(new TxBonitaWork(new ExecuteMessageCoupleWork(messageInstanceId, waitingMessageId)));
    }

    public static BonitaWork createNotifyChildFinishedWork(long processDefinitionId, long processInstanceId, long flowNodeInstanceId, long parentId, String parentType, int stateId) {
        return new FailureHandlingBonitaWork(new LockProcessInstanceWork(new TxBonitaWork(new NotifyChildFinishedWork(processDefinitionId, processInstanceId, flowNodeInstanceId, parentId, parentType, stateId)), processInstanceId));
    }
}

