/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.external.comment;

import java.io.Serializable;
import java.util.Map;
import org.bonitasoft.engine.command.SCommandExecutionException;
import org.bonitasoft.engine.command.SCommandParameterizationException;
import org.bonitasoft.engine.command.TenantCommand;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.process.comment.api.SCommentService;
import org.bonitasoft.engine.external.comment.transaction.SearchCommentsSupervisedByTransaction;
import org.bonitasoft.engine.search.SearchOptions;
import org.bonitasoft.engine.search.descriptor.SearchEntitiesDescriptor;
import org.bonitasoft.engine.service.TenantServiceAccessor;

public class SearchCommentsSupervisedBy
extends TenantCommand {
    private static final String SUPERVISOR_ID_KEY = "supervisorId";

    @Override
    public Serializable execute(Map<String, Serializable> parameters, TenantServiceAccessor serviceAccessor) throws SCommandParameterizationException, SCommandExecutionException {
        Long supervisorId = (Long)parameters.get(SUPERVISOR_ID_KEY);
        if (supervisorId == null) {
            throw new SCommandParameterizationException("supervisorId is missing");
        }
        SearchOptions searchOptions = (SearchOptions)parameters.get("SEARCH_OPTIONS_KEY");
        if (searchOptions == null) {
            throw new SCommandParameterizationException("SEARCH_OPTIONS_KEY is missing");
        }
        SCommentService commentService = serviceAccessor.getCommentService();
        SearchEntitiesDescriptor searchEntitiesDescriptor = serviceAccessor.getSearchEntitiesDescriptor();
        SearchCommentsSupervisedByTransaction searchTransaction = new SearchCommentsSupervisedByTransaction(supervisorId, commentService, searchEntitiesDescriptor.getCommentDescriptor(), searchOptions);
        try {
            searchTransaction.execute();
        }
        catch (SBonitaException sbe) {
            throw new SCommandExecutionException(sbe);
        }
        return searchTransaction.getResult();
    }
}

