/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.external.permission;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.actor.mapping.ActorMappingService;
import org.bonitasoft.engine.api.impl.transaction.actor.GetActorsOfUserCanStartProcessDefinitions;
import org.bonitasoft.engine.api.impl.transaction.identity.GetSUser;
import org.bonitasoft.engine.command.SCommandExecutionException;
import org.bonitasoft.engine.command.SCommandParameterizationException;
import org.bonitasoft.engine.command.TenantCommand;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.identity.IdentityService;
import org.bonitasoft.engine.service.TenantServiceAccessor;

public class IsAllowedToStartProcesses
extends TenantCommand {
    private TenantServiceAccessor serviceAccessor;
    private static final String PROCESSDEFINITION_IDS_KEY = "PROCESSDEFINITION_IDS_KEY";
    private static final String USER_ID_KEY = "USER_ID_KEY";

    @Override
    public Serializable execute(Map<String, Serializable> parameters, TenantServiceAccessor serviceAccessor) throws SCommandParameterizationException, SCommandExecutionException {
        this.serviceAccessor = serviceAccessor;
        ActorMappingService actorMappingService = this.serviceAccessor.getActorMappingService();
        HashMap<Long, Boolean> resMap = new HashMap<Long, Boolean>();
        List processDefinitionIds = (List)((Object)parameters.get(PROCESSDEFINITION_IDS_KEY));
        if (processDefinitionIds == null) {
            throw new SCommandParameterizationException("Mandatory parameter PROCESSDEFINITION_IDS_KEY is missing or not convertible to List<Long>.");
        }
        long userId = (Long)parameters.get(USER_ID_KEY);
        if (userId == 0L) {
            throw new SCommandParameterizationException("Mandatory parameter USER_ID_KEY is missing or not convertible to Long.");
        }
        IdentityService identityService = this.serviceAccessor.getIdentityService();
        GetSUser getSUser = new GetSUser(identityService, userId);
        try {
            getSUser.execute();
        }
        catch (SBonitaException e) {
            throw new SCommandParameterizationException("No such user refer to this userId:" + userId, e);
        }
        getSUser.getResult();
        if (processDefinitionIds.size() > 0) {
            for (Long pid : processDefinitionIds) {
                GetActorsOfUserCanStartProcessDefinitions checker = new GetActorsOfUserCanStartProcessDefinitions(actorMappingService, pid, userId);
                try {
                    checker.execute();
                }
                catch (SBonitaException e) {
                    throw new SCommandExecutionException("No actor of user who can start the processDefinition with id:" + pid, e);
                }
                Object ckRes = checker.getResult();
                if (ckRes != null && ckRes.size() == 1) {
                    resMap.put(pid, true);
                    continue;
                }
                resMap.put(pid, false);
            }
        }
        return resMap;
    }
}

