/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.identity.xml;

import java.util.Map;
import org.bonitasoft.engine.identity.ExportedUser;
import org.bonitasoft.engine.identity.GroupCreator;
import org.bonitasoft.engine.identity.IdentityService;
import org.bonitasoft.engine.identity.RoleCreator;
import org.bonitasoft.engine.identity.SIdentityException;
import org.bonitasoft.engine.identity.model.SContactInfo;
import org.bonitasoft.engine.identity.model.SGroup;
import org.bonitasoft.engine.identity.model.SRole;
import org.bonitasoft.engine.identity.model.SUser;
import org.bonitasoft.engine.identity.model.SUserMembership;
import org.bonitasoft.engine.identity.model.builder.GroupUpdateBuilder;
import org.bonitasoft.engine.identity.model.builder.IdentityModelBuilder;
import org.bonitasoft.engine.identity.model.builder.RoleUpdateBuilder;
import org.bonitasoft.engine.identity.model.builder.SContactInfoUpdateBuilder;
import org.bonitasoft.engine.identity.model.builder.UserUpdateBuilder;
import org.bonitasoft.engine.identity.xml.ImportOrganizationStrategy;
import org.bonitasoft.engine.recorder.model.EntityUpdateDescriptor;

public class ImportOrganizationMergeDuplicatesStrategy
implements ImportOrganizationStrategy {
    private final IdentityService identityService;
    private final IdentityModelBuilder identityModelBuilder;

    public ImportOrganizationMergeDuplicatesStrategy(IdentityService identityService, IdentityModelBuilder identityModelBuilder) {
        this.identityService = identityService;
        this.identityModelBuilder = identityModelBuilder;
    }

    @Override
    public void foundExistingGroup(SGroup existingGroup, GroupCreator newGroup) throws SIdentityException {
        EntityUpdateDescriptor descriptor = this.getGroupDescriptor(existingGroup, newGroup);
        if (!descriptor.getFields().isEmpty()) {
            this.identityService.updateGroup(existingGroup, descriptor);
        }
    }

    @Override
    public void foundExistingUser(SUser existingUser, ExportedUser user) throws SIdentityException {
        long userId = existingUser.getId();
        EntityUpdateDescriptor descriptor = this.getUserDescriptor(user);
        this.identityService.updateUser(existingUser, descriptor, user.isPasswordEncrypted());
        SContactInfo persoContactInfo = this.identityService.getUserContactInfo(userId, true);
        if (persoContactInfo == null) {
            persoContactInfo = this.identityModelBuilder.getUserContactInfoBuilder().createNewInstance(userId, true).done();
            this.identityService.createUserContactInfo(persoContactInfo);
        }
        EntityUpdateDescriptor personalDataDesc = this.getUserContactInfoDescriptor(user, true);
        this.identityService.updateUserContactInfo(persoContactInfo, personalDataDesc);
        SContactInfo professContactInfo = this.identityService.getUserContactInfo(userId, false);
        if (professContactInfo == null) {
            professContactInfo = this.identityModelBuilder.getUserContactInfoBuilder().createNewInstance(userId, false).done();
            this.identityService.createUserContactInfo(professContactInfo);
        }
        EntityUpdateDescriptor professionalDataDesc = this.getUserContactInfoDescriptor(user, false);
        this.identityService.updateUserContactInfo(professContactInfo, professionalDataDesc);
    }

    @Override
    public void foundExistingRole(SRole existingRole, RoleCreator newRole) throws SIdentityException {
        EntityUpdateDescriptor descriptor = this.getRoleDescriptor(existingRole, newRole);
        if (!descriptor.getFields().isEmpty()) {
            this.identityService.updateRole(existingRole, descriptor);
        }
    }

    @Override
    public void foundExistingMembership(SUserMembership existingMembership) {
    }

    protected EntityUpdateDescriptor getRoleDescriptor(SRole existingRole, RoleCreator roleCreator) {
        String iconPath;
        String iconName;
        String displayName;
        String description;
        RoleUpdateBuilder roleUpdateBuilder = this.identityModelBuilder.getRoleUpdateBuilder();
        Map fields = roleCreator.getFields();
        String name = (String)fields.get(RoleCreator.RoleField.NAME);
        if (name != null && !name.equals(existingRole.getName())) {
            roleUpdateBuilder.updateName(name);
        }
        if ((description = (String)fields.get(RoleCreator.RoleField.DESCRIPTION)) != null && !description.equals(existingRole.getDescription())) {
            roleUpdateBuilder.updateDescription(description);
        }
        if ((displayName = (String)fields.get(RoleCreator.RoleField.DISPLAY_NAME)) != null && !displayName.equals(existingRole.getDisplayName())) {
            roleUpdateBuilder.updateDisplayName(displayName);
        }
        if ((iconName = (String)fields.get(RoleCreator.RoleField.ICON_NAME)) != null && !iconName.equals(existingRole.getIconName())) {
            roleUpdateBuilder.updateIconName(iconName);
        }
        if ((iconPath = (String)fields.get(RoleCreator.RoleField.ICON_PATH)) != null && !iconPath.equals(existingRole.getIconPath())) {
            roleUpdateBuilder.updateIconPath(iconPath);
        }
        return roleUpdateBuilder.done();
    }

    protected EntityUpdateDescriptor getGroupDescriptor(SGroup existingGroup, GroupCreator groupCreator) {
        String iconPath;
        String iconName;
        String displayName;
        String description;
        String parentPath;
        GroupUpdateBuilder groupUpdateBuilder = this.identityModelBuilder.getGroupUpdateBuilder();
        Map fields = groupCreator.getFields();
        String name = (String)fields.get(GroupCreator.GroupField.NAME);
        if (name != null && !name.equals(existingGroup.getName())) {
            groupUpdateBuilder.updateName(name);
        }
        if ((parentPath = (String)fields.get(GroupCreator.GroupField.PARENT_PATH)) != null && !parentPath.equals(existingGroup.getParentPath())) {
            groupUpdateBuilder.updateName(parentPath);
        }
        if ((description = (String)fields.get(GroupCreator.GroupField.DESCRIPTION)) != null && !description.equals(existingGroup.getDescription())) {
            groupUpdateBuilder.updateDescription(description);
        }
        if ((displayName = (String)fields.get(GroupCreator.GroupField.DISPLAY_NAME)) != null && !displayName.equals(existingGroup.getDisplayName())) {
            groupUpdateBuilder.updateDisplayName(displayName);
        }
        if ((iconName = (String)fields.get(GroupCreator.GroupField.ICON_NAME)) != null && !iconName.equals(existingGroup.getIconName())) {
            groupUpdateBuilder.updateIconName(iconName);
        }
        if ((iconPath = (String)fields.get(GroupCreator.GroupField.ICON_PATH)) != null && !iconPath.equals(existingGroup.getIconPath())) {
            groupUpdateBuilder.updateIconPath(iconPath);
        }
        return groupUpdateBuilder.done();
    }

    protected EntityUpdateDescriptor getUserContactInfoDescriptor(ExportedUser user, boolean isPersonal) {
        SContactInfoUpdateBuilder updateBuilder = this.identityModelBuilder.getUserContactInfoUpdateBuilder();
        if (isPersonal) {
            updateBuilder.updateAddress(user.getPersonalAddress());
            updateBuilder.updateBuilding(user.getPersonalBuilding());
            updateBuilder.updateCity(user.getPersonalCity());
            updateBuilder.updateCountry(user.getPersonalCountry());
            updateBuilder.updateEmail(user.getPersonalEmail());
            updateBuilder.updateFaxNumber(user.getPersonalFaxNumber());
            updateBuilder.updateMobileNumber(user.getPersonalMobileNumber());
            updateBuilder.updatePhoneNumber(user.getPersonalPhoneNumber());
            updateBuilder.updateRoom(user.getPersonalRoom());
            updateBuilder.updateState(user.getPersonalState());
            updateBuilder.updateWebsite(user.getPersonalWebsite());
            updateBuilder.updateZipCode(user.getPersonalZipCode());
        } else {
            updateBuilder.updateAddress(user.getProfessionalAddress());
            updateBuilder.updateBuilding(user.getProfessionalBuilding());
            updateBuilder.updateCity(user.getProfessionalCity());
            updateBuilder.updateCountry(user.getProfessionalCountry());
            updateBuilder.updateEmail(user.getProfessionalEmail());
            updateBuilder.updateFaxNumber(user.getProfessionalFaxNumber());
            updateBuilder.updateMobileNumber(user.getProfessionalMobileNumber());
            updateBuilder.updatePhoneNumber(user.getProfessionalPhoneNumber());
            updateBuilder.updateRoom(user.getProfessionalRoom());
            updateBuilder.updateState(user.getProfessionalState());
            updateBuilder.updateWebsite(user.getProfessionalWebsite());
            updateBuilder.updateZipCode(user.getProfessionalZipCode());
        }
        return updateBuilder.done();
    }

    protected EntityUpdateDescriptor getUserDescriptor(ExportedUser user) {
        UserUpdateBuilder userUpdateBuilder = this.identityModelBuilder.getUserUpdateBuilder();
        userUpdateBuilder.updateFirstName(user.getFirstName());
        userUpdateBuilder.updateIconName(user.getIconName());
        userUpdateBuilder.updateIconPath(user.getIconPath());
        userUpdateBuilder.updateJobTitle(user.getJobTitle());
        userUpdateBuilder.updateLastName(user.getLastName());
        userUpdateBuilder.updateManagerUserId(user.getManagerUserId());
        userUpdateBuilder.updatePassword(user.getPassword());
        userUpdateBuilder.updateTitle(user.getTitle());
        userUpdateBuilder.updateUserName(user.getUserName());
        userUpdateBuilder.updateEnabled(user.isEnabled());
        return userUpdateBuilder.done();
    }
}

