/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.queriablelogger.model.builder.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.bonitasoft.engine.persistence.model.impl.BlobValueImpl;
import org.bonitasoft.engine.queriablelogger.model.SQueriableLogParameter;
import org.bonitasoft.engine.queriablelogger.model.builder.SQueriableLogParameterBuilder;
import org.bonitasoft.engine.queriablelogger.model.builder.impl.MissingMandatoryFieldsException;
import org.bonitasoft.engine.queriablelogger.model.impl.SQueriableLogParameterImpl;

public class SQueriableLogParameterBuilderImpl
implements SQueriableLogParameterBuilder {
    private SQueriableLogParameterImpl entity;
    private List<String> problems;

    @Override
    public SQueriableLogParameterBuilder createNewInstance(String name, String valueType) {
        this.entity = new SQueriableLogParameterImpl();
        this.entity.setName(name);
        this.entity.setValueType(valueType);
        return this;
    }

    @Override
    public SQueriableLogParameterBuilder stringValue(String stringValue) {
        this.entity.setStringValue(stringValue);
        return this;
    }

    @Override
    public SQueriableLogParameterBuilder blobValue(Serializable blobValue) {
        BlobValueImpl blob = new BlobValueImpl();
        blob.setValue(blobValue);
        this.entity.setBlobValue(blob);
        return this;
    }

    @Override
    public SQueriableLogParameter done() {
        this.problems = new ArrayList<String>();
        this.checkMandatoryFields();
        if (this.problems.size() > 0) {
            throw new MissingMandatoryFieldsException("Some mandatory fields were not set: " + this.problems);
        }
        return this.entity;
    }

    private void checkMandatoryFields() {
        if (this.entity.getName() == null) {
            this.problems.add("name");
        }
        if (this.entity.getValueType() == null) {
            this.problems.add("valueType");
        }
    }
}

