/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.sequence;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.bonitasoft.engine.commons.exceptions.SObjectModificationException;
import org.bonitasoft.engine.commons.exceptions.SObjectNotFoundException;
import org.bonitasoft.engine.lock.BonitaLock;
import org.bonitasoft.engine.lock.LockService;
import org.bonitasoft.engine.lock.SLockException;
import org.bonitasoft.engine.sequence.SequenceManager;

public class SequenceManagerImpl
implements SequenceManager {
    static final String SEQUENCE = "SEQUENCE";
    static final String NEXTID = "nextid";
    static final String SELECT_BY_ID = "SELECT * FROM sequence WHERE tenantid = ? AND id = ?";
    static final String UPDATE_SEQUENCE = "UPDATE sequence SET nextId = ? WHERE tenantid = ? AND id = ?";
    private final Map<Long, Integer> rangeSizes;
    private Map<Long, Map<Long, Long>> nextAvailableIds;
    private Map<Long, Map<Long, Long>> lastIdInRanges;
    private static final Map<Long, Object> sequenceMutexs = new HashMap<Long, Object>();
    private final int defaultRangeSize;
    private final Map<String, Long> sequencesMappings;
    private static final Object newRangeMutex = new Object();
    private final int retries;
    private final int delay;
    private final int delayFactor;
    private final DataSource datasource;
    private final LockService lockService;

    public SequenceManagerImpl(LockService lockService, Map<Long, Integer> rangeSizes, int defaultRangeSize, Map<String, Long> sequencesMappings, DataSource datasource, int retries, int delay, int delayFactor) {
        this.lockService = lockService;
        this.defaultRangeSize = defaultRangeSize;
        this.rangeSizes = rangeSizes;
        this.sequencesMappings = sequencesMappings;
        this.retries = retries;
        this.delay = delay;
        this.delayFactor = delayFactor;
        this.nextAvailableIds = new HashMap<Long, Map<Long, Long>>();
        this.lastIdInRanges = new HashMap<Long, Map<Long, Long>>();
        this.datasource = datasource;
    }

    @Override
    public void reset() {
        this.nextAvailableIds = new HashMap<Long, Map<Long, Long>>();
        this.lastIdInRanges = new HashMap<Long, Map<Long, Long>>();
    }

    private long getNextAvailableId(long sequenceId, long tenantId) {
        Map<Long, Long> nextAvailableIds = this.getNextAvailableIdsMapForTenant(tenantId);
        if (!nextAvailableIds.containsKey(sequenceId)) {
            nextAvailableIds.put(sequenceId, 0L);
        }
        return nextAvailableIds.get(sequenceId);
    }

    private Map<Long, Long> getNextAvailableIdsMapForTenant(long tenantId) {
        if (!this.nextAvailableIds.containsKey(tenantId)) {
            this.nextAvailableIds.put(tenantId, new HashMap());
        }
        return this.nextAvailableIds.get(tenantId);
    }

    private void setNextAvailableId(long sequenceId, long nextAvailableId, long tenantId) {
        this.getNextAvailableIdsMapForTenant(tenantId).put(sequenceId, nextAvailableId);
    }

    private long getLastIdInRange(long sequenceId, long tenantId) {
        Map<Long, Long> lastIdInRanges = this.getLastIdInRangeMapForTenant(tenantId);
        if (!lastIdInRanges.containsKey(sequenceId)) {
            lastIdInRanges.put(sequenceId, -1L);
        }
        return lastIdInRanges.get(sequenceId);
    }

    private Map<Long, Long> getLastIdInRangeMapForTenant(long tenantId) {
        if (!this.lastIdInRanges.containsKey(tenantId)) {
            this.lastIdInRanges.put(tenantId, new HashMap());
        }
        return this.lastIdInRanges.get(tenantId);
    }

    private void setLastIdInRange(long sequenceId, long lastIdInRange, long tenantId) {
        this.getLastIdInRangeMapForTenant(tenantId).put(sequenceId, lastIdInRange);
    }

    private static synchronized Object getSequenceMutex(Long sequenceId) {
        if (!sequenceMutexs.containsKey(sequenceId)) {
            sequenceMutexs.put(sequenceId, new Object());
        }
        return sequenceMutexs.get(sequenceId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNextId(String entityName, long tenantId) throws SObjectNotFoundException, SObjectModificationException {
        Object sequenceMutex;
        Long sequenceId = this.sequencesMappings.get(entityName);
        if (sequenceId == null) {
            throw new SObjectNotFoundException("No sequence id found for " + entityName);
        }
        Object object = sequenceMutex = SequenceManagerImpl.getSequenceMutex(sequenceId);
        synchronized (object) {
            long nextAvailableId = this.getNextAvailableId(sequenceId, tenantId);
            long lastIdInRange = this.getLastIdInRange(sequenceId, tenantId);
            if (nextAvailableId > lastIdInRange) {
                this.setNewRange(sequenceId, tenantId);
                return this.getNextId(entityName, tenantId);
            }
            this.setNextAvailableId(sequenceId, nextAvailableId + 1L, tenantId);
            return nextAvailableId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setNewRange(long sequenceId, long tenantId) throws SObjectNotFoundException {
        try {
            BonitaLock lock = this.lockService.lock(sequenceId, SEQUENCE, tenantId);
            try {
                int attempt = 1;
                long sleepTime = this.delay;
                while (attempt <= this.retries) {
                    if (attempt > 1) {
                        System.err.println("retrying... #" + attempt);
                    }
                    Connection connection = null;
                    try {
                        connection = this.datasource.getConnection();
                        connection.setAutoCommit(false);
                        long nextAvailableId = this.selectById(connection, sequenceId, tenantId);
                        this.setNextAvailableId(sequenceId, nextAvailableId, tenantId);
                        long nextSequenceId = nextAvailableId + (long)this.getRangeSize(sequenceId);
                        this.updateSequence(connection, nextSequenceId, tenantId, sequenceId);
                        this.setLastIdInRange(sequenceId, nextSequenceId - 1L, tenantId);
                        connection.commit();
                        return;
                    }
                    catch (Throwable t) {
                        ++attempt;
                        try {
                            connection.rollback();
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                        SequenceManagerImpl.manageException(sleepTime, t);
                        sleepTime *= (long)this.delayFactor;
                        continue;
                    }
                    finally {
                        if (connection == null) continue;
                        try {
                            connection.close();
                            continue;
                        }
                        catch (SQLException e) {}
                    }
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                            throw new SObjectNotFoundException("Unable to get a sequence id for " + sequenceId);
                        }
                    }
                }
            }
            finally {
                this.lockService.unlock(lock, tenantId);
            }
        }
        catch (SLockException e1) {
            throw new SObjectNotFoundException("Unable to get a sequence id for " + sequenceId, e1);
        }
    }

    int getRangeSize(long sequenceId) {
        Integer rangeSize = this.rangeSizes.get(sequenceId);
        return rangeSize != null ? rangeSize : this.defaultRangeSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateSequence(Connection connection, long nextSequenceId, long tenantId, long id) throws SQLException {
        PreparedStatement updateSequencePreparedStatement = connection.prepareStatement(UPDATE_SEQUENCE);
        try {
            updateSequencePreparedStatement.setObject(1, nextSequenceId);
            updateSequencePreparedStatement.setObject(2, tenantId);
            updateSequencePreparedStatement.setObject(3, id);
            updateSequencePreparedStatement.executeUpdate();
        }
        finally {
            if (updateSequencePreparedStatement != null) {
                updateSequencePreparedStatement.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long selectById(Connection connection, long id, long tenantId) throws SQLException, SObjectNotFoundException {
        PreparedStatement selectByIdPreparedStatement = null;
        try {
            selectByIdPreparedStatement = connection.prepareStatement(SELECT_BY_ID);
            selectByIdPreparedStatement.setLong(1, tenantId);
            selectByIdPreparedStatement.setLong(2, id);
            ResultSet resultSet = selectByIdPreparedStatement.executeQuery();
            try {
                if (resultSet.next()) {
                    long nextId = resultSet.getLong(NEXTID);
                    if (resultSet.wasNull()) {
                        throw new SQLException("Did not expect a null value for the column nextid");
                    }
                    if (resultSet.next()) {
                        throw new SQLException("Did not expect more than one value for tenantId:" + tenantId + " id: " + id);
                    }
                    long l = nextId;
                    return l;
                }
            }
            finally {
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (SQLException e) {}
            }
            throw new SObjectNotFoundException("Found no row for tenantId:" + tenantId + " id: " + id);
        }
        finally {
            if (selectByIdPreparedStatement != null) {
                selectByIdPreparedStatement.close();
            }
        }
    }

    private static void manageException(long sleepTime, Throwable t) {
        t.printStackTrace();
        System.err.println("Optimistic locking failed: " + t);
        System.err.println("Waiting " + sleepTime + " millis");
        try {
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException e) {
            System.err.println("Retry sleeping got interrupted");
        }
    }

    @Override
    public void clear() {
        this.nextAvailableIds.clear();
        this.lastIdInRanges.clear();
    }

    @Override
    public void close() {
    }

    @Override
    public void clear(long tenantId) {
        if (this.nextAvailableIds.containsKey(tenantId)) {
            this.nextAvailableIds.get(tenantId).clear();
        }
        if (this.lastIdInRanges.containsKey(tenantId)) {
            this.lastIdInRanges.get(tenantId).clear();
        }
    }
}

