/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.xml.parse;

import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

public class LogErrorHandler
implements ErrorHandler {
    private final TechnicalLoggerService logger;

    public LogErrorHandler(TechnicalLoggerService logger) {
        this.logger = logger;
    }

    @Override
    public void error(SAXParseException spe) {
        if (this.logger != null && this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.ERROR)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.ERROR, spe.getMessage(), spe);
        }
    }

    @Override
    public void fatalError(SAXParseException spe) {
        if (this.logger != null && this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.ERROR)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.ERROR, spe.getMessage(), spe);
        }
    }

    @Override
    public void warning(SAXParseException spe) {
        if (this.logger != null && this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.ERROR)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.WARNING, spe.getMessage(), spe);
        }
    }
}

