/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.api.CommandAPI;
import org.bonitasoft.engine.api.impl.transaction.command.CreateSCommand;
import org.bonitasoft.engine.api.impl.transaction.command.DeleteAllCommands;
import org.bonitasoft.engine.api.impl.transaction.command.DeleteSCommand;
import org.bonitasoft.engine.api.impl.transaction.command.GetCommands;
import org.bonitasoft.engine.api.impl.transaction.command.GetSCommand;
import org.bonitasoft.engine.api.impl.transaction.command.GetSCommands;
import org.bonitasoft.engine.api.impl.transaction.command.GetTenantCommand;
import org.bonitasoft.engine.api.impl.transaction.command.UpdateSCommand;
import org.bonitasoft.engine.api.impl.transaction.dependency.AddSDependency;
import org.bonitasoft.engine.api.impl.transaction.dependency.DeleteSDependency;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.command.CommandCriterion;
import org.bonitasoft.engine.command.CommandDescriptor;
import org.bonitasoft.engine.command.CommandExecutionException;
import org.bonitasoft.engine.command.CommandNotFoundException;
import org.bonitasoft.engine.command.CommandParameterizationException;
import org.bonitasoft.engine.command.CommandService;
import org.bonitasoft.engine.command.CommandUpdater;
import org.bonitasoft.engine.command.DependencyNotFoundException;
import org.bonitasoft.engine.command.SCommandExecutionException;
import org.bonitasoft.engine.command.SCommandNotFoundException;
import org.bonitasoft.engine.command.SCommandParameterizationException;
import org.bonitasoft.engine.command.TenantCommand;
import org.bonitasoft.engine.command.model.SCommand;
import org.bonitasoft.engine.command.model.SCommandBuilderFactory;
import org.bonitasoft.engine.command.model.SCommandUpdateBuilder;
import org.bonitasoft.engine.command.model.SCommandUpdateBuilderFactory;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.dependency.DependencyService;
import org.bonitasoft.engine.dependency.SDependencyAlreadyExistsException;
import org.bonitasoft.engine.dependency.SDependencyNotFoundException;
import org.bonitasoft.engine.exception.AlreadyExistsException;
import org.bonitasoft.engine.exception.CreationException;
import org.bonitasoft.engine.exception.DeletionException;
import org.bonitasoft.engine.exception.RetrieveException;
import org.bonitasoft.engine.exception.SearchException;
import org.bonitasoft.engine.exception.UpdateException;
import org.bonitasoft.engine.search.SearchCommands;
import org.bonitasoft.engine.search.SearchOptions;
import org.bonitasoft.engine.search.SearchResult;
import org.bonitasoft.engine.search.descriptor.SearchEntitiesDescriptor;
import org.bonitasoft.engine.service.ModelConvertor;
import org.bonitasoft.engine.service.TenantServiceAccessor;
import org.bonitasoft.engine.service.TenantServiceSingleton;
import org.bonitasoft.engine.service.impl.ServiceAccessorFactory;
import org.bonitasoft.engine.sessionaccessor.SessionAccessor;

public class CommandAPIImpl
implements CommandAPI {
    protected static TenantServiceAccessor getTenantAccessor() {
        try {
            SessionAccessor sessionAccessor = ServiceAccessorFactory.getInstance().createSessionAccessor();
            long tenantId = sessionAccessor.getTenantId();
            return TenantServiceSingleton.getInstance(tenantId);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void addDependency(String name, byte[] jar) throws AlreadyExistsException, CreationException {
        TenantServiceAccessor tenantAccessor = CommandAPIImpl.getTenantAccessor();
        DependencyService dependencyService = tenantAccessor.getDependencyService();
        AddSDependency addSDependency = new AddSDependency(dependencyService, name, jar, tenantAccessor.getTenantId(), "tenant");
        try {
            addSDependency.execute();
        }
        catch (SDependencyAlreadyExistsException e) {
            throw new AlreadyExistsException((Throwable)e);
        }
        catch (SBonitaException sbe) {
            throw new CreationException((Throwable)sbe);
        }
    }

    public void removeDependency(String name) throws DependencyNotFoundException, DeletionException {
        TenantServiceAccessor tenantAccessor = CommandAPIImpl.getTenantAccessor();
        DependencyService dependencyService = tenantAccessor.getDependencyService();
        DeleteSDependency deleteSDependency = new DeleteSDependency(dependencyService, name);
        try {
            deleteSDependency.execute();
        }
        catch (SDependencyNotFoundException sdnfe) {
            throw new DependencyNotFoundException((Throwable)sdnfe);
        }
        catch (SBonitaException sbe) {
            throw new DeletionException((Throwable)sbe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandDescriptor register(String name, String description, String implementation) throws AlreadyExistsException, CreationException {
        CommandDescriptor existingCommandDescriptor = null;
        try {
            existingCommandDescriptor = this.getCommand(name);
        }
        catch (CommandNotFoundException notFoundE) {
            if (existingCommandDescriptor != null) {
                throw new AlreadyExistsException("A command with name \"" + name + "\" already exists");
            }
        }
        finally {
            if (existingCommandDescriptor != null) {
                throw new AlreadyExistsException("A command with name \"" + name + "\" already exists");
            }
        }
        TenantServiceAccessor tenantAccessor = CommandAPIImpl.getTenantAccessor();
        CommandService commandService = tenantAccessor.getCommandService();
        SCommandBuilderFactory fact = BuilderFactory.get(SCommandBuilderFactory.class);
        SCommand sCommand = fact.createNewInstance(name, description, implementation).setSystem(false).done();
        try {
            CreateSCommand createCommand = new CreateSCommand(commandService, sCommand);
            createCommand.execute();
            return ModelConvertor.toCommandDescriptor(sCommand);
        }
        catch (SBonitaException sbe) {
            throw new CreationException((Throwable)sbe);
        }
    }

    public Serializable execute(String name, Map<String, Serializable> parameters) throws CommandNotFoundException, CommandParameterizationException, CommandExecutionException {
        TenantServiceAccessor tenantAccessor = CommandAPIImpl.getTenantAccessor();
        CommandService commandService = tenantAccessor.getCommandService();
        try {
            GetTenantCommand getTenantCommand = new GetTenantCommand(commandService, name);
            getTenantCommand.execute();
            TenantCommand command = getTenantCommand.getResult();
            return command.execute(parameters, tenantAccessor);
        }
        catch (SCommandNotFoundException scnfe) {
            throw new CommandNotFoundException((Throwable)scnfe);
        }
        catch (SCommandExecutionException scee) {
            throw new CommandExecutionException((Throwable)scee);
        }
        catch (SCommandParameterizationException scpe) {
            throw new CommandParameterizationException((Throwable)scpe);
        }
        catch (SBonitaException sbe) {
            throw new CommandExecutionException((Throwable)sbe);
        }
    }

    public Serializable execute(long commandId, Map<String, Serializable> parameters) throws CommandNotFoundException, CommandParameterizationException, CommandExecutionException {
        TenantServiceAccessor tenantAccessor = CommandAPIImpl.getTenantAccessor();
        CommandService commandService = tenantAccessor.getCommandService();
        try {
            GetTenantCommand getTenantCommand = new GetTenantCommand(commandService, commandId);
            getTenantCommand.execute();
            TenantCommand command = getTenantCommand.getResult();
            return command.execute(parameters, tenantAccessor);
        }
        catch (SCommandNotFoundException scnfe) {
            throw new CommandNotFoundException((Throwable)scnfe);
        }
        catch (SCommandExecutionException scee) {
            throw new CommandExecutionException((Throwable)scee);
        }
        catch (SCommandParameterizationException scpe) {
            throw new CommandParameterizationException((Throwable)scpe);
        }
        catch (SBonitaException sbe) {
            throw new CommandExecutionException((Throwable)sbe);
        }
    }

    public void unregister(String name) throws CommandNotFoundException, DeletionException {
        if (name == null) {
            throw new DeletionException("Command name can not be null!");
        }
        try {
            TenantServiceAccessor tenantAccessor = CommandAPIImpl.getTenantAccessor();
            CommandService commandService = tenantAccessor.getCommandService();
            DeleteSCommand deleteCommand = new DeleteSCommand(commandService, name);
            deleteCommand.execute();
        }
        catch (SCommandNotFoundException scnfe) {
            throw new CommandNotFoundException((Throwable)scnfe);
        }
        catch (SBonitaException sbe) {
            throw new DeletionException((Throwable)sbe);
        }
    }

    public CommandDescriptor getCommand(String commandName) throws CommandNotFoundException {
        CommandService commandService = CommandAPIImpl.getTenantAccessor().getCommandService();
        try {
            GetSCommand getComandByName = new GetSCommand(commandService, commandName);
            getComandByName.execute();
            SCommand sCommand = getComandByName.getResult();
            return ModelConvertor.toCommandDescriptor(sCommand);
        }
        catch (SBonitaException e) {
            throw new CommandNotFoundException((Throwable)e);
        }
    }

    public List<CommandDescriptor> getAllCommands(int startIndex, int maxResults, CommandCriterion sort) {
        CommandService commandService = CommandAPIImpl.getTenantAccessor().getCommandService();
        try {
            GetSCommands getCommands = new GetSCommands(commandService, startIndex, maxResults, sort);
            getCommands.execute();
            return ModelConvertor.toCommandDescriptors((List<SCommand>)getCommands.getResult());
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    public void update(String commandName, CommandUpdater updateDescriptor) throws UpdateException {
        if (updateDescriptor == null || updateDescriptor.getFields().isEmpty()) {
            throw new UpdateException("The update descriptor does not contain field updates");
        }
        CommandService commandService = CommandAPIImpl.getTenantAccessor().getCommandService();
        SCommandUpdateBuilderFactory fact = BuilderFactory.get(SCommandUpdateBuilderFactory.class);
        SCommandUpdateBuilder commandUpdateBuilder = fact.createNewInstance();
        try {
            UpdateSCommand updateCommand = new UpdateSCommand(commandService, commandUpdateBuilder, commandName, updateDescriptor);
            updateCommand.execute();
        }
        catch (SCommandNotFoundException scnfe) {
            throw new UpdateException((Throwable)scnfe);
        }
        catch (SBonitaException e) {
            throw new UpdateException((Throwable)e);
        }
    }

    public void unregisterAll() throws DeletionException {
        try {
            TenantServiceAccessor tenantAccessor = CommandAPIImpl.getTenantAccessor();
            CommandService commandService = tenantAccessor.getCommandService();
            DeleteAllCommands deleteCommand = new DeleteAllCommands(commandService);
            deleteCommand.execute();
        }
        catch (SBonitaException sbe) {
            throw new DeletionException((Throwable)sbe);
        }
    }

    public List<CommandDescriptor> getUserCommands(int startIndex, int maxResults, CommandCriterion sort) {
        CommandService commandService = CommandAPIImpl.getTenantAccessor().getCommandService();
        try {
            GetCommands getCommands = new GetCommands(commandService, startIndex, maxResults, sort);
            getCommands.execute();
            return ModelConvertor.toCommandDescriptors((List<SCommand>)getCommands.getResult());
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    public CommandDescriptor get(long commandId) throws CommandNotFoundException {
        CommandService commandService = CommandAPIImpl.getTenantAccessor().getCommandService();
        try {
            GetSCommand getComandById = new GetSCommand(commandService, commandId);
            getComandById.execute();
            SCommand sCommand = getComandById.getResult();
            return ModelConvertor.toCommandDescriptor(sCommand);
        }
        catch (SBonitaException e) {
            throw new CommandNotFoundException((Throwable)e);
        }
    }

    public void update(long commandId, CommandUpdater updater) throws UpdateException {
        if (updater == null || updater.getFields().isEmpty()) {
            throw new UpdateException("The update descriptor does not contain field updates");
        }
        CommandService commandService = CommandAPIImpl.getTenantAccessor().getCommandService();
        SCommandUpdateBuilderFactory fact = BuilderFactory.get(SCommandUpdateBuilderFactory.class);
        SCommandUpdateBuilder commandUpdateBuilder = fact.createNewInstance();
        try {
            UpdateSCommand updateCommand = new UpdateSCommand(commandService, commandUpdateBuilder, commandId, updater);
            updateCommand.execute();
        }
        catch (SCommandNotFoundException scnfe) {
            throw new UpdateException((Throwable)scnfe);
        }
        catch (SBonitaException e) {
            throw new UpdateException((Throwable)e);
        }
    }

    public void unregister(long commandId) throws CommandNotFoundException, DeletionException {
        try {
            TenantServiceAccessor tenantAccessor = CommandAPIImpl.getTenantAccessor();
            CommandService commandService = tenantAccessor.getCommandService();
            DeleteSCommand deleteCommand = new DeleteSCommand(commandService, commandId);
            deleteCommand.execute();
        }
        catch (SCommandNotFoundException scnfe) {
            throw new CommandNotFoundException((Throwable)scnfe);
        }
        catch (SBonitaException sbe) {
            throw new DeletionException((Throwable)sbe);
        }
    }

    public SearchResult<CommandDescriptor> searchCommands(SearchOptions searchOptions) throws SearchException {
        TenantServiceAccessor tenantAccessor = CommandAPIImpl.getTenantAccessor();
        CommandService commandService = tenantAccessor.getCommandService();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        SearchCommands searchCommands = new SearchCommands(commandService, searchEntitiesDescriptor.getSearchCommandDescriptor(), searchOptions);
        try {
            searchCommands.execute();
            return searchCommands.getResult();
        }
        catch (SBonitaException sbe) {
            throw new SearchException((Throwable)sbe);
        }
    }
}

