/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Callable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.bonitasoft.engine.api.PlatformAPI;
import org.bonitasoft.engine.api.impl.AvailableOnStoppedNode;
import org.bonitasoft.engine.api.impl.NodeConfiguration;
import org.bonitasoft.engine.api.impl.PlatformAPIImplDelegate;
import org.bonitasoft.engine.api.impl.transaction.CustomTransactions;
import org.bonitasoft.engine.api.impl.transaction.platform.ActivateTenant;
import org.bonitasoft.engine.api.impl.transaction.platform.CheckPlatformVersion;
import org.bonitasoft.engine.api.impl.transaction.platform.CleanPlatformTableContent;
import org.bonitasoft.engine.api.impl.transaction.platform.DeactivateTenant;
import org.bonitasoft.engine.api.impl.transaction.platform.DeleteAllTenants;
import org.bonitasoft.engine.api.impl.transaction.platform.DeletePlatformContent;
import org.bonitasoft.engine.api.impl.transaction.platform.DeletePlatformTableContent;
import org.bonitasoft.engine.api.impl.transaction.platform.DeleteTenant;
import org.bonitasoft.engine.api.impl.transaction.platform.DeleteTenantObjects;
import org.bonitasoft.engine.api.impl.transaction.platform.GetDefaultTenantInstance;
import org.bonitasoft.engine.api.impl.transaction.platform.GetPlatformContent;
import org.bonitasoft.engine.api.impl.transaction.platform.IsPlatformCreated;
import org.bonitasoft.engine.api.impl.transaction.platform.RefreshPlatformClassLoader;
import org.bonitasoft.engine.api.impl.transaction.platform.RefreshTenantClassLoaders;
import org.bonitasoft.engine.api.impl.transaction.profile.ImportProfiles;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.classloader.ClassLoaderException;
import org.bonitasoft.engine.command.CommandDescriptor;
import org.bonitasoft.engine.command.CommandService;
import org.bonitasoft.engine.command.DefaultCommandProvider;
import org.bonitasoft.engine.command.SCommandAlreadyExistsException;
import org.bonitasoft.engine.command.SCommandCreationException;
import org.bonitasoft.engine.command.model.SCommand;
import org.bonitasoft.engine.command.model.SCommandBuilderFactory;
import org.bonitasoft.engine.commons.RestartHandler;
import org.bonitasoft.engine.commons.ServiceWithLifecycle;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.io.IOUtil;
import org.bonitasoft.engine.commons.transaction.TransactionContent;
import org.bonitasoft.engine.commons.transaction.TransactionExecutor;
import org.bonitasoft.engine.data.DataService;
import org.bonitasoft.engine.data.SDataException;
import org.bonitasoft.engine.data.SDataSourceAlreadyExistException;
import org.bonitasoft.engine.data.model.SDataSource;
import org.bonitasoft.engine.data.model.SDataSourceState;
import org.bonitasoft.engine.data.model.builder.SDataSourceBuilderFactory;
import org.bonitasoft.engine.dependency.SDependencyException;
import org.bonitasoft.engine.exception.BonitaHomeConfigurationException;
import org.bonitasoft.engine.exception.BonitaHomeNotSetException;
import org.bonitasoft.engine.exception.CreationException;
import org.bonitasoft.engine.exception.DeletionException;
import org.bonitasoft.engine.execution.work.TenantRestartHandler;
import org.bonitasoft.engine.home.BonitaHomeServer;
import org.bonitasoft.engine.identity.IdentityService;
import org.bonitasoft.engine.io.PropertiesManager;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.platform.Platform;
import org.bonitasoft.engine.platform.PlatformNotFoundException;
import org.bonitasoft.engine.platform.PlatformService;
import org.bonitasoft.engine.platform.PlatformState;
import org.bonitasoft.engine.platform.SDeletingActivatedTenantException;
import org.bonitasoft.engine.platform.STenantActivationException;
import org.bonitasoft.engine.platform.STenantCreationException;
import org.bonitasoft.engine.platform.STenantDeactivationException;
import org.bonitasoft.engine.platform.STenantDeletionException;
import org.bonitasoft.engine.platform.STenantNotFoundException;
import org.bonitasoft.engine.platform.StartNodeException;
import org.bonitasoft.engine.platform.StopNodeException;
import org.bonitasoft.engine.platform.model.SPlatform;
import org.bonitasoft.engine.platform.model.STenant;
import org.bonitasoft.engine.platform.model.builder.SPlatformBuilderFactory;
import org.bonitasoft.engine.platform.model.builder.STenantBuilderFactory;
import org.bonitasoft.engine.profile.ProfileService;
import org.bonitasoft.engine.scheduler.SchedulerService;
import org.bonitasoft.engine.service.ModelConvertor;
import org.bonitasoft.engine.service.PlatformServiceAccessor;
import org.bonitasoft.engine.service.TenantServiceAccessor;
import org.bonitasoft.engine.service.impl.ServiceAccessorFactory;
import org.bonitasoft.engine.session.SessionService;
import org.bonitasoft.engine.session.model.SSession;
import org.bonitasoft.engine.sessionaccessor.SessionAccessor;
import org.bonitasoft.engine.transaction.STransactionException;
import org.bonitasoft.engine.transaction.TransactionService;
import org.bonitasoft.engine.work.WorkService;
import org.bonitasoft.engine.xml.Parser;

public class PlatformAPIImpl
implements PlatformAPI {
    private static final String STATUS_DEACTIVATED = "DEACTIVATED";
    private static final String PROFILES_FILE = "profiles.xml";
    private static boolean isNodeStarted = false;
    private final PlatformAPIImplDelegate delegate;

    public PlatformAPIImpl() {
        this.delegate = new PlatformAPIImplDelegate();
    }

    public PlatformAPIImpl(PlatformAPIImplDelegate delegate) {
        this.delegate = delegate;
    }

    protected PlatformAPIImplDelegate getDelegate() {
        return this.delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CustomTransactions
    @AvailableOnStoppedNode
    public void createPlatform() throws CreationException {
        PlatformServiceAccessor platformAccessor;
        try {
            platformAccessor = this.getPlatformAccessor();
        }
        catch (Exception e) {
            throw new CreationException((Throwable)e);
        }
        PlatformService platformService = platformAccessor.getPlatformService();
        TransactionService transactionService = platformAccessor.getTransactionService();
        try {
            SPlatform platform = this.constructPlatform(platformAccessor);
            platformService.createPlatformTables();
            platformService.createTenantTables();
            transactionService.begin();
            try {
                platformService.initializePlatformStructure();
            }
            finally {
                transactionService.complete();
            }
            transactionService.begin();
            try {
                platformService.createPlatform(platform);
                platformService.getPlatform();
            }
            finally {
                transactionService.complete();
            }
        }
        catch (SBonitaException e) {
            throw new CreationException("Platform Creation failed.", (Throwable)e);
        }
    }

    @CustomTransactions
    @AvailableOnStoppedNode
    public void initializePlatform() throws CreationException {
        PlatformServiceAccessor platformAccessor;
        try {
            platformAccessor = this.getPlatformAccessor();
        }
        catch (Exception e) {
            throw new CreationException((Throwable)e);
        }
        PlatformService platformService = platformAccessor.getPlatformService();
        TransactionService transactionService = platformAccessor.getTransactionService();
        TechnicalLoggerService technicalLoggerService = platformAccessor.getTechnicalLoggerService();
        try {
            transactionService.begin();
            try {
                this.createDefaultTenant(platformAccessor, platformService, transactionService);
                this.activateDefaultTenant();
            }
            catch (SBonitaException e) {
                if (technicalLoggerService.isLoggable(this.getClass(), TechnicalLogSeverity.WARNING)) {
                    technicalLoggerService.log(this.getClass(), TechnicalLogSeverity.WARNING, e);
                }
                throw new CreationException("Platform initialisation failed.", (Throwable)e);
            }
            finally {
                transactionService.complete();
            }
        }
        catch (STransactionException e1) {
            throw new CreationException((Throwable)e1);
        }
    }

    @CustomTransactions
    @AvailableOnStoppedNode
    public void createAndInitializePlatform() throws CreationException {
        this.createPlatform();
        this.initializePlatform();
    }

    protected PlatformServiceAccessor getPlatformAccessor() throws BonitaHomeNotSetException, InstantiationException, IllegalAccessException, ClassNotFoundException, IOException, BonitaHomeConfigurationException {
        return ServiceAccessorFactory.getInstance().createPlatformServiceAccessor();
    }

    private SPlatform constructPlatform(PlatformServiceAccessor platformAccessor) {
        PlatformService platformService = platformAccessor.getPlatformService();
        String version = platformService.getSPlatformProperties().getPlatformVersion();
        String previousVersion = "";
        String initialVersion = version;
        String createdBy = "platformAdmin";
        long created = System.currentTimeMillis();
        return BuilderFactory.get(SPlatformBuilderFactory.class).createNewInstance(version, "", initialVersion, "platformAdmin", created).done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CustomTransactions
    @AvailableOnStoppedNode
    public void startNode() throws StartNodeException {
        PlatformServiceAccessor platformAccessor;
        SessionAccessor sessionAccessor = null;
        try {
            platformAccessor = this.getPlatformAccessor();
            sessionAccessor = ServiceAccessorFactory.getInstance().createSessionAccessor();
        }
        catch (Exception e) {
            throw new StartNodeException((Throwable)e);
        }
        NodeConfiguration platformConfiguration = platformAccessor.getPlaformConfiguration();
        SchedulerService schedulerService = platformAccessor.getSchedulerService();
        WorkService workService = platformAccessor.getWorkService();
        List<ServiceWithLifecycle> otherServicesToStart = platformAccessor.getServicesToStart();
        try {
            try {
                PlatformService platformService = platformAccessor.getPlatformService();
                TransactionExecutor executor = platformAccessor.getTransactionExecutor();
                CheckPlatformVersion checkPlatformVersion = new CheckPlatformVersion(platformService, BonitaHomeServer.getInstance());
                executor.execute(checkPlatformVersion);
                if (!checkPlatformVersion.sameVersion().booleanValue()) {
                    throw new StartNodeException(checkPlatformVersion.getErrorMessage());
                }
                for (ServiceWithLifecycle serviceWithLifecycle : otherServicesToStart) {
                    serviceWithLifecycle.start();
                }
                RefreshPlatformClassLoader refreshPlatformClassLoader = new RefreshPlatformClassLoader(platformAccessor);
                executor.execute(refreshPlatformClassLoader);
                Object tenantIds = refreshPlatformClassLoader.getResult();
                SessionService sessionService = platformAccessor.getSessionService();
                Iterator<Object> i$ = tenantIds.iterator();
                while (i$.hasNext()) {
                    Long tenantId = (Long)i$.next();
                    long sessionId = -1L;
                    long platformSessionId = -1L;
                    try {
                        platformSessionId = sessionAccessor.getSessionId();
                        sessionAccessor.deleteSessionId();
                        sessionId = this.createSessionAndMakeItActive(tenantId, sessionAccessor, sessionService);
                        TenantServiceAccessor tenantServiceAccessor = platformAccessor.getTenantServiceAccessor(tenantId);
                        TransactionExecutor tenantExecutor = tenantServiceAccessor.getTransactionExecutor();
                        tenantExecutor.execute(new RefreshTenantClassLoaders(tenantServiceAccessor, tenantId));
                    }
                    finally {
                        sessionService.deleteSession(sessionId);
                        this.cleanSessionAccessor(sessionAccessor, platformSessionId);
                    }
                }
                workService.start();
                if (!this.isNodeStarted()) {
                    if (platformConfiguration.shouldStartScheduler() && !schedulerService.isStarted()) {
                        schedulerService.start();
                    }
                    if (platformConfiguration.shouldResumeElements()) {
                        GetDefaultTenantInstance getDefaultTenantInstance = new GetDefaultTenantInstance(platformService);
                        platformAccessor.getTransactionExecutor().execute(getDefaultTenantInstance);
                        STenant defaultTenant = getDefaultTenantInstance.getResult();
                        long tenantId = defaultTenant.getId();
                        final TenantServiceAccessor tenantServiceAccessor = this.getTenantServiceAccessor(tenantId);
                        long sessionId = this.createSessionAndMakeItActive(defaultTenant.getId(), sessionAccessor, sessionService);
                        for (final TenantRestartHandler restartHandler : platformConfiguration.getTenantRestartHandlers()) {
                            Callable<Void> callable = new Callable<Void>(){

                                @Override
                                public Void call() throws Exception {
                                    restartHandler.handleRestart(platformAccessor, tenantServiceAccessor);
                                    return null;
                                }
                            };
                            tenantServiceAccessor.getTransactionService().executeInTransaction(callable);
                        }
                        sessionService.deleteSession(sessionId);
                    }
                    for (RestartHandler restartHandler : platformConfiguration.getRestartHandlers()) {
                        restartHandler.execute();
                    }
                }
            }
            catch (ClassLoaderException e) {
                throw new StartNodeException("Platform starting failed while initializing platform classloaders.", (Throwable)e);
            }
            catch (SDependencyException e) {
                throw new StartNodeException("Platform starting failed while initializing platform classloaders.", (Throwable)e);
            }
            catch (StartNodeException sne) {
                throw sne;
            }
            catch (Exception e) {
                throw new StartNodeException("Platform starting failed.", (Throwable)e);
            }
            finally {
                this.cleanSessionAccessor(sessionAccessor, -1L);
            }
            isNodeStarted = true;
        }
        catch (StartNodeException e) {
            try {
                this.shutdownScheduler(schedulerService);
            }
            catch (Exception exp) {
                throw new StartNodeException("Platform stoping failed : " + exp.getMessage(), (Throwable)e);
            }
            throw e;
        }
    }

    protected TenantServiceAccessor getTenantServiceAccessor(long tenantId) throws SBonitaException, BonitaHomeNotSetException, IOException, BonitaHomeConfigurationException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        return ServiceAccessorFactory.getInstance().createTenantServiceAccessor(tenantId);
    }

    @CustomTransactions
    @AvailableOnStoppedNode
    public void stopNode() throws StopNodeException {
        try {
            PlatformServiceAccessor platformAccessor = this.getPlatformAccessor();
            List<ServiceWithLifecycle> otherServicesToStart = platformAccessor.getServicesToStart();
            SchedulerService schedulerService = platformAccessor.getSchedulerService();
            NodeConfiguration plaformConfiguration = platformAccessor.getPlaformConfiguration();
            if (plaformConfiguration.shouldStartScheduler()) {
                this.shutdownScheduler(schedulerService);
            }
            WorkService workService = platformAccessor.getWorkService();
            workService.stop();
            if (plaformConfiguration.shouldClearSessions()) {
                platformAccessor.getSessionService().deleteSessions();
            }
            for (ServiceWithLifecycle serviceWithLifecycle : otherServicesToStart) {
                serviceWithLifecycle.stop();
            }
            isNodeStarted = false;
        }
        catch (SBonitaException e) {
            throw new StopNodeException((Throwable)e);
        }
        catch (BonitaHomeNotSetException e) {
            throw new StopNodeException((Throwable)e);
        }
        catch (InstantiationException e) {
            throw new StopNodeException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new StopNodeException((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new StopNodeException((Throwable)e);
        }
        catch (IOException e) {
            throw new StopNodeException((Throwable)e);
        }
        catch (BonitaHomeConfigurationException e) {
            throw new StopNodeException(e.getMessage());
        }
        catch (Exception e) {
            throw new StopNodeException((Throwable)e);
        }
    }

    private void shutdownScheduler(SchedulerService schedulerService) throws Exception {
        if (this.isNodeStarted()) {
            schedulerService.stop();
        }
    }

    @CustomTransactions
    @AvailableOnStoppedNode
    public void cleanPlatform() throws DeletionException {
        PlatformServiceAccessor platformAccessor;
        try {
            platformAccessor = this.getPlatformAccessor();
        }
        catch (Exception e) {
            throw new DeletionException((Throwable)e);
        }
        PlatformService platformService = platformAccessor.getPlatformService();
        TransactionService transactionService = platformAccessor.getTransactionService();
        final CleanPlatformTableContent clean = new CleanPlatformTableContent(platformService);
        final DeleteAllTenants deleteAll = new DeleteAllTenants(platformService);
        try {
            transactionService.executeInTransaction(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    try {
                        STenant tenant = PlatformAPIImpl.this.getDefaultTenant();
                        PlatformAPIImpl.this.deactiveTenant(tenant.getId());
                    }
                    catch (STenantNotFoundException sTenantNotFoundException) {
                        // empty catch block
                    }
                    clean.execute();
                    deleteAll.execute();
                    return null;
                }
            });
        }
        catch (Exception e) {
            throw new DeletionException((Throwable)e);
        }
    }

    @CustomTransactions
    @AvailableOnStoppedNode
    public void deletePlatform() throws DeletionException {
        PlatformServiceAccessor platformAccessor;
        try {
            platformAccessor = this.getPlatformAccessor();
        }
        catch (Exception e) {
            throw new DeletionException((Throwable)e);
        }
        final PlatformService platformService = platformAccessor.getPlatformService();
        TransactionExecutor transactionExecutor = platformAccessor.getTransactionExecutor();
        DeletePlatformContent deletePlatformContent = new DeletePlatformContent(platformService);
        try {
            TransactionContent deleteTenantTables = new TransactionContent(){

                @Override
                public void execute() throws SBonitaException {
                    platformService.deleteTenantTables();
                }
            };
            transactionExecutor.execute(deletePlatformContent);
            transactionExecutor.execute(deleteTenantTables);
            DeletePlatformTableContent deletePlatformTableContent = new DeletePlatformTableContent(platformService);
            transactionExecutor.execute(deletePlatformTableContent);
        }
        catch (SBonitaException e) {
            throw new DeletionException((Throwable)e);
        }
    }

    @CustomTransactions
    @AvailableOnStoppedNode
    public void cleanAndDeletePlaftorm() throws DeletionException {
        this.cleanPlatform();
        this.deletePlatform();
    }

    @AvailableOnStoppedNode
    public Platform getPlatform() throws PlatformNotFoundException {
        PlatformServiceAccessor platformAccessor;
        try {
            platformAccessor = this.getPlatformAccessor();
        }
        catch (Exception e) {
            throw new PlatformNotFoundException((Throwable)e);
        }
        PlatformService platformService = platformAccessor.getPlatformService();
        GetPlatformContent transactionContent = new GetPlatformContent(platformService);
        try {
            transactionContent.execute();
        }
        catch (SBonitaException e) {
            throw new PlatformNotFoundException((Throwable)e);
        }
        SPlatform sPlatform = transactionContent.getResult();
        return ModelConvertor.toPlatform(sPlatform);
    }

    private void createDefaultTenant(PlatformServiceAccessor platformAccessor, PlatformService platformService, TransactionService transactionService) throws STenantCreationException {
        String tenantName = "default";
        String description = "Default tenant";
        String userName = "";
        SessionAccessor sessionAccessor = null;
        long platformSessionId = -1L;
        try {
            String sourceDir;
            String targetDir;
            String createdBy = "defaultUser";
            STenant tenant = BuilderFactory.get(STenantBuilderFactory.class).createNewInstance("default", "defaultUser", System.currentTimeMillis(), STATUS_DEACTIVATED, true).setDescription("Default tenant").done();
            Long tenantId = platformService.createTenant(tenant);
            transactionService.complete();
            transactionService.begin();
            try {
                BonitaHomeServer home = BonitaHomeServer.getInstance();
                targetDir = home.getTenantsFolder() + File.separator + tenant.getId();
                sourceDir = home.getTenantTemplateFolder();
            }
            catch (Exception e) {
                this.deleteTenant(tenant.getId());
                throw new STenantCreationException("Bonita home not set!");
            }
            try {
                FileUtils.copyDirectory((File)new File(sourceDir), (File)new File(targetDir));
            }
            catch (IOException e) {
                IOUtil.deleteDir(new File(targetDir));
                this.deleteTenant(tenant.getId());
                throw new STenantCreationException("Copy File Exception!");
            }
            try {
                userName = this.getUserName(tenantId);
            }
            catch (Exception e) {
                IOUtil.deleteDir(new File(targetDir));
                this.deleteTenant(tenant.getId());
                throw new STenantCreationException("Access File Exception!");
            }
            TenantServiceAccessor tenantServiceAccessor = platformAccessor.getTenantServiceAccessor(tenantId);
            SessionService sessionService = platformAccessor.getSessionService();
            sessionAccessor = ServiceAccessorFactory.getInstance().createSessionAccessor();
            SSession session = sessionService.createSession(tenantId, -1L, userName, true);
            platformSessionId = sessionAccessor.getSessionId();
            sessionAccessor.deleteSessionId();
            sessionAccessor.setSessionInfo(session.getId(), tenantId);
            this.createDefaultDataSource(tenantServiceAccessor);
            this.createDefaultCommands(tenantServiceAccessor);
            this.createDefaultProfiles(tenantServiceAccessor);
            this.getDelegate().createDefaultThemes(tenantServiceAccessor);
            sessionService.deleteSession(session.getId());
            this.cleanSessionAccessor(sessionAccessor, platformSessionId);
        }
        catch (Exception e) {
            try {
                throw new STenantCreationException("Unable to create tenant default", e);
            }
            catch (Throwable throwable) {
                this.cleanSessionAccessor(sessionAccessor, platformSessionId);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createDefaultProfiles(TenantServiceAccessor tenantServiceAccessor) throws Exception {
        String xmlContent;
        Parser parser = tenantServiceAccessor.getProfileParser();
        ProfileService profileService = tenantServiceAccessor.getProfileService();
        IdentityService identityService = tenantServiceAccessor.getIdentityService();
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.getProfileFileName());
        if (inputStream == null) {
            return;
        }
        try {
            xmlContent = IOUtils.toString((InputStream)inputStream, (String)"UTF-8");
        }
        finally {
            inputStream.close();
        }
        StringReader reader = new StringReader(xmlContent);
        try {
            parser.validate(reader);
            reader.close();
            reader = new StringReader(xmlContent);
            List profiles = (List)parser.getObjectFromXML(reader);
            ImportProfiles importProfiles = new ImportProfiles(profileService, identityService, profiles, -1L);
            importProfiles.execute();
        }
        finally {
            reader.close();
        }
    }

    protected void cleanSessionAccessor(SessionAccessor sessionAccessor, long platformSessionId) {
        if (sessionAccessor != null) {
            sessionAccessor.deleteSessionId();
            if (platformSessionId != -1L) {
                sessionAccessor.setSessionInfo(platformSessionId, -1L);
            }
        }
    }

    protected void createDefaultCommands(TenantServiceAccessor tenantServiceAccessor) throws SCommandAlreadyExistsException, SCommandCreationException {
        CommandService commandService = tenantServiceAccessor.getCommandService();
        DefaultCommandProvider provider = tenantServiceAccessor.getDefaultCommandProvider();
        SCommandBuilderFactory fact = BuilderFactory.get(SCommandBuilderFactory.class);
        for (CommandDescriptor command : provider.getDefaultCommands()) {
            SCommand sCommand = fact.createNewInstance(command.getName(), command.getDescription(), command.getImplementation()).setSystem(true).done();
            commandService.create(sCommand);
        }
    }

    protected void createDefaultDataSource(TenantServiceAccessor tenantServiceAccessor) throws SDataSourceAlreadyExistException, SDataException {
        DataService dataService = tenantServiceAccessor.getDataService();
        SDataSource bonitaDataSource = BuilderFactory.get(SDataSourceBuilderFactory.class).createNewInstance("bonita_data_source", "6.0", SDataSourceState.ACTIVE, "org.bonitasoft.engine.data.instance.DataInstanceDataSourceImpl").done();
        dataService.createDataSource(bonitaDataSource);
        SDataSource transientDataSource = BuilderFactory.get(SDataSourceBuilderFactory.class).createNewInstance("bonita_transient_data_source", "6.0", SDataSourceState.ACTIVE, "org.bonitasoft.engine.core.data.instance.impl.TransientDataInstanceDataSource").done();
        dataService.createDataSource(transientDataSource);
    }

    private String getUserName(long tenantId) throws IOException, BonitaHomeNotSetException {
        String tenantPath = BonitaHomeServer.getInstance().getTenantConfFolder(tenantId) + File.separator + "bonita-server.properties";
        File file = new File(tenantPath);
        Properties properties = PropertiesManager.getProperties((File)file);
        return properties.getProperty("userName");
    }

    private void deleteTenant(long tenantId) throws STenantDeletionException {
        PlatformServiceAccessor platformAccessor = null;
        try {
            platformAccessor = this.getPlatformAccessor();
            PlatformService platformService = platformAccessor.getPlatformService();
            TransactionExecutor transactionExecutor = platformAccessor.getTransactionExecutor();
            DeleteTenantObjects transactionContentForTenantObjects = new DeleteTenantObjects(tenantId, platformService);
            transactionExecutor.execute(transactionContentForTenantObjects);
            DeleteTenant transactionContentForTenant = new DeleteTenant(tenantId, platformService);
            transactionExecutor.execute(transactionContentForTenant);
            String targetDir = BonitaHomeServer.getInstance().getTenantsFolder() + File.separator + tenantId;
            IOUtil.deleteDir(new File(targetDir));
        }
        catch (STenantNotFoundException e) {
            this.log(platformAccessor, e);
            throw new STenantDeletionException(e);
        }
        catch (SDeletingActivatedTenantException e) {
            this.log(platformAccessor, e);
            throw new STenantDeletionException("Unable to delete an activated tenant " + tenantId);
        }
        catch (Exception e) {
            this.log(platformAccessor, e);
            throw new STenantDeletionException(e);
        }
    }

    private void activateDefaultTenant() throws STenantActivationException {
        PlatformServiceAccessor platformAccessor = null;
        SessionAccessor sessionAccessor = null;
        SchedulerService schedulerService = null;
        boolean schedulerStarted = false;
        long platformSessionId = -1L;
        try {
            platformAccessor = this.getPlatformAccessor();
            sessionAccessor = ServiceAccessorFactory.getInstance().createSessionAccessor();
            STenant tenant = this.getDefaultTenant();
            long tenantId = tenant.getId();
            PlatformService platformService = platformAccessor.getPlatformService();
            schedulerService = platformAccessor.getSchedulerService();
            SessionService sessionService = platformAccessor.getSessionService();
            NodeConfiguration plaformConfiguration = platformAccessor.getPlaformConfiguration();
            WorkService workService = platformAccessor.getWorkService();
            schedulerService.start();
            platformSessionId = sessionAccessor.getSessionId();
            sessionAccessor.deleteSessionId();
            long sessionId = this.createSessionAndMakeItActive(tenantId, sessionAccessor, sessionService);
            ActivateTenant activateTenant = new ActivateTenant(tenantId, platformService, schedulerService, plaformConfiguration, platformAccessor.getTechnicalLoggerService(), workService);
            activateTenant.execute();
            sessionService.deleteSession(sessionId);
        }
        catch (STenantActivationException stae) {
            this.log(platformAccessor, stae);
            throw stae;
        }
        catch (STenantNotFoundException stnfe) {
            this.log(platformAccessor, stnfe);
            throw new STenantActivationException(stnfe);
        }
        catch (Exception e) {
            this.log(platformAccessor, e);
            throw new STenantActivationException(e);
        }
        finally {
            this.cleanSessionAccessor(sessionAccessor, platformSessionId);
        }
    }

    protected Long createSession(long tenantId, SessionService sessionService) throws SBonitaException {
        return sessionService.createSession(tenantId, "system").getId();
    }

    private void log(PlatformServiceAccessor platformAccessor, Exception e) {
        if (platformAccessor != null) {
            TechnicalLoggerService logger = platformAccessor.getTechnicalLoggerService();
            if (logger.isLoggable(this.getClass(), TechnicalLogSeverity.ERROR)) {
                logger.log(this.getClass(), TechnicalLogSeverity.ERROR, e);
            }
        } else {
            e.printStackTrace();
        }
    }

    private void deactiveTenant(long tenantId) throws STenantDeactivationException {
        PlatformServiceAccessor platformAccessor = null;
        SessionAccessor sessionAccessor = null;
        long platformSessionId = -1L;
        try {
            platformAccessor = this.getPlatformAccessor();
            sessionAccessor = ServiceAccessorFactory.getInstance().createSessionAccessor();
            PlatformService platformService = platformAccessor.getPlatformService();
            SchedulerService schedulerService = platformAccessor.getSchedulerService();
            SessionService sessionService = platformAccessor.getSessionService();
            WorkService workService = platformAccessor.getWorkService();
            long sessionId = this.createSession(tenantId, sessionService);
            platformSessionId = sessionAccessor.getSessionId();
            sessionAccessor.deleteSessionId();
            DeactivateTenant transactionContent = new DeactivateTenant(tenantId, platformService, schedulerService, workService, sessionService);
            transactionContent.execute();
            sessionService.deleteSession(sessionId);
            sessionService.deleteSessionsOfTenant(tenantId);
        }
        catch (STenantDeactivationException stde) {
            this.log(platformAccessor, stde);
            throw stde;
        }
        catch (Exception e) {
            this.log(platformAccessor, e);
            throw new STenantDeactivationException("Tenant deactivation failed.", e);
        }
        finally {
            this.cleanSessionAccessor(sessionAccessor, platformSessionId);
        }
    }

    private long createSessionAndMakeItActive(long tenantId, SessionAccessor sessionAccessor, SessionService sessionService) throws SBonitaException {
        long sessionId = this.createSession(tenantId, sessionService);
        sessionAccessor.setSessionInfo(sessionId, tenantId);
        return sessionId;
    }

    @CustomTransactions
    @AvailableOnStoppedNode
    public boolean isPlatformCreated() throws PlatformNotFoundException {
        PlatformServiceAccessor platformAccessor;
        try {
            platformAccessor = this.getPlatformAccessor();
        }
        catch (Exception e) {
            throw new PlatformNotFoundException((Throwable)e);
        }
        PlatformService platformService = platformAccessor.getPlatformService();
        TransactionExecutor transactionExecutor = platformAccessor.getTransactionExecutor();
        IsPlatformCreated transactionContent = new IsPlatformCreated(platformService);
        try {
            transactionExecutor.execute(transactionContent);
            return (Boolean)transactionContent.getResult();
        }
        catch (SBonitaException e) {
            return false;
        }
    }

    @CustomTransactions
    @AvailableOnStoppedNode
    public PlatformState getPlatformState() {
        if (this.isNodeStarted()) {
            return PlatformState.STARTED;
        }
        return PlatformState.STOPPED;
    }

    private STenant getDefaultTenant() throws STenantNotFoundException {
        PlatformServiceAccessor platformAccessor = null;
        try {
            platformAccessor = this.getPlatformAccessor();
            PlatformService platformService = platformAccessor.getPlatformService();
            return platformService.getDefaultTenant();
        }
        catch (SBonitaException e) {
            this.log(platformAccessor, e);
            throw new STenantNotFoundException("Unable to retrieve the defaultTenant", e);
        }
        catch (Exception e) {
            this.log(platformAccessor, e);
            throw new STenantNotFoundException("Unable to retrieve the defaultTenant", e);
        }
    }

    @AvailableOnStoppedNode
    public boolean isNodeStarted() {
        return isNodeStarted;
    }

    protected String getProfileFileName() {
        return PROFILES_FILE;
    }
}

