/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl.transaction.document;

import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.transaction.TransactionContentWithResult;
import org.bonitasoft.engine.core.process.document.api.ProcessDocumentService;
import org.bonitasoft.engine.core.process.document.model.SProcessDocument;
import org.bonitasoft.engine.core.process.instance.api.ActivityInstanceService;
import org.bonitasoft.engine.core.process.instance.model.archive.SAActivityInstance;

public class GetDocumentByNameAtActivityCompletion
implements TransactionContentWithResult<SProcessDocument> {
    private final ProcessDocumentService processDocumentService;
    private final long activityInstanceId;
    private SProcessDocument result;
    private final String documentName;
    private final ActivityInstanceService activityInstanceService;

    public GetDocumentByNameAtActivityCompletion(ProcessDocumentService processDocumentService, long activityInstanceId, String documentName, ActivityInstanceService activityInstanceService) {
        this.processDocumentService = processDocumentService;
        this.activityInstanceId = activityInstanceId;
        this.documentName = documentName;
        this.activityInstanceService = activityInstanceService;
    }

    @Override
    public void execute() throws SBonitaException {
        SAActivityInstance aactivity = this.activityInstanceService.getMostRecentArchivedActivityInstance(this.activityInstanceId);
        this.result = this.processDocumentService.getDocument(aactivity.getRootContainerId(), this.documentName, aactivity.getArchiveDate());
    }

    @Override
    public SProcessDocument getResult() {
        return this.result;
    }
}

