/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl.transaction.identity;

import java.util.List;
import org.bonitasoft.engine.actor.mapping.ActorMappingService;
import org.bonitasoft.engine.actor.mapping.SActorMemberDeletionException;
import org.bonitasoft.engine.actor.mapping.SActorMemberNotFoundException;
import org.bonitasoft.engine.actor.mapping.model.SActorMember;
import org.bonitasoft.engine.api.impl.transaction.identity.DeleteWithActorMembers;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.transaction.TransactionContent;
import org.bonitasoft.engine.identity.IdentityService;
import org.bonitasoft.engine.identity.SIdentityException;
import org.bonitasoft.engine.identity.model.SUserMembership;
import org.bonitasoft.engine.persistence.OrderByType;
import org.bonitasoft.engine.persistence.SBonitaReadException;
import org.bonitasoft.engine.profile.ProfileService;
import org.bonitasoft.engine.profile.builder.SProfileMemberBuilderFactory;
import org.bonitasoft.engine.profile.model.SProfileMember;

public class DeleteUsers
extends DeleteWithActorMembers
implements TransactionContent {
    private final IdentityService identityService;
    private final ActorMappingService actorMappingService;
    private final ProfileService profileService;
    private final List<Long> userIds;

    public DeleteUsers(IdentityService identityService, ActorMappingService actorMappingService, ProfileService profileService, List<Long> userIds) {
        this.identityService = identityService;
        this.actorMappingService = actorMappingService;
        this.userIds = userIds;
        this.profileService = profileService;
    }

    @Override
    public void execute() throws SBonitaException {
        for (Long userId : this.userIds) {
            this.deleteUserMembershipsByUser(userId);
            this.deleteActorMembers(userId);
            this.deleteProfileMembers(userId);
            this.identityService.deleteUser(userId);
        }
    }

    private void deleteActorMembers(Long userId) throws SActorMemberNotFoundException, SActorMemberDeletionException, SBonitaReadException {
        List<SActorMember> actorMembers = this.actorMappingService.getActorMembersOfUser(userId);
        for (SActorMember sActorMember : actorMembers) {
            this.setActorIdsOfRemovedElements(this.actorMappingService.removeActorMember(sActorMember.getId()));
        }
    }

    private void deleteProfileMembers(Long userId) throws SBonitaException {
        List<SProfileMember> profileMembers;
        String field = BuilderFactory.get(SProfileMemberBuilderFactory.class).getIdKey();
        int numberOfElements = 1000;
        do {
            profileMembers = this.profileService.getProfileMembersOfUser(userId, 0, 1000, field, OrderByType.ASC);
            while (profileMembers != null && !profileMembers.isEmpty()) {
                for (SProfileMember sProfileMember : profileMembers) {
                    this.profileService.deleteProfileMember(sProfileMember);
                }
            }
        } while (profileMembers != null && profileMembers.size() > 0);
    }

    private void deleteUserMembershipsByUser(long userId) throws SIdentityException {
        List<SUserMembership> sUserMemberships = this.identityService.getUserMembershipsOfUser(userId);
        for (SUserMembership sUserMembership : sUserMemberships) {
            this.identityService.deleteUserMembership(sUserMembership.getId());
        }
    }
}

