/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.data.instance;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.commons.CollectionUtil;
import org.bonitasoft.engine.commons.NullCheckingUtil;
import org.bonitasoft.engine.data.DataSourceConfiguration;
import org.bonitasoft.engine.data.instance.DataInstanceDataSource;
import org.bonitasoft.engine.data.instance.PersistentDataInstanceDataSourceConfiguration;
import org.bonitasoft.engine.data.instance.exception.SCreateDataInstanceException;
import org.bonitasoft.engine.data.instance.exception.SDataInstanceException;
import org.bonitasoft.engine.data.instance.exception.SDataInstanceNotFoundException;
import org.bonitasoft.engine.data.instance.exception.SDeleteDataInstanceException;
import org.bonitasoft.engine.data.instance.exception.SUpdateDataInstanceException;
import org.bonitasoft.engine.data.instance.model.SDataInstance;
import org.bonitasoft.engine.data.instance.model.builder.SDataInstanceBuilderFactory;
import org.bonitasoft.engine.events.model.SDeleteEvent;
import org.bonitasoft.engine.events.model.SInsertEvent;
import org.bonitasoft.engine.events.model.SUpdateEvent;
import org.bonitasoft.engine.events.model.builders.SEventBuilderFactory;
import org.bonitasoft.engine.persistence.PersistentObject;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.persistence.ReadPersistenceService;
import org.bonitasoft.engine.persistence.SBonitaReadException;
import org.bonitasoft.engine.persistence.SelectByIdDescriptor;
import org.bonitasoft.engine.persistence.SelectListDescriptor;
import org.bonitasoft.engine.persistence.SelectOneDescriptor;
import org.bonitasoft.engine.recorder.Recorder;
import org.bonitasoft.engine.recorder.SRecorderException;
import org.bonitasoft.engine.recorder.model.DeleteRecord;
import org.bonitasoft.engine.recorder.model.EntityUpdateDescriptor;
import org.bonitasoft.engine.recorder.model.InsertRecord;
import org.bonitasoft.engine.recorder.model.UpdateRecord;

public class DataInstanceDataSourceImpl
implements DataInstanceDataSource {
    private Recorder recorder;
    private ReadPersistenceService persistenceRead;

    private SInsertEvent getInsertEvent(Object obj) {
        return (SInsertEvent)BuilderFactory.get(SEventBuilderFactory.class).createInsertEvent("DATA_INSTANCE").setObject(obj).done();
    }

    private SUpdateEvent getUpdateEvent(Object obj) {
        return (SUpdateEvent)BuilderFactory.get(SEventBuilderFactory.class).createUpdateEvent("DATA_INSTANCE").setObject(obj).done();
    }

    private SDeleteEvent getDeleteEvent(Object obj) {
        return (SDeleteEvent)BuilderFactory.get(SEventBuilderFactory.class).createDeleteEvent("DATA_INSTANCE").setObject(obj).done();
    }

    @Override
    public void setParameters(Map<String, String> dataSourceParameters) {
    }

    @Override
    public void createDataInstance(SDataInstance dataInstance) throws SDataInstanceException {
        try {
            InsertRecord insertRecord = new InsertRecord(dataInstance);
            SInsertEvent insertEvent = this.getInsertEvent(dataInstance);
            this.recorder.recordInsert(insertRecord, insertEvent);
        }
        catch (SRecorderException e) {
            throw new SCreateDataInstanceException("Imposible to create data intance.", e);
        }
    }

    @Override
    public void updateDataInstance(SDataInstance dataInstance, EntityUpdateDescriptor descriptor) throws SDataInstanceException {
        NullCheckingUtil.checkArgsNotNull(dataInstance);
        UpdateRecord updateRecord = UpdateRecord.buildSetFields((PersistentObject)dataInstance, descriptor);
        SUpdateEvent updateEvent = this.getUpdateEvent(dataInstance);
        try {
            this.recorder.recordUpdate(updateRecord, updateEvent);
        }
        catch (SRecorderException e) {
            throw new SUpdateDataInstanceException("Impossible to update data instance '" + dataInstance.getName() + "': " + e.getMessage(), e);
        }
    }

    @Override
    public void deleteDataInstance(SDataInstance dataInstance) throws SDataInstanceException {
        NullCheckingUtil.checkArgsNotNull(dataInstance);
        DeleteRecord deleteRecord = new DeleteRecord(dataInstance);
        SDeleteEvent deleteEvent = this.getDeleteEvent(dataInstance);
        try {
            this.recorder.recordDelete(deleteRecord, deleteEvent);
        }
        catch (SRecorderException e) {
            throw new SDeleteDataInstanceException("Impossible to delete data instance", e);
        }
    }

    @Override
    public SDataInstance getDataInstance(long dataInstanceId) throws SDataInstanceException {
        NullCheckingUtil.checkArgsNotNull(dataInstanceId);
        try {
            SelectByIdDescriptor<SDataInstance> selectDescriptor = new SelectByIdDescriptor<SDataInstance>("getDataInstanceById", SDataInstance.class, dataInstanceId);
            SDataInstance dataInstance = this.persistenceRead.selectById(selectDescriptor);
            if (dataInstance == null) {
                throw new SDataInstanceNotFoundException("Cannot get the data instance with id " + dataInstanceId);
            }
            return dataInstance;
        }
        catch (SBonitaReadException e) {
            throw new SDataInstanceException("Cannot get the data instance with id " + dataInstanceId, e);
        }
    }

    @Override
    public boolean configurationMatches(DataSourceConfiguration datasourceConfiguration) {
        return datasourceConfiguration instanceof PersistentDataInstanceDataSourceConfiguration;
    }

    @Override
    public void configure(DataSourceConfiguration dataSourceConfiguration) {
        Map<String, Object> resources = dataSourceConfiguration.getResources();
        this.persistenceRead = this.getResource(resources, ReadPersistenceService.class, "persistenceRead");
        this.recorder = this.getResource(resources, Recorder.class, "recorder");
    }

    private <T> T getResource(Map<String, Object> resources, Class<T> clazz, String key) {
        Object resource = resources.get(key);
        if (resource != null && clazz.isInstance(resource)) {
            return clazz.cast(resource);
        }
        return null;
    }

    @Override
    public SDataInstance getDataInstance(String dataName, long containerId, String containerType) throws SDataInstanceException {
        NullCheckingUtil.checkArgsNotNull(dataName, containerType);
        SDataInstanceBuilderFactory fact = BuilderFactory.get(SDataInstanceBuilderFactory.class);
        Map<String, Object> paraMap = CollectionUtil.buildSimpleMap(fact.getNameKey(), dataName);
        paraMap.put(fact.getContainerIdKey(), containerId);
        paraMap.put(fact.getContainerTypeKey(), containerType);
        try {
            SDataInstance dataInstance = this.persistenceRead.selectOne(new SelectOneDescriptor<SDataInstance>("getDataInstancesByNameAndContainer", paraMap, SDataInstance.class, SDataInstance.class));
            if (dataInstance == null) {
                throw new SDataInstanceException("No data instance found");
            }
            return dataInstance;
        }
        catch (SBonitaReadException e) {
            throw new SDataInstanceException("Unable to check if a data instance already exists: " + e.getMessage(), e);
        }
    }

    @Override
    public List<SDataInstance> getDataInstances(long containerId, String containerType, int fromIndex, int numberOfResults) throws SDataInstanceException {
        NullCheckingUtil.checkArgsNotNull(containerType);
        SDataInstanceBuilderFactory fact = BuilderFactory.get(SDataInstanceBuilderFactory.class);
        Map<String, Object> paraMap = CollectionUtil.buildSimpleMap(fact.getContainerIdKey(), containerId);
        paraMap.put(fact.getContainerTypeKey(), containerType);
        try {
            return this.persistenceRead.selectList(new SelectListDescriptor<SDataInstance>("getDataInstancesByContainer", paraMap, SDataInstance.class, SDataInstance.class, new QueryOptions(fromIndex, numberOfResults)));
        }
        catch (SBonitaReadException e) {
            throw new SDataInstanceException("Unable to check if a data instance already exists for the data container of type " + containerType + " with id " + containerId + " for reason: " + e.getMessage(), e);
        }
    }

    @Override
    public List<SDataInstance> getDataInstances(List<Long> dataInstanceIds) throws SDataInstanceException {
        NullCheckingUtil.checkArgsNotNull(dataInstanceIds);
        if (dataInstanceIds.isEmpty()) {
            return Collections.emptyList();
        }
        try {
            Map<String, Object> parameters = CollectionUtil.buildSimpleMap("ids", dataInstanceIds);
            SelectListDescriptor selectDescriptor = new SelectListDescriptor("getDataInstanceByIds", parameters, SDataInstance.class, new QueryOptions(0, dataInstanceIds.size()));
            List<SDataInstance> dataInstances = this.persistenceRead.selectList(selectDescriptor);
            if (dataInstances == null) {
                throw new SDataInstanceNotFoundException("Cannot get the data instance with id " + dataInstanceIds);
            }
            return dataInstances;
        }
        catch (SBonitaReadException e) {
            throw new SDataInstanceException("Cannot get the data instance with id " + dataInstanceIds, e);
        }
    }
}

