/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.execution;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bonitasoft.engine.actor.mapping.ActorMappingService;
import org.bonitasoft.engine.archive.ArchiveService;
import org.bonitasoft.engine.bpm.flownode.FlowNodeType;
import org.bonitasoft.engine.bpm.model.impl.BPMInstancesCreator;
import org.bonitasoft.engine.classloader.ClassLoaderService;
import org.bonitasoft.engine.core.connector.ConnectorInstanceService;
import org.bonitasoft.engine.core.expression.control.api.ExpressionResolverService;
import org.bonitasoft.engine.core.filter.UserFilterService;
import org.bonitasoft.engine.core.operation.OperationService;
import org.bonitasoft.engine.core.process.comment.api.SCommentService;
import org.bonitasoft.engine.core.process.definition.ProcessDefinitionService;
import org.bonitasoft.engine.core.process.definition.model.SFlowNodeType;
import org.bonitasoft.engine.core.process.definition.model.SProcessDefinition;
import org.bonitasoft.engine.core.process.document.mapping.DocumentMappingService;
import org.bonitasoft.engine.core.process.instance.api.ActivityInstanceService;
import org.bonitasoft.engine.core.process.instance.api.ProcessInstanceService;
import org.bonitasoft.engine.core.process.instance.api.TokenService;
import org.bonitasoft.engine.core.process.instance.api.event.EventInstanceService;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SActivityExecutionException;
import org.bonitasoft.engine.core.process.instance.api.states.FlowNodeState;
import org.bonitasoft.engine.core.process.instance.model.SFlowNodeInstance;
import org.bonitasoft.engine.data.instance.api.DataInstanceService;
import org.bonitasoft.engine.execution.ContainerRegistry;
import org.bonitasoft.engine.execution.ProcessExecutor;
import org.bonitasoft.engine.execution.StateBehaviors;
import org.bonitasoft.engine.execution.event.EventsHandler;
import org.bonitasoft.engine.execution.state.AbortedFlowNodeStateImpl;
import org.bonitasoft.engine.execution.state.AbortingActivityWithBoundaryStateImpl;
import org.bonitasoft.engine.execution.state.AbortingBoundaryAndIntermediateCatchEventStateImpl;
import org.bonitasoft.engine.execution.state.AbortingCallActivityStateImpl;
import org.bonitasoft.engine.execution.state.AbortingFlowNodeContainerStateImpl;
import org.bonitasoft.engine.execution.state.AbortingFlowNodeStateImpl;
import org.bonitasoft.engine.execution.state.AbortingReceiveTaskStateImpl;
import org.bonitasoft.engine.execution.state.CancelledFlowNodeStateImpl;
import org.bonitasoft.engine.execution.state.CancellingActivityWithBoundaryStateImpl;
import org.bonitasoft.engine.execution.state.CancellingBoundaryAndIntermediateCatchEventStateImpl;
import org.bonitasoft.engine.execution.state.CancellingCallActivityStateImpl;
import org.bonitasoft.engine.execution.state.CancellingFlowNodeContainerChildrenStateImpl;
import org.bonitasoft.engine.execution.state.CancellingFlowNodeStateImpl;
import org.bonitasoft.engine.execution.state.CancellingReceiveTaskStateImpl;
import org.bonitasoft.engine.execution.state.CompletedActivityStateImpl;
import org.bonitasoft.engine.execution.state.CompletingActivityWithBoundaryStateImpl;
import org.bonitasoft.engine.execution.state.CompletingCallActivityStateImpl;
import org.bonitasoft.engine.execution.state.CompletingSubTaskStateImpl;
import org.bonitasoft.engine.execution.state.ExecutingAutomaticActivityStateImpl;
import org.bonitasoft.engine.execution.state.ExecutingBoundaryEventStateImpl;
import org.bonitasoft.engine.execution.state.ExecutingCallActivityStateImpl;
import org.bonitasoft.engine.execution.state.ExecutingFlowNodeStateImpl;
import org.bonitasoft.engine.execution.state.ExecutingLoopActivityStateImpl;
import org.bonitasoft.engine.execution.state.ExecutingMultiInstanceActivityStateImpl;
import org.bonitasoft.engine.execution.state.ExecutingThrowEventStateImpl;
import org.bonitasoft.engine.execution.state.FailedActivityStateImpl;
import org.bonitasoft.engine.execution.state.FlowNodeStateManager;
import org.bonitasoft.engine.execution.state.InitializinAndExecutingFlowNodeStateImpl;
import org.bonitasoft.engine.execution.state.InitializingActivityStateImpl;
import org.bonitasoft.engine.execution.state.InitializingActivityWithBoundaryEventsStateImpl;
import org.bonitasoft.engine.execution.state.InitializingBoundaryEventStateImpl;
import org.bonitasoft.engine.execution.state.InitializingLoopActivityStateImpl;
import org.bonitasoft.engine.execution.state.InitializingMultiInstanceActivityStateImpl;
import org.bonitasoft.engine.execution.state.InterruptedFlowNodeState;
import org.bonitasoft.engine.execution.state.ReadyActivityStateImpl;
import org.bonitasoft.engine.execution.state.SkippedFlowNodeStateImpl;
import org.bonitasoft.engine.execution.state.WaitingFlowNodeStateImpl;
import org.bonitasoft.engine.identity.IdentityService;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.scheduler.SchedulerService;
import org.bonitasoft.engine.work.WorkService;

public class FlowNodeStateManagerImpl
implements FlowNodeStateManager {
    protected final Map<Integer, FlowNodeState> states = new HashMap<Integer, FlowNodeState>();
    protected final Map<SFlowNodeType, Map<Integer, FlowNodeState>> normalTransitions = new HashMap<SFlowNodeType, Map<Integer, FlowNodeState>>();
    protected final Map<SFlowNodeType, Map<Integer, FlowNodeState>> abortTransitions = new HashMap<SFlowNodeType, Map<Integer, FlowNodeState>>();
    protected final Map<SFlowNodeType, Map<Integer, FlowNodeState>> cancelTransitions = new HashMap<SFlowNodeType, Map<Integer, FlowNodeState>>();
    protected Set<Integer> unstableStates;
    protected Set<Integer> stableStates;
    protected Set<Integer> allStates;
    protected FailedActivityStateImpl failed;
    protected InitializingActivityStateImpl initializing;
    protected InitializingActivityWithBoundaryEventsStateImpl initializingActivityWithBoundary;
    protected InitializingBoundaryEventStateImpl initializingBoundaryEvent;
    protected ReadyActivityStateImpl ready;
    protected ExecutingAutomaticActivityStateImpl executingAutomaticActivity;
    protected ExecutingThrowEventStateImpl executingThrowEvent;
    protected CompletingCallActivityStateImpl completingCallActivity;
    protected CompletingActivityWithBoundaryStateImpl completingActivityWithBoundary;
    protected ExecutingCallActivityStateImpl executingCallActivity;
    protected CompletedActivityStateImpl completed;
    protected WaitingFlowNodeStateImpl waiting;
    protected SkippedFlowNodeStateImpl skipped;
    protected InitializingLoopActivityStateImpl initializingLoop;
    protected ExecutingLoopActivityStateImpl executingLoop;
    protected InitializingMultiInstanceActivityStateImpl initializingMultiInstance;
    protected ExecutingMultiInstanceActivityStateImpl executingMultiInstance;
    protected CancelledFlowNodeStateImpl cancelled;
    protected CancellingFlowNodeContainerChildrenStateImpl cancellingContainer;
    protected CancellingActivityWithBoundaryStateImpl cancellingActivityWithBoundary;
    protected CancellingFlowNodeStateImpl cancellingFlowNode;
    protected CancellingBoundaryAndIntermediateCatchEventStateImpl cancelingBoundaryAndIntermediateCatchEvent;
    protected CancellingCallActivityStateImpl cancellingCallActivity;
    protected AbortingFlowNodeContainerStateImpl abortingContainer;
    protected AbortingCallActivityStateImpl abortingCallActivity;
    protected AbortingFlowNodeStateImpl abortingFlowNode;
    protected AbortingActivityWithBoundaryStateImpl abortingActivityWithBoundary;
    protected AbortingBoundaryAndIntermediateCatchEventStateImpl abortingBoundaryAndIntermediateCatchEvent;
    protected AbortedFlowNodeStateImpl aborted;
    protected InterruptedFlowNodeState interruptedFlowNodeState;
    protected ExecutingFlowNodeStateImpl executing;
    protected ExecutingBoundaryEventStateImpl executingBoundaryEvent;
    protected InitializinAndExecutingFlowNodeStateImpl initializingAndExecuting;
    protected StateBehaviors stateBehaviors;
    protected CompletingSubTaskStateImpl completingSubTaskState;
    protected AbortingReceiveTaskStateImpl abortingReceiveTask;
    protected CancellingReceiveTaskStateImpl cancellingReceiveTask;

    public FlowNodeStateManagerImpl(ProcessDefinitionService processDefinitionService, ProcessInstanceService processInstanceService, ActivityInstanceService activityInstanceService, ConnectorInstanceService connectorInstanceService, ClassLoaderService classLoaderService, ExpressionResolverService expressionResolverService, SchedulerService schedulerService, DataInstanceService dataInstanceService, EventInstanceService eventInstanceService, OperationService operationService, BPMInstancesCreator bpmInstancesCreator, ContainerRegistry containerRegistry, ArchiveService archiveService, TechnicalLoggerService logger, DocumentMappingService documentMappingService, SCommentService commentService, EventsHandler eventsHandler, UserFilterService userFilterService, ActorMappingService actorMappingService, WorkService workService, TokenService tokenService, IdentityService identityService) {
        this.initStates(connectorInstanceService, classLoaderService, expressionResolverService, schedulerService, dataInstanceService, eventInstanceService, operationService, activityInstanceService, bpmInstancesCreator, containerRegistry, processDefinitionService, processInstanceService, archiveService, logger, documentMappingService, commentService, eventsHandler, userFilterService, actorMappingService, workService, tokenService, identityService);
        this.defineTransitionsForAllNodesType();
        this.initializeFirstStatesIdsOnBPMInstanceCreator(bpmInstancesCreator);
    }

    private void initializeFirstStatesIdsOnBPMInstanceCreator(BPMInstancesCreator bpmInstancesCreator) {
        Set<Map.Entry<SFlowNodeType, Map<Integer, FlowNodeState>>> entrySet = this.normalTransitions.entrySet();
        HashMap<SFlowNodeType, Integer> firstStateIds = new HashMap<SFlowNodeType, Integer>(entrySet.size());
        HashMap<SFlowNodeType, String> firstStateNames = new HashMap<SFlowNodeType, String>(entrySet.size());
        for (Map.Entry<SFlowNodeType, Map<Integer, FlowNodeState>> entry : entrySet) {
            firstStateIds.put(entry.getKey(), entry.getValue().get(-1).getId());
            firstStateNames.put(entry.getKey(), entry.getValue().get(-1).getName());
        }
        bpmInstancesCreator.setFirstStateIds(firstStateIds);
        bpmInstancesCreator.setFirstStateNames(firstStateNames);
    }

    @Override
    public void setProcessExecutor(ProcessExecutor processExecutor) {
        this.stateBehaviors.setProcessExecutor(processExecutor);
    }

    private void defineTransitionsForAllNodesType() {
        this.defineTransitionsForAutomaticTask();
        this.defineTransitionsForUserTask();
        this.defineTransitionsForManualTask();
        this.defineTransitionsForReceiveTask();
        this.defineTransitionsForSendTask();
        this.defineTransitionsForCallActivity();
        this.defineTransitionsForSubProcessActivity();
        this.defineTransitionsForGateways();
        this.defineTransitionsForStartEvent();
        this.defineTransitionsForIntermediateCatchEvent();
        this.defineTransitionsForBoundaryEvents();
        this.defineTransitionsForIntermediateThrowEvent();
        this.defineTransitionsForEndEvent();
        this.defineTransitionsForLoopActivity();
        this.defineTransitionsForMultiInstanceActivity();
    }

    private void defineTransitionsForEndEvent() {
        this.defineNormalTransitionForFlowNode(SFlowNodeType.END_EVENT, this.executingThrowEvent, this.completed);
        this.defineCancelTransitionForFlowNode(SFlowNodeType.END_EVENT, this.cancellingFlowNode, this.cancelled);
        this.defineAbortTransitionForFlowNode(SFlowNodeType.END_EVENT, this.abortingFlowNode, this.aborted);
    }

    private void defineTransitionsForIntermediateCatchEvent() {
        this.defineNormalTransitionForFlowNode(SFlowNodeType.INTERMEDIATE_CATCH_EVENT, this.initializing, this.waiting, this.executing, this.completed);
        this.defineCancelTransitionForFlowNode(SFlowNodeType.INTERMEDIATE_CATCH_EVENT, this.cancelingBoundaryAndIntermediateCatchEvent, this.cancelled);
        this.defineAbortTransitionForFlowNode(SFlowNodeType.INTERMEDIATE_CATCH_EVENT, this.abortingBoundaryAndIntermediateCatchEvent, this.aborted);
    }

    private void defineTransitionsForIntermediateThrowEvent() {
        this.defineNormalTransitionForFlowNode(SFlowNodeType.INTERMEDIATE_THROW_EVENT, this.executingThrowEvent, this.completed);
        this.defineCancelTransitionForFlowNode(SFlowNodeType.INTERMEDIATE_THROW_EVENT, this.cancellingFlowNode, this.cancelled);
        this.defineAbortTransitionForFlowNode(SFlowNodeType.INTERMEDIATE_THROW_EVENT, this.abortingFlowNode, this.aborted);
    }

    private void defineTransitionsForStartEvent() {
        this.defineNormalTransitionForFlowNode(SFlowNodeType.START_EVENT, this.initializingAndExecuting, this.completed);
        this.defineCancelTransitionForFlowNode(SFlowNodeType.START_EVENT, this.cancellingFlowNode, this.cancelled);
        this.defineAbortTransitionForFlowNode(SFlowNodeType.START_EVENT, this.abortingFlowNode, this.aborted);
    }

    private void defineTransitionsForBoundaryEvents() {
        this.defineNormalTransitionForFlowNode(SFlowNodeType.BOUNDARY_EVENT, this.initializingBoundaryEvent, this.waiting, this.executingBoundaryEvent, this.completed);
        this.defineAbortTransitionForFlowNode(SFlowNodeType.BOUNDARY_EVENT, this.aborted);
        this.defineCancelTransitionForFlowNode(SFlowNodeType.BOUNDARY_EVENT, this.cancelled);
    }

    private void defineTransitionsForGateways() {
        this.defineNormalTransitionForFlowNode(SFlowNodeType.GATEWAY, this.initializingAndExecuting, this.completed);
        this.defineCancelTransitionForFlowNode(SFlowNodeType.GATEWAY, this.cancellingFlowNode, this.cancelled);
        this.defineAbortTransitionForFlowNode(SFlowNodeType.GATEWAY, this.abortingFlowNode, this.aborted);
    }

    private void defineTransitionsForUserTask() {
        this.defineNormalTransitionForFlowNode(SFlowNodeType.USER_TASK, this.initializingActivityWithBoundary, this.ready, this.completingActivityWithBoundary, this.completingSubTaskState, this.completed);
        this.defineAbortTransitionForFlowNode(SFlowNodeType.USER_TASK, this.abortingActivityWithBoundary, this.abortingContainer, this.aborted);
        this.defineCancelTransitionForFlowNode(SFlowNodeType.USER_TASK, this.cancellingActivityWithBoundary, this.cancellingContainer, this.cancelled);
    }

    private void defineTransitionsForManualTask() {
        this.defineNormalTransitionForFlowNode(SFlowNodeType.MANUAL_TASK, this.initializing, this.ready, this.completingSubTaskState, this.completed);
        this.defineAbortTransitionForFlowNode(SFlowNodeType.MANUAL_TASK, this.abortingContainer, this.aborted);
        this.defineCancelTransitionForFlowNode(SFlowNodeType.MANUAL_TASK, this.cancellingContainer, this.cancelled);
    }

    private void defineTransitionsForCallActivity() {
        this.defineNormalTransitionForFlowNode(SFlowNodeType.CALL_ACTIVITY, this.initializingActivityWithBoundary, this.executingCallActivity, this.completingActivityWithBoundary, this.completingCallActivity, this.completed);
        this.defineAbortTransitionForFlowNode(SFlowNodeType.CALL_ACTIVITY, this.abortingActivityWithBoundary, this.abortingCallActivity, this.aborted);
        this.defineCancelTransitionForFlowNode(SFlowNodeType.CALL_ACTIVITY, this.cancellingActivityWithBoundary, this.cancellingCallActivity, this.cancelled);
    }

    private void defineTransitionsForSubProcessActivity() {
        this.defineNormalTransitionForFlowNode(SFlowNodeType.SUB_PROCESS, this.executingCallActivity, this.completed);
        this.defineAbortTransitionForFlowNode(SFlowNodeType.SUB_PROCESS, this.abortingCallActivity, this.aborted);
        this.defineCancelTransitionForFlowNode(SFlowNodeType.SUB_PROCESS, this.cancellingCallActivity, this.cancelled);
    }

    private void defineTransitionsForAutomaticTask() {
        this.defineNormalTransitionForFlowNode(SFlowNodeType.AUTOMATIC_TASK, this.executingAutomaticActivity, this.completingActivityWithBoundary, this.completed);
        this.defineAbortTransitionForFlowNode(SFlowNodeType.AUTOMATIC_TASK, this.abortingActivityWithBoundary, this.abortingContainer, this.aborted);
        this.defineCancelTransitionForFlowNode(SFlowNodeType.AUTOMATIC_TASK, this.cancellingActivityWithBoundary, this.cancellingContainer, this.cancelled);
    }

    private void defineTransitionsForReceiveTask() {
        this.defineNormalTransitionForFlowNode(SFlowNodeType.RECEIVE_TASK, this.initializingActivityWithBoundary, this.waiting, this.executing, this.completingActivityWithBoundary, this.completed);
        this.defineAbortTransitionForFlowNode(SFlowNodeType.RECEIVE_TASK, this.abortingActivityWithBoundary, this.abortingReceiveTask, this.aborted);
        this.defineCancelTransitionForFlowNode(SFlowNodeType.RECEIVE_TASK, this.cancellingActivityWithBoundary, this.cancellingReceiveTask, this.cancelled);
    }

    private void defineTransitionsForSendTask() {
        this.defineNormalTransitionForFlowNode(SFlowNodeType.SEND_TASK, this.executingAutomaticActivity, this.completingActivityWithBoundary, this.completed);
        this.defineAbortTransitionForFlowNode(SFlowNodeType.SEND_TASK, this.abortingActivityWithBoundary, this.abortingReceiveTask, this.aborted);
        this.defineCancelTransitionForFlowNode(SFlowNodeType.SEND_TASK, this.cancellingActivityWithBoundary, this.cancellingReceiveTask, this.cancelled);
    }

    private void defineTransitionsForLoopActivity() {
        this.defineNormalTransitionForFlowNode(SFlowNodeType.LOOP_ACTIVITY, this.initializingLoop, this.executingLoop, this.completingActivityWithBoundary, this.completed);
        this.defineAbortTransitionForFlowNode(SFlowNodeType.LOOP_ACTIVITY, this.abortingActivityWithBoundary, this.abortingContainer, this.aborted);
        this.defineCancelTransitionForFlowNode(SFlowNodeType.LOOP_ACTIVITY, this.cancellingActivityWithBoundary, this.cancellingContainer, this.cancelled);
    }

    private void defineTransitionsForMultiInstanceActivity() {
        this.defineNormalTransitionForFlowNode(SFlowNodeType.MULTI_INSTANCE_ACTIVITY, this.initializingMultiInstance, this.executingMultiInstance, this.completingActivityWithBoundary, this.completed);
        this.defineAbortTransitionForFlowNode(SFlowNodeType.MULTI_INSTANCE_ACTIVITY, this.abortingActivityWithBoundary, this.abortingContainer, this.aborted);
        this.defineCancelTransitionForFlowNode(SFlowNodeType.MULTI_INSTANCE_ACTIVITY, this.cancellingActivityWithBoundary, this.cancellingContainer, this.cancelled);
    }

    private void initStates(ConnectorInstanceService connectorInstanceService, ClassLoaderService classLoaderService, ExpressionResolverService expressionResolverService, SchedulerService schedulerService, DataInstanceService dataInstanceService, EventInstanceService eventInstanceService, OperationService operationService, ActivityInstanceService activityInstanceService, BPMInstancesCreator bpmInstancesCreator, ContainerRegistry containerRegistry, ProcessDefinitionService processDefinitionService, ProcessInstanceService processInstanceService, ArchiveService archiveService, TechnicalLoggerService logger, DocumentMappingService documentMappingService, SCommentService commentService, EventsHandler eventsHandler, UserFilterService userFilterService, ActorMappingService actorMappingService, WorkService workService, TokenService tokenService, IdentityService identityService) {
        this.stateBehaviors = new StateBehaviors(bpmInstancesCreator, eventsHandler, activityInstanceService, userFilterService, classLoaderService, actorMappingService, connectorInstanceService, expressionResolverService, processDefinitionService, dataInstanceService, operationService, workService, containerRegistry, eventInstanceService, schedulerService, commentService, identityService, logger);
        this.failed = new FailedActivityStateImpl();
        this.initializing = new InitializingActivityStateImpl(this.stateBehaviors);
        this.initializingActivityWithBoundary = new InitializingActivityWithBoundaryEventsStateImpl(this.stateBehaviors);
        this.initializingBoundaryEvent = new InitializingBoundaryEventStateImpl(this.stateBehaviors);
        this.initializingLoop = new InitializingLoopActivityStateImpl(expressionResolverService, bpmInstancesCreator, activityInstanceService, this.stateBehaviors);
        this.ready = new ReadyActivityStateImpl(this.stateBehaviors);
        this.executing = new ExecutingFlowNodeStateImpl(this.stateBehaviors);
        this.executingBoundaryEvent = new ExecutingBoundaryEventStateImpl(activityInstanceService, containerRegistry, tokenService);
        this.initializingAndExecuting = new InitializinAndExecutingFlowNodeStateImpl(this.stateBehaviors);
        this.executingAutomaticActivity = new ExecutingAutomaticActivityStateImpl(this.stateBehaviors);
        this.executingThrowEvent = new ExecutingThrowEventStateImpl(this.stateBehaviors);
        this.executingLoop = new ExecutingLoopActivityStateImpl(expressionResolverService, bpmInstancesCreator, containerRegistry, activityInstanceService);
        this.completingCallActivity = new CompletingCallActivityStateImpl(this.stateBehaviors, operationService, processInstanceService, dataInstanceService, documentMappingService, logger, archiveService, commentService, processDefinitionService, connectorInstanceService);
        this.completingActivityWithBoundary = new CompletingActivityWithBoundaryStateImpl(this.stateBehaviors);
        this.executingCallActivity = new ExecutingCallActivityStateImpl(this.stateBehaviors);
        this.completed = new CompletedActivityStateImpl();
        this.waiting = new WaitingFlowNodeStateImpl();
        this.skipped = new SkippedFlowNodeStateImpl();
        this.cancelled = new CancelledFlowNodeStateImpl();
        this.cancellingContainer = new CancellingFlowNodeContainerChildrenStateImpl(this.stateBehaviors);
        this.cancellingFlowNode = new CancellingFlowNodeStateImpl();
        this.cancelingBoundaryAndIntermediateCatchEvent = new CancellingBoundaryAndIntermediateCatchEventStateImpl(this.stateBehaviors);
        this.cancellingCallActivity = new CancellingCallActivityStateImpl(activityInstanceService, processInstanceService, containerRegistry, archiveService, commentService, dataInstanceService, documentMappingService, logger, processDefinitionService, connectorInstanceService);
        this.cancellingActivityWithBoundary = new CancellingActivityWithBoundaryStateImpl(this.stateBehaviors);
        this.cancellingReceiveTask = new CancellingReceiveTaskStateImpl(this.stateBehaviors);
        this.initializingMultiInstance = new InitializingMultiInstanceActivityStateImpl(expressionResolverService, bpmInstancesCreator, activityInstanceService, dataInstanceService, this.stateBehaviors);
        this.executingMultiInstance = new ExecutingMultiInstanceActivityStateImpl(expressionResolverService, bpmInstancesCreator, containerRegistry, activityInstanceService, dataInstanceService, this.stateBehaviors);
        this.abortingContainer = new AbortingFlowNodeContainerStateImpl(this.stateBehaviors);
        this.abortingCallActivity = new AbortingCallActivityStateImpl(activityInstanceService, processInstanceService, containerRegistry, archiveService, commentService, dataInstanceService, documentMappingService, logger, processDefinitionService, connectorInstanceService);
        this.abortingFlowNode = new AbortingFlowNodeStateImpl();
        this.abortingBoundaryAndIntermediateCatchEvent = new AbortingBoundaryAndIntermediateCatchEventStateImpl(this.stateBehaviors);
        this.abortingActivityWithBoundary = new AbortingActivityWithBoundaryStateImpl(this.stateBehaviors);
        this.abortingReceiveTask = new AbortingReceiveTaskStateImpl(this.stateBehaviors);
        this.aborted = new AbortedFlowNodeStateImpl();
        this.interruptedFlowNodeState = new InterruptedFlowNodeState();
        this.completingSubTaskState = new CompletingSubTaskStateImpl(this.stateBehaviors);
        HashSet<Integer> unstableStatesModifiable = new HashSet<Integer>();
        HashSet<Integer> stableStatesModifiable = new HashSet<Integer>();
        this.addToMap(this.failed);
        this.addToMap(this.initializing);
        this.addToMap(this.initializingBoundaryEvent);
        this.addToMap(this.initializingActivityWithBoundary);
        this.addToMap(this.initializingLoop);
        this.addToMap(this.completingCallActivity);
        this.addToMap(this.executingCallActivity);
        this.addToMap(this.completed);
        this.addToMap(this.executing);
        this.addToMap(this.executingBoundaryEvent);
        this.addToMap(this.executingThrowEvent);
        this.addToMap(this.executingLoop);
        this.addToMap(this.ready);
        this.addToMap(this.waiting);
        this.addToMap(this.skipped);
        this.addToMap(this.cancelled);
        this.addToMap(this.cancellingContainer);
        this.addToMap(this.cancellingFlowNode);
        this.addToMap(this.cancellingCallActivity);
        this.addToMap(this.cancelingBoundaryAndIntermediateCatchEvent);
        this.addToMap(this.cancellingActivityWithBoundary);
        this.addToMap(this.cancellingReceiveTask);
        this.addToMap(this.initializingMultiInstance);
        this.addToMap(this.executingMultiInstance);
        this.addToMap(this.abortingContainer);
        this.addToMap(this.abortingCallActivity);
        this.addToMap(this.abortingFlowNode);
        this.addToMap(this.abortingActivityWithBoundary);
        this.addToMap(this.abortingBoundaryAndIntermediateCatchEvent);
        this.addToMap(this.abortingReceiveTask);
        this.addToMap(this.aborted);
        this.addToMap(this.interruptedFlowNodeState);
        this.addToMap(this.executingAutomaticActivity);
        this.addToMap(this.initializingAndExecuting);
        this.addToMap(this.completingSubTaskState);
        this.addToMap(this.completingActivityWithBoundary);
        this.allStates = Collections.unmodifiableSet(this.states.keySet());
        for (FlowNodeState state : this.states.values()) {
            if (!state.isStable()) {
                unstableStatesModifiable.add(state.getId());
                continue;
            }
            stableStatesModifiable.add(state.getId());
        }
        this.unstableStates = Collections.unmodifiableSet(unstableStatesModifiable);
        this.stableStates = Collections.unmodifiableSet(stableStatesModifiable);
    }

    private void addToMap(FlowNodeState state) {
        if (this.states.containsKey(state.getId())) {
            throw new RuntimeException("states already contains a state with id= " + state.getId() + " try to add<" + state.getClass() + "> but was already <" + this.states.get(state.getId()).getClass() + ">");
        }
        this.states.put(state.getId(), state);
    }

    private void defineNormalTransitionForFlowNode(SFlowNodeType flowNodeType, FlowNodeState ... states) {
        this.defineTransitionsForFlowNode(flowNodeType, this.normalTransitions, states);
    }

    private void defineAbortTransitionForFlowNode(SFlowNodeType flowNodeType, FlowNodeState ... states) {
        this.defineTransitionsForFlowNode(flowNodeType, this.abortTransitions, states);
    }

    private void defineCancelTransitionForFlowNode(SFlowNodeType flowNodeType, FlowNodeState ... states) {
        this.defineTransitionsForFlowNode(flowNodeType, this.cancelTransitions, states);
    }

    private void defineTransitionsForFlowNode(SFlowNodeType flowNodeType, Map<SFlowNodeType, Map<Integer, FlowNodeState>> transitions, FlowNodeState ... states) {
        HashMap<Integer, FlowNodeState> taskTransitions = new HashMap<Integer, FlowNodeState>();
        taskTransitions.put(-1, states[0]);
        for (int stateIndex = 0; stateIndex < states.length - 1; ++stateIndex) {
            taskTransitions.put(states[stateIndex].getId(), states[stateIndex + 1]);
        }
        transitions.put(flowNodeType, taskTransitions);
    }

    @Override
    public FlowNodeState getNextNormalState(SProcessDefinition processDefinition, SFlowNodeInstance flowNodeInstance, int currentState) throws SActivityExecutionException {
        FlowNodeState flowNodeState;
        int nextState;
        Map<Integer, FlowNodeState> normalTransition = this.normalTransitions.get((Object)flowNodeInstance.getType());
        Map<Integer, FlowNodeState> flowNodeAbortTransitions = this.abortTransitions.get((Object)flowNodeInstance.getType());
        Map<Integer, FlowNodeState> flowNodeCancelTransitions = this.cancelTransitions.get((Object)flowNodeInstance.getType());
        FlowNodeState current = this.getState(currentState);
        if (current.isInterrupting()) {
            int previousStateId = flowNodeInstance.getPreviousStateId();
            nextState = this.states.get(previousStateId).getId();
        } else {
            nextState = currentState;
        }
        do {
            switch (flowNodeInstance.getStateCategory()) {
                case ABORTING: {
                    flowNodeState = flowNodeAbortTransitions.get(nextState);
                    if (flowNodeState != null) break;
                    flowNodeState = flowNodeAbortTransitions.get(-1);
                    break;
                }
                case CANCELLING: {
                    flowNodeState = flowNodeCancelTransitions.get(nextState);
                    if (flowNodeState != null) break;
                    flowNodeState = flowNodeCancelTransitions.get(-1);
                    break;
                }
                default: {
                    flowNodeState = normalTransition.get(nextState);
                }
            }
            if (flowNodeState == null) {
                throw new SActivityExecutionException("no state found after " + this.states.get(currentState).getClass() + " for " + flowNodeInstance.getClass() + " in state category " + (Object)((Object)flowNodeInstance.getStateCategory()) + " activity id=" + flowNodeInstance.getId());
            }
            nextState = flowNodeState.getId();
        } while (!flowNodeState.shouldExecuteState(processDefinition, flowNodeInstance));
        return flowNodeState;
    }

    @Override
    public FlowNodeState getFailedState() {
        return this.failed;
    }

    @Override
    public FlowNodeState getState(int stateId) {
        return this.states.get(stateId);
    }

    @Override
    public FlowNodeState getNormalFinalState(SFlowNodeInstance flowNodeInstance) {
        return this.completed;
    }

    @Override
    public FlowNodeState getSkippedState(SFlowNodeInstance flownNodeInstance) {
        return this.skipped;
    }

    @Override
    public FlowNodeState getCanceledState(SFlowNodeInstance flownNodeInstance) {
        return this.cancelled;
    }

    @Override
    public FlowNodeState getInitialState(SFlowNodeInstance flowNodeInstance) {
        return this.initializing;
    }

    @Override
    public Set<Integer> getUnstableStateIds() {
        return this.unstableStates;
    }

    @Override
    public Set<Integer> getStableStateIds() {
        return this.stableStates;
    }

    @Override
    public Set<Integer> getAllStates() {
        return this.allStates;
    }

    @Override
    public Set<String> getSupportedState(FlowNodeType nodeType) {
        SFlowNodeType type = SFlowNodeType.valueOf(nodeType.toString());
        Map<Integer, FlowNodeState> states = this.normalTransitions.get((Object)type);
        HashSet<String> stateNames = new HashSet<String>();
        for (FlowNodeState state : states.values()) {
            stateNames.add(state.getName());
        }
        return stateNames;
    }
}

