/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.execution;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.bonitasoft.engine.api.impl.transaction.event.CreateEventInstance;
import org.bonitasoft.engine.bpm.connector.ConnectorDefinition;
import org.bonitasoft.engine.bpm.connector.ConnectorDefinitionWithInputValues;
import org.bonitasoft.engine.bpm.connector.ConnectorEvent;
import org.bonitasoft.engine.bpm.connector.InvalidEvaluationConnectorConditionException;
import org.bonitasoft.engine.bpm.model.impl.BPMInstancesCreator;
import org.bonitasoft.engine.bpm.process.ProcessInstanceState;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.classloader.ClassLoaderService;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.exceptions.SObjectNotFoundException;
import org.bonitasoft.engine.core.connector.ConnectorInstanceService;
import org.bonitasoft.engine.core.connector.ConnectorResult;
import org.bonitasoft.engine.core.connector.ConnectorService;
import org.bonitasoft.engine.core.connector.exception.SConnectorInstanceReadException;
import org.bonitasoft.engine.core.expression.control.api.ExpressionResolverService;
import org.bonitasoft.engine.core.expression.control.model.SExpressionContext;
import org.bonitasoft.engine.core.operation.OperationService;
import org.bonitasoft.engine.core.operation.model.SOperation;
import org.bonitasoft.engine.core.process.definition.ProcessDefinitionService;
import org.bonitasoft.engine.core.process.definition.SProcessDefinitionNotFoundException;
import org.bonitasoft.engine.core.process.definition.exception.SProcessDefinitionReadException;
import org.bonitasoft.engine.core.process.definition.model.SConnectorDefinition;
import org.bonitasoft.engine.core.process.definition.model.SDocumentDefinition;
import org.bonitasoft.engine.core.process.definition.model.SFlowElementContainerDefinition;
import org.bonitasoft.engine.core.process.definition.model.SFlowNodeDefinition;
import org.bonitasoft.engine.core.process.definition.model.SFlowNodeType;
import org.bonitasoft.engine.core.process.definition.model.SGatewayDefinition;
import org.bonitasoft.engine.core.process.definition.model.SGatewayType;
import org.bonitasoft.engine.core.process.definition.model.SProcessDefinition;
import org.bonitasoft.engine.core.process.definition.model.SSubProcessDefinition;
import org.bonitasoft.engine.core.process.definition.model.STransitionDefinition;
import org.bonitasoft.engine.core.process.definition.model.TransitionState;
import org.bonitasoft.engine.core.process.definition.model.event.SEndEventDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.SStartEventDefinition;
import org.bonitasoft.engine.core.process.document.api.ProcessDocumentService;
import org.bonitasoft.engine.core.process.document.model.SProcessDocument;
import org.bonitasoft.engine.core.process.document.model.builder.SProcessDocumentBuilder;
import org.bonitasoft.engine.core.process.document.model.builder.SProcessDocumentBuilderFactory;
import org.bonitasoft.engine.core.process.instance.api.ActivityInstanceService;
import org.bonitasoft.engine.core.process.instance.api.GatewayInstanceService;
import org.bonitasoft.engine.core.process.instance.api.ProcessInstanceService;
import org.bonitasoft.engine.core.process.instance.api.TokenService;
import org.bonitasoft.engine.core.process.instance.api.TransitionService;
import org.bonitasoft.engine.core.process.instance.api.event.EventInstanceService;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SActivityExecutionException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SFlowNodeExecutionException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SGatewayModificationException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SGatewayNotFoundException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SProcessInstanceCreationException;
import org.bonitasoft.engine.core.process.instance.api.states.FlowNodeState;
import org.bonitasoft.engine.core.process.instance.model.SActivityInstance;
import org.bonitasoft.engine.core.process.instance.model.SConnectorInstance;
import org.bonitasoft.engine.core.process.instance.model.SFlowElementsContainerType;
import org.bonitasoft.engine.core.process.instance.model.SFlowNodeInstance;
import org.bonitasoft.engine.core.process.instance.model.SGatewayInstance;
import org.bonitasoft.engine.core.process.instance.model.SProcessInstance;
import org.bonitasoft.engine.core.process.instance.model.SStateCategory;
import org.bonitasoft.engine.core.process.instance.model.SToken;
import org.bonitasoft.engine.core.process.instance.model.builder.SProcessInstanceBuilder;
import org.bonitasoft.engine.core.process.instance.model.builder.SProcessInstanceBuilderFactory;
import org.bonitasoft.engine.core.process.instance.model.builder.SUserTaskInstanceBuilderFactory;
import org.bonitasoft.engine.core.process.instance.model.event.SBoundaryEventInstance;
import org.bonitasoft.engine.core.process.instance.model.event.SEventInstance;
import org.bonitasoft.engine.core.process.instance.model.event.SThrowEventInstance;
import org.bonitasoft.engine.data.instance.api.DataInstanceContainer;
import org.bonitasoft.engine.events.EventService;
import org.bonitasoft.engine.events.model.HandlerRegistrationException;
import org.bonitasoft.engine.events.model.SEvent;
import org.bonitasoft.engine.events.model.SHandler;
import org.bonitasoft.engine.exception.BonitaHomeNotSetException;
import org.bonitasoft.engine.execution.ContainerRegistry;
import org.bonitasoft.engine.execution.FlowNodeExecutor;
import org.bonitasoft.engine.execution.ProcessExecutor;
import org.bonitasoft.engine.execution.event.EventsHandler;
import org.bonitasoft.engine.execution.handler.SProcessInstanceHandler;
import org.bonitasoft.engine.execution.state.FlowNodeStateManager;
import org.bonitasoft.engine.execution.work.WorkFactory;
import org.bonitasoft.engine.expression.exception.SExpressionDependencyMissingException;
import org.bonitasoft.engine.expression.exception.SExpressionEvaluationException;
import org.bonitasoft.engine.expression.exception.SExpressionTypeUnknownException;
import org.bonitasoft.engine.expression.exception.SInvalidExpressionException;
import org.bonitasoft.engine.expression.model.SExpression;
import org.bonitasoft.engine.home.BonitaHomeServer;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.operation.Operation;
import org.bonitasoft.engine.service.ModelConvertor;
import org.bonitasoft.engine.sessionaccessor.ReadSessionAccessor;
import org.bonitasoft.engine.transaction.TransactionService;
import org.bonitasoft.engine.work.WorkRegisterException;
import org.bonitasoft.engine.work.WorkService;

public class ProcessExecutorImpl
implements ProcessExecutor {
    protected final ActivityInstanceService activityInstanceService;
    private final FlowNodeExecutor flowNodeExecutor;
    private final TechnicalLoggerService logger;
    protected final ProcessInstanceService processInstanceService;
    private final TokenService tokenService;
    private final WorkService workService;
    private final ProcessDefinitionService processDefinitionService;
    private final GatewayInstanceService gatewayInstanceService;
    private final TransitionService transitionService;
    private final EventInstanceService eventInstanceService;
    protected final ClassLoaderService classLoaderService;
    protected final ExpressionResolverService expressionResolverService;
    protected final ConnectorService connectorService;
    private final OperationService operationService;
    private final ProcessDocumentService processDocumentService;
    private final ReadSessionAccessor sessionAccessor;
    protected final BPMInstancesCreator bpmInstancesCreator;
    protected final EventsHandler eventsHandler;
    private final ConnectorInstanceService connectorInstanceService;

    public ProcessExecutorImpl(ActivityInstanceService activityInstanceService, ProcessInstanceService processInstanceService, TechnicalLoggerService logger, FlowNodeExecutor flowNodeExecutor, WorkService workService, ProcessDefinitionService processDefinitionService, GatewayInstanceService gatewayInstanceService, TransitionService transitionService, EventInstanceService eventInstanceService, ConnectorService connectorService, ConnectorInstanceService connectorInstanceService, ClassLoaderService classLoaderService, OperationService operationService, ExpressionResolverService expressionResolverService, EventService eventService, Map<String, SProcessInstanceHandler<SEvent>> handlers, ProcessDocumentService processDocumentService, ReadSessionAccessor sessionAccessor, ContainerRegistry containerRegistry, BPMInstancesCreator bpmInstancesCreator, TokenService tokenService, EventsHandler eventsHandler, TransactionService transactionService, FlowNodeStateManager flowNodeStateManager) {
        this.activityInstanceService = activityInstanceService;
        this.processInstanceService = processInstanceService;
        this.connectorInstanceService = connectorInstanceService;
        this.tokenService = tokenService;
        this.logger = logger;
        this.flowNodeExecutor = flowNodeExecutor;
        this.workService = workService;
        this.processDefinitionService = processDefinitionService;
        this.gatewayInstanceService = gatewayInstanceService;
        this.transitionService = transitionService;
        this.eventInstanceService = eventInstanceService;
        this.connectorService = connectorService;
        this.classLoaderService = classLoaderService;
        this.operationService = operationService;
        this.expressionResolverService = expressionResolverService;
        this.processDocumentService = processDocumentService;
        this.sessionAccessor = sessionAccessor;
        this.bpmInstancesCreator = bpmInstancesCreator;
        this.eventsHandler = eventsHandler;
        flowNodeStateManager.setProcessExecutor(this);
        eventsHandler.setProcessExecutor(this);
        for (Map.Entry<String, SProcessInstanceHandler<SEvent>> handler : handlers.entrySet()) {
            try {
                eventService.addHandler(handler.getKey(), (SHandler<SEvent>)handler.getValue());
            }
            catch (HandlerRegistrationException e) {
                if (logger.isLoggable(this.getClass(), TechnicalLogSeverity.WARNING)) {
                    logger.log(this.getClass(), TechnicalLogSeverity.WARNING, e.getMessage());
                }
                if (!logger.isLoggable(this.getClass(), TechnicalLogSeverity.DEBUG)) continue;
                logger.log(this.getClass(), TechnicalLogSeverity.DEBUG, e);
            }
        }
        containerRegistry.addContainerExecutor(this);
    }

    @Override
    public FlowNodeState executeFlowNode(long flowNodeInstanceId, SExpressionContext contextDependency, List<SOperation> operations, long processInstanceId, Long executerId, Long executerDelegateId) throws SFlowNodeExecutionException {
        return this.flowNodeExecutor.stepForward(flowNodeInstanceId, contextDependency, operations, processInstanceId, executerId, executerDelegateId);
    }

    private List<STransitionDefinition> evaluateOutgoingTransitions(List<STransitionDefinition> outgoingTransitionDefinitions, SProcessDefinition sDefinition, SFlowNodeInstance flowNodeInstance) throws SBonitaException {
        List<STransitionDefinition> chosenTransitionDefinitions = Collections.emptyList();
        if (SStateCategory.NORMAL.equals((Object)flowNodeInstance.getStateCategory())) {
            SExpressionContext sExpressionContext = new SExpressionContext((Long)flowNodeInstance.getId(), DataInstanceContainer.ACTIVITY_INSTANCE.name(), sDefinition.getId());
            if (SFlowNodeType.GATEWAY.equals((Object)flowNodeInstance.getType())) {
                SGatewayInstance gatewayInstance = (SGatewayInstance)flowNodeInstance;
                switch (gatewayInstance.getGatewayType()) {
                    case EXCLUSIVE: {
                        chosenTransitionDefinitions = this.evaluateTransitionsExclusively(sDefinition, flowNodeInstance, outgoingTransitionDefinitions, sExpressionContext);
                        break;
                    }
                    case INCLUSIVE: {
                        chosenTransitionDefinitions = this.evaluateTransitionsInclusively(sDefinition, flowNodeInstance, outgoingTransitionDefinitions, sExpressionContext);
                        break;
                    }
                    case PARALLEL: {
                        chosenTransitionDefinitions = this.evaluateTransitionsParallely(outgoingTransitionDefinitions);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unsupported gateway type: " + (Object)((Object)gatewayInstance.getGatewayType()));
                    }
                }
            } else {
                chosenTransitionDefinitions = SFlowNodeType.BOUNDARY_EVENT.equals((Object)flowNodeInstance.getType()) ? new ArrayList<STransitionDefinition>(outgoingTransitionDefinitions) : (outgoingTransitionDefinitions.isEmpty() ? new ArrayList<STransitionDefinition>(1) : this.evaluateTransitionsForImpliciteGateway(sDefinition, flowNodeInstance, outgoingTransitionDefinitions, sExpressionContext));
            }
        }
        return chosenTransitionDefinitions;
    }

    private int getNumberOfTokenToMerge(SFlowNodeInstance sFlownodeInstance) {
        if (SFlowNodeType.GATEWAY.equals((Object)sFlownodeInstance.getType())) {
            String hitBys = ((SGatewayInstance)sFlownodeInstance).getHitBys();
            String nbOfTokenToMerge = hitBys.substring("FINISH:".length());
            return Integer.parseInt(nbOfTokenToMerge);
        }
        return 1;
    }

    private List<STransitionDefinition> evaluateTransitionsExclusively(SProcessDefinition sDefinition, SFlowNodeInstance flowNodeInstance, List<STransitionDefinition> outgoingTransitionDefinitions, SExpressionContext sExpressionContext) throws SBonitaException {
        ArrayList<STransitionDefinition> chosenTransitions = new ArrayList<STransitionDefinition>(outgoingTransitionDefinitions.size());
        boolean transitionFound = false;
        for (STransitionDefinition sTransitionDefinition : outgoingTransitionDefinitions) {
            Boolean condition = this.evaluateCondition(sDefinition, sTransitionDefinition, sExpressionContext);
            if (condition != null && !condition.booleanValue()) continue;
            transitionFound = true;
            chosenTransitions.add(sTransitionDefinition);
            break;
        }
        if (!transitionFound) {
            STransitionDefinition defaultTransition = this.getDefaultTransition(sDefinition, flowNodeInstance);
            if (defaultTransition == null) {
                throw new SActivityExecutionException("There is no default transition on " + flowNodeInstance.getName() + " but no outgoing transition had a valid condition");
            }
            chosenTransitions.add(defaultTransition);
            outgoingTransitionDefinitions.add(defaultTransition);
        }
        return chosenTransitions;
    }

    private List<STransitionDefinition> evaluateTransitionsInclusively(SProcessDefinition sDefinition, SFlowNodeInstance flowNodeInstance, List<STransitionDefinition> outgoingTransitionDefinitions, SExpressionContext sExpressionContext) throws SBonitaException {
        ArrayList<STransitionDefinition> chosenTransitions = new ArrayList<STransitionDefinition>(outgoingTransitionDefinitions.size());
        for (STransitionDefinition sTransitionDefinition : outgoingTransitionDefinitions) {
            Boolean condition = this.evaluateCondition(sDefinition, sTransitionDefinition, sExpressionContext);
            if (condition != null && !condition.booleanValue()) continue;
            chosenTransitions.add(sTransitionDefinition);
        }
        if (chosenTransitions.isEmpty()) {
            STransitionDefinition defaultTransition = this.getDefaultTransition(sDefinition, flowNodeInstance);
            if (defaultTransition == null) {
                throw new SActivityExecutionException("There is no default transition on " + flowNodeInstance.getName() + " but no outgoing transition had a valid condition");
            }
            chosenTransitions.add(defaultTransition);
            outgoingTransitionDefinitions.add(defaultTransition);
        }
        return chosenTransitions;
    }

    private List<STransitionDefinition> evaluateTransitionsForImpliciteGateway(SProcessDefinition sDefinition, SFlowNodeInstance flowNodeInstance, List<STransitionDefinition> outgoingTransitionDefinitions, SExpressionContext sExpressionContext) throws SBonitaException {
        int transitionNumber = outgoingTransitionDefinitions.size();
        ArrayList<STransitionDefinition> conditionalTransitions = new ArrayList<STransitionDefinition>(transitionNumber);
        ArrayList<STransitionDefinition> conditionalFalseTransitions = new ArrayList<STransitionDefinition>(transitionNumber);
        ArrayList<STransitionDefinition> chosenTransitions = new ArrayList<STransitionDefinition>(transitionNumber);
        ArrayList<STransitionDefinition> normalTransitions = new ArrayList<STransitionDefinition>(transitionNumber);
        for (STransitionDefinition sTransitionDefinition : outgoingTransitionDefinitions) {
            Boolean condition = this.evaluateCondition(sDefinition, sTransitionDefinition, sExpressionContext);
            if (condition == null) {
                normalTransitions.add(sTransitionDefinition);
                continue;
            }
            if (condition.booleanValue()) {
                conditionalTransitions.add(sTransitionDefinition);
                continue;
            }
            conditionalFalseTransitions.add(sTransitionDefinition);
        }
        if (!normalTransitions.isEmpty()) {
            chosenTransitions.addAll(normalTransitions);
        }
        if (!conditionalTransitions.isEmpty()) {
            chosenTransitions.addAll(conditionalTransitions);
        } else if (!conditionalFalseTransitions.isEmpty()) {
            STransitionDefinition defaultTransition = this.getDefaultTransition(sDefinition, flowNodeInstance);
            if (defaultTransition == null) {
                throw new SActivityExecutionException("There is no default transition on " + flowNodeInstance.getName() + " but no outgoing transition had a valid condition");
            }
            chosenTransitions.add(defaultTransition);
        }
        return chosenTransitions;
    }

    private List<STransitionDefinition> evaluateTransitionsParallely(List<STransitionDefinition> outgoingTransitionDefinitions) {
        ArrayList<STransitionDefinition> chosenTransitions = new ArrayList<STransitionDefinition>(outgoingTransitionDefinitions.size());
        for (STransitionDefinition sTransitionDefinition : outgoingTransitionDefinitions) {
            chosenTransitions.add(sTransitionDefinition);
        }
        return chosenTransitions;
    }

    protected STransitionDefinition getDefaultTransition(SProcessDefinition sDefinition, SFlowNodeInstance flowNodeInstance) {
        SFlowElementContainerDefinition processContainer = sDefinition.getProcessContainer();
        SFlowNodeDefinition flowNode = processContainer.getFlowNode(flowNodeInstance.getFlowNodeDefinitionId());
        return flowNode.getDefaultTransition();
    }

    protected Boolean evaluateCondition(SProcessDefinition sDefinition, STransitionDefinition sTransitionDefinition, SExpressionContext contextDependency) throws SExpressionEvaluationException, SExpressionTypeUnknownException, SExpressionDependencyMissingException, SInvalidExpressionException {
        SFlowElementContainerDefinition processContainer = sDefinition.getProcessContainer();
        STransitionDefinition transition = processContainer.getTransition(sTransitionDefinition.getName());
        SExpression expression = transition.getCondition();
        if (expression == null) {
            return null;
        }
        if (!Boolean.class.getName().equals(expression.getReturnType())) {
            throw new SExpressionEvaluationException("Condition expression must return a boolean. on transition: " + sTransitionDefinition.getName());
        }
        return (Boolean)this.expressionResolverService.evaluate(expression, contextDependency);
    }

    private List<SFlowNodeDefinition> getStartNodes(SProcessDefinition definition, long targetSFlowNodeDefinitionId) {
        return this.getStartNodes(definition.getProcessContainer(), targetSFlowNodeDefinitionId);
    }

    private List<SFlowNodeDefinition> getStartNodes(SFlowElementContainerDefinition processContainer, long targetSFlowNodeDefinitionId) {
        Set<SFlowNodeDefinition> sFlowNodeDefinitions = processContainer.getFlowNodes();
        ArrayList<SFlowNodeDefinition> filteredSFlowNodeDefinitions = new ArrayList<SFlowNodeDefinition>();
        for (SFlowNodeDefinition sFlowNodeDefinition : sFlowNodeDefinitions) {
            if (!this.isAStartNode(targetSFlowNodeDefinitionId, sFlowNodeDefinition)) continue;
            filteredSFlowNodeDefinitions.add(sFlowNodeDefinition);
        }
        return filteredSFlowNodeDefinitions;
    }

    private boolean isAStartNode(long targetSFlowNodeDefinitionId, SFlowNodeDefinition sFlowNodeDefinition) {
        if (targetSFlowNodeDefinitionId != -1L) {
            return sFlowNodeDefinition.getId() == targetSFlowNodeDefinitionId;
        }
        return !(!sFlowNodeDefinition.getIncomingTransitions().isEmpty() || SFlowNodeType.SUB_PROCESS.equals((Object)sFlowNodeDefinition.getType()) && ((SSubProcessDefinition)sFlowNodeDefinition).isTriggeredByEvent() || SFlowNodeType.BOUNDARY_EVENT.equals((Object)sFlowNodeDefinition.getType()) || SFlowNodeType.START_EVENT.equals((Object)sFlowNodeDefinition.getType()) && !((SStartEventDefinition)sFlowNodeDefinition).getEventTriggers().isEmpty());
    }

    private List<SFlowNodeDefinition> getStartNodes(SProcessDefinition definition, long flowNodeDefinitionId, long targetSFlowNodeDefinitionId) {
        SSubProcessDefinition subProcDef = (SSubProcessDefinition)definition.getProcessContainer().getFlowNode(flowNodeDefinitionId);
        return this.getStartNodes(subProcDef.getSubProcessContainer(), targetSFlowNodeDefinitionId);
    }

    private SConnectorInstance getNextConnectorInstance(SProcessInstance processInstance, ConnectorEvent event) throws SConnectorInstanceReadException {
        List<SConnectorInstance> connectorInstances = this.connectorInstanceService.getConnectorInstances(processInstance.getId(), "process", event, 0, 1, "TO_BE_EXECUTED");
        return connectorInstances.size() == 1 ? connectorInstances.get(0) : null;
    }

    @Override
    public boolean executeConnectors(SProcessDefinition processDefinition, SProcessInstance sProcessInstance, ConnectorEvent activationEvent, ConnectorService connectorService) throws SBonitaException {
        SConnectorInstance nextConnectorInstance;
        SFlowElementContainerDefinition processContainer = processDefinition.getProcessContainer();
        long processDefinitionId = processDefinition.getId();
        List<SConnectorDefinition> connectors = processContainer.getConnectors(activationEvent);
        if (connectors.size() > 0 && (nextConnectorInstance = this.getNextConnectorInstance(sProcessInstance, activationEvent)) != null) {
            for (SConnectorDefinition sConnectorDefinition : connectors) {
                if (!sConnectorDefinition.getName().equals(nextConnectorInstance.getName())) continue;
                Long connectorInstanceId = nextConnectorInstance.getId();
                String connectorDefinitionName = sConnectorDefinition.getName();
                this.workService.registerWork(WorkFactory.createExecuteConnectorOfProcess(processDefinitionId, connectorInstanceId, connectorDefinitionName, sProcessInstance.getId(), sProcessInstance.getRootProcessInstanceId(), activationEvent));
                return true;
            }
        }
        return false;
    }

    private List<SFlowNodeInstance> initializeFirstExecutableElements(SProcessInstance sProcessInstance, SProcessDefinition sProcessDefinition, long flowNodeDefinitionId, long targetSFlowNodeDefinitionId) {
        try {
            List<SFlowNodeDefinition> flownNodeDefinitions = flowNodeDefinitionId == -1L ? this.getStartNodes(sProcessDefinition, targetSFlowNodeDefinitionId) : this.getStartNodes(sProcessDefinition, flowNodeDefinitionId, targetSFlowNodeDefinitionId);
            long rootProcessInstanceId = sProcessInstance.getRootProcessInstanceId();
            if (rootProcessInstanceId <= 0L) {
                rootProcessInstanceId = sProcessInstance.getId();
            }
            return this.bpmInstancesCreator.createFlowNodeInstances(sProcessDefinition.getId(), rootProcessInstanceId, sProcessInstance.getId(), flownNodeDefinitions, rootProcessInstanceId, sProcessInstance.getId(), SStateCategory.NORMAL, sProcessDefinition.getId());
        }
        catch (SBonitaException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.ERROR)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.ERROR, e);
            }
            throw new RuntimeException(e);
        }
    }

    private SProcessInstance createProcessInstance(SProcessDefinition sDefinition, long starterId, long starterDelegateId, long callerId, SFlowNodeType callerType, long rootProcessInstanceId) throws SProcessInstanceCreationException {
        SProcessInstanceBuilder processInstanceBuilder = BuilderFactory.get(SProcessInstanceBuilderFactory.class).createNewInstance(sDefinition).setStartedBy(starterId).setStartedByDelegate(starterDelegateId).setCallerId(callerId, callerType).setRootProcessInstanceId(rootProcessInstanceId);
        SProcessInstance sProcessInstance = processInstanceBuilder.done();
        this.processInstanceService.createProcessInstance(sProcessInstance);
        return sProcessInstance;
    }

    protected SProcessInstance createProcessInstance(SProcessDefinition processDefinition, long starterId, long starterDelegateId, long callerId) throws SProcessInstanceCreationException {
        SActivityInstance callerInstance = this.getCaller(callerId);
        SProcessInstance sProcessInstance = callerInstance != null ? this.createProcessInstance(processDefinition, starterId, starterDelegateId, callerId, callerInstance.getType(), callerInstance.getRootContainerId()) : this.createProcessInstance(processDefinition, starterId, starterDelegateId, callerId, null, -1L);
        return sProcessInstance;
    }

    private SActivityInstance getCaller(long callerId) throws SProcessInstanceCreationException {
        SActivityInstance callerInstance = null;
        if (callerId > 0L) {
            try {
                callerInstance = this.activityInstanceService.getActivityInstance(callerId);
            }
            catch (SBonitaException e) {
                throw new SProcessInstanceCreationException("Unable to get caller", e);
            }
        }
        return callerInstance;
    }

    private void executeGateway(SProcessDefinition sProcessDefinition, STransitionDefinition sTransitionDefinition, SFlowNodeInstance flowNodeThatTriggeredTheTransition, Long tokenRefId) throws SBonitaException {
        long parentProcessInstanceId = flowNodeThatTriggeredTheTransition.getParentProcessInstanceId();
        long rootProcessInstanceId = flowNodeThatTriggeredTheTransition.getRootProcessInstanceId();
        SFlowNodeDefinition sFlowNodeDefinition = this.processDefinitionService.getNextFlowNode(sProcessDefinition, sTransitionDefinition.getName());
        Long processDefinitionId = sProcessDefinition.getId();
        boolean isGateway = SFlowNodeType.GATEWAY.equals((Object)sFlowNodeDefinition.getType());
        boolean toExecute = false;
        try {
            Long nextFlowNodeInstanceId;
            SProcessInstance parentProcessInstance = this.processInstanceService.getProcessInstance(parentProcessInstanceId);
            SStateCategory stateCategory = parentProcessInstance.getStateCategory();
            if (isGateway) {
                SGatewayInstance gatewayInstance = this.createOrRetreiveGateway(processDefinitionId, sFlowNodeDefinition, stateCategory, tokenRefId, parentProcessInstanceId, rootProcessInstanceId, sTransitionDefinition);
                this.gatewayInstanceService.hitTransition(gatewayInstance, sFlowNodeDefinition.getTransitionIndex(sTransitionDefinition.getName()));
                nextFlowNodeInstanceId = gatewayInstance.getId();
                if (this.gatewayInstanceService.checkMergingCondition(sProcessDefinition, gatewayInstance)) {
                    this.gatewayInstanceService.setFinish(gatewayInstance);
                    toExecute = true;
                }
            } else {
                SFlowNodeInstance flowNodeInstance = this.bpmInstancesCreator.toFlowNodeInstance(processDefinitionId, flowNodeThatTriggeredTheTransition.getRootContainerId(), flowNodeThatTriggeredTheTransition.getParentContainerId(), SFlowElementsContainerType.PROCESS, sFlowNodeDefinition, rootProcessInstanceId, parentProcessInstanceId, true, -1, stateCategory, -1L, tokenRefId);
                new CreateEventInstance((SEventInstance)flowNodeInstance, this.eventInstanceService).call();
                nextFlowNodeInstanceId = flowNodeInstance.getId();
                toExecute = true;
            }
            if (toExecute) {
                this.workService.registerWork(WorkFactory.createExecuteFlowNodeWork(nextFlowNodeInstanceId, null, null, parentProcessInstanceId));
            }
        }
        catch (SBonitaException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.ERROR)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.ERROR, e);
            }
            throw e;
        }
    }

    private SGatewayInstance createOrRetreiveGateway(Long processDefinitionId, SFlowNodeDefinition flowNodeDefinition, SStateCategory stateCategory, Long tokenRefId, long parentProcessInstanceId, long rootProcessInstanceId, STransitionDefinition transitionDefinition) throws SBonitaException {
        SGatewayInstance gatewayInstance = null;
        try {
            gatewayInstance = this.gatewayInstanceService.getActiveGatewayInstanceOfTheProcess(parentProcessInstanceId, flowNodeDefinition.getName());
        }
        catch (SGatewayNotFoundException e) {
            // empty catch block
        }
        if (gatewayInstance != null && gatewayInstance.getHitBys() != null && (gatewayInstance.getHitBys().contains("FINISH:") || Arrays.asList(gatewayInstance.getHitBys().split(",")).contains(flowNodeDefinition.getTransitionIndex(transitionDefinition.getName())))) {
            gatewayInstance = null;
        }
        if (gatewayInstance != null && !tokenRefId.equals(gatewayInstance.getTokenRefId())) {
            throw new SFlowNodeExecutionException("Error while executing the join on gateway <" + gatewayInstance.getName() + "> of process instance <" + gatewayInstance.getParentProcessInstanceId() + "> of process definition <" + gatewayInstance.getProcessDefinitionId() + ">, this can happen when you try to join branches that are not from the same split level " + "(some branches were split more times than others). Check if your design is valid in the Bonita Studio." + " token is: <" + tokenRefId + "> expected <" + gatewayInstance.getTokenRefId() + ">");
        }
        if (gatewayInstance != null) {
            return gatewayInstance;
        }
        return this.createGateway(processDefinitionId, flowNodeDefinition, stateCategory, parentProcessInstanceId, tokenRefId, rootProcessInstanceId);
    }

    private SGatewayInstance createGateway(Long processDefinitionId, SFlowNodeDefinition flowNodeDefinition, SStateCategory stateCategory, long parentProcessInstanceId, Long tokenRefId, long rootProcessInstanceId) throws SBonitaException {
        return (SGatewayInstance)this.bpmInstancesCreator.createFlowNodeInstance(processDefinitionId, rootProcessInstanceId, parentProcessInstanceId, SFlowElementsContainerType.PROCESS, flowNodeDefinition, rootProcessInstanceId, parentProcessInstanceId, false, 0, stateCategory, -1L, tokenRefId);
    }

    protected void executeOperations(List<SOperation> operations, Map<String, Object> context, SExpressionContext expressionContext, SProcessInstance sProcessInstance) throws SBonitaException {
        if (operations != null && !operations.isEmpty()) {
            long processInstanceId = sProcessInstance.getId();
            for (SOperation operation : operations) {
                if (context != null) {
                    context = new HashMap<String, Object>(context);
                }
                expressionContext.setInputValues(context);
                this.operationService.execute(operation, processInstanceId, DataInstanceContainer.PROCESS_INSTANCE.name(), expressionContext);
            }
        }
    }

    protected boolean initialize(long userId, SProcessDefinition sProcessDefinition, SProcessInstance sProcessInstance, SExpressionContext expressionContext, List<SOperation> operations, Map<String, Object> context, SFlowElementContainerDefinition processContainer, List<ConnectorDefinitionWithInputValues> connectors) throws SProcessInstanceCreationException {
        try {
            this.bpmInstancesCreator.createDataInstances(sProcessInstance, processContainer, sProcessDefinition, expressionContext, operations, context);
            this.createDocuments(sProcessDefinition, sProcessInstance, userId);
            if (connectors != null) {
                this.executeConnectors(sProcessDefinition, sProcessInstance, connectors);
            }
            if (expressionContext == null) {
                expressionContext = new SExpressionContext();
            }
            this.executeOperations(operations, context, expressionContext, sProcessInstance);
            this.bpmInstancesCreator.createConnectorInstances(sProcessInstance, processContainer.getConnectors(), "process");
            return this.executeConnectors(sProcessDefinition, sProcessInstance, ConnectorEvent.ON_ENTER, this.connectorService);
        }
        catch (SProcessInstanceCreationException e) {
            throw e;
        }
        catch (SBonitaException e) {
            throw new SProcessInstanceCreationException(e);
        }
        catch (BonitaHomeNotSetException e) {
            throw new SProcessInstanceCreationException(e);
        }
        catch (IOException e) {
            throw new SProcessInstanceCreationException(e);
        }
        catch (InvalidEvaluationConnectorConditionException e) {
            throw new SProcessInstanceCreationException(e);
        }
    }

    protected void createDocuments(SProcessDefinition sDefinition, SProcessInstance sProcessInstance, long authorId) throws SBonitaException, IOException, BonitaHomeNotSetException {
        SFlowElementContainerDefinition processContainer = sDefinition.getProcessContainer();
        List<SDocumentDefinition> documentDefinitions = processContainer.getDocumentDefinitions();
        if (!documentDefinitions.isEmpty()) {
            String processesFolder = BonitaHomeServer.getInstance().getProcessFolder(this.sessionAccessor.getTenantId(), sDefinition.getId());
            File documentsFolder = new File(processesFolder, "documents");
            for (SDocumentDefinition document : documentDefinitions) {
                if (document.getFile() != null) {
                    String file = document.getFile();
                    byte[] content = FileUtils.readFileToByteArray((File)new File(documentsFolder, file));
                    this.attachDocument(sProcessInstance.getId(), document.getName(), document.getFileName(), document.getContentMimeType(), content, authorId);
                    continue;
                }
                if (document.getUrl() != null) {
                    this.attachDocument(sProcessInstance.getId(), document.getName(), document.getFileName(), document.getContentMimeType(), document.getUrl(), authorId);
                    continue;
                }
                throw new SProcessInstanceCreationException("Unable to create documents, a document was defined without url or content");
            }
        }
    }

    protected SProcessDocument attachDocument(long processInstanceId, String documentName, String fileName, String mimeType, String url, long authorId) throws SBonitaException {
        SProcessDocument attachment = this.buildExternalProcessDocumentReference(processInstanceId, documentName, fileName, mimeType, authorId, url);
        return this.processDocumentService.attachDocumentToProcessInstance(attachment);
    }

    protected SProcessDocument attachDocument(long processInstanceId, String documentName, String fileName, String mimeType, byte[] documentContent, long authorId) throws SBonitaException {
        SProcessDocument attachment = this.buildProcessDocument(processInstanceId, documentName, fileName, mimeType, authorId);
        return this.processDocumentService.attachDocumentToProcessInstance(attachment, documentContent);
    }

    private SProcessDocument buildExternalProcessDocumentReference(long processInstanceId, String documentName, String fileName, String mimeType, long authorId, String url) {
        SProcessDocumentBuilder documentBuilder = this.initDocumentBuilder(processInstanceId, documentName, fileName, mimeType, authorId);
        documentBuilder.setURL(url);
        documentBuilder.setHasContent(false);
        return documentBuilder.done();
    }

    private SProcessDocument buildProcessDocument(long processInstanceId, String documentName, String fileName, String mimetype, long authorId) {
        SProcessDocumentBuilder documentBuilder = this.initDocumentBuilder(processInstanceId, documentName, fileName, mimetype, authorId);
        documentBuilder.setHasContent(true);
        return documentBuilder.done();
    }

    private SProcessDocumentBuilder initDocumentBuilder(long processInstanceId, String documentName, String fileName, String mimetype, long authorId) {
        SProcessDocumentBuilder documentBuilder = BuilderFactory.get(SProcessDocumentBuilderFactory.class).createNewInstance();
        documentBuilder.setName(documentName);
        documentBuilder.setFileName(fileName);
        documentBuilder.setContentMimeType(mimetype);
        documentBuilder.setProcessInstanceId(processInstanceId);
        documentBuilder.setAuthor(authorId);
        documentBuilder.setCreationDate(System.currentTimeMillis());
        return documentBuilder;
    }

    @Override
    public void childFinished(long processDefinitionId, long flowNodeInstanceId, int stateId, long parentId) throws SBonitaException {
        SUserTaskInstanceBuilderFactory flowNodeKeyProvider;
        long processInstanceId;
        SProcessInstance sProcessInstance;
        SFlowNodeInstance sFlowNodeInstanceChild = this.activityInstanceService.getFlowNodeInstance(flowNodeInstanceId);
        SProcessDefinition sProcessDefinition = this.processDefinitionService.getProcessDefinition(processDefinitionId);
        int tokensOfProcess = this.executeValidOutgoingTransitionsAndUpdateTokens(sProcessDefinition, sFlowNodeInstanceChild, sProcessInstance = this.processInstanceService.getProcessInstance(processInstanceId = sFlowNodeInstanceChild.getLogicalGroup((flowNodeKeyProvider = BuilderFactory.get(SUserTaskInstanceBuilderFactory.class)).getParentProcessInstanceIndex())));
        if (tokensOfProcess == 0) {
            boolean hasActionsToExecute = false;
            if (ProcessInstanceState.ABORTING.getId() != sProcessInstance.getStateId()) {
                hasActionsToExecute = this.executePostThrowEventHandlers(sProcessDefinition, sProcessInstance, sFlowNodeInstanceChild);
                if (hasActionsToExecute) {
                    sProcessInstance = this.processInstanceService.getProcessInstance(processInstanceId);
                }
                this.eventsHandler.unregisterEventSubProcess(sProcessDefinition, sProcessInstance);
            }
            this.handleProcessCompletion(sProcessDefinition, sProcessInstance, hasActionsToExecute);
        }
    }

    @Override
    public void handleProcessCompletion(SProcessDefinition sProcessDefinition, SProcessInstance sProcessInstance, boolean hasActionsToExecute) throws SBonitaException {
        ProcessInstanceState processInstanceState;
        switch (sProcessInstance.getStateCategory()) {
            case ABORTING: {
                if (ProcessInstanceState.ABORTING.getId() == sProcessInstance.getStateId()) {
                    processInstanceState = ProcessInstanceState.ABORTED;
                    break;
                }
                if (hasActionsToExecute) {
                    processInstanceState = ProcessInstanceState.ABORTING;
                    break;
                }
                processInstanceState = ProcessInstanceState.ABORTED;
                break;
            }
            case CANCELLING: {
                processInstanceState = ProcessInstanceState.CANCELLED;
                break;
            }
            default: {
                processInstanceState = ProcessInstanceState.COMPLETING.getId() == sProcessInstance.getStateId() ? ProcessInstanceState.COMPLETED : (this.executeConnectors(sProcessDefinition, sProcessInstance, ConnectorEvent.ON_FINISH, this.connectorService) ? ProcessInstanceState.COMPLETING : ProcessInstanceState.COMPLETED);
            }
        }
        this.processInstanceService.setState(sProcessInstance, processInstanceState);
        if (this.tokenService.getNumberOfToken(sProcessInstance.getId()) == 0) {
            this.flowNodeExecutor.childReachedState(sProcessInstance, processInstanceState, hasActionsToExecute);
        }
    }

    private boolean executePostThrowEventHandlers(SProcessDefinition sProcessDefinition, SProcessInstance sProcessInstance, SFlowNodeInstance child) throws SBonitaException {
        boolean hasActionsToExecute = false;
        if (sProcessInstance.getInterruptingEventId() != -1L) {
            SFlowNodeInstance endEventInstance = this.activityInstanceService.getFlowNodeInstance(sProcessInstance.getInterruptingEventId());
            SEndEventDefinition endEventDefinition = (SEndEventDefinition)sProcessDefinition.getProcessContainer().getFlowNode(endEventInstance.getFlowNodeDefinitionId());
            hasActionsToExecute = this.eventsHandler.handlePostThrowEvent(sProcessDefinition, endEventDefinition, (SThrowEventInstance)endEventInstance, child);
            this.flowNodeExecutor.archiveFlowNodeInstance(endEventInstance, true, sProcessDefinition.getId());
        }
        return hasActionsToExecute;
    }

    private int executeValidOutgoingTransitionsAndUpdateTokens(SProcessDefinition sProcessDefinition, SFlowNodeInstance child, SProcessInstance sProcessInstance) throws SBonitaException {
        List<STransitionDefinition> allOutgoingTransitionDefinitions;
        int inputTransitionsSize;
        long parentProcessInstanceId = sProcessInstance.getId();
        long childId = child.getId();
        int numberOfTokenToMerge = this.getNumberOfTokenToMerge(child);
        SFlowNodeDefinition flowNode = sProcessDefinition.getProcessContainer().getFlowNode(child.getFlowNodeDefinitionId());
        if (flowNode == null) {
            inputTransitionsSize = 0;
            allOutgoingTransitionDefinitions = Collections.emptyList();
        } else {
            inputTransitionsSize = flowNode.getIncomingTransitions().size();
            allOutgoingTransitionDefinitions = new ArrayList<STransitionDefinition>(flowNode.getOutgoingTransitions());
        }
        List<STransitionDefinition> validOutgoingTransitionDefinitions = this.evaluateOutgoingTransitions(allOutgoingTransitionDefinitions, sProcessDefinition, child);
        long rootProcessInstanceId = child.getRootProcessInstanceId();
        ArrayList<STransitionDefinition> chosenGatewaysTransitions = new ArrayList<STransitionDefinition>(validOutgoingTransitionDefinitions.size());
        ArrayList<SFlowNodeDefinition> chosenFlowNode = new ArrayList<SFlowNodeDefinition>(validOutgoingTransitionDefinitions.size());
        boolean consumeInputToken = false;
        Long outputTokenRefId = null;
        Long outputParentTokenRefId = null;
        boolean createToken = false;
        boolean isParalleleOrInclusive = false;
        boolean isExclusive = false;
        boolean implicitEnd = false;
        if (flowNode instanceof SGatewayDefinition) {
            SGatewayType gatewayType = ((SGatewayDefinition)flowNode).getGatewayType();
            switch (gatewayType) {
                case EXCLUSIVE: {
                    isExclusive = true;
                    break;
                }
                case INCLUSIVE: {
                    isParalleleOrInclusive = true;
                    break;
                }
                case PARALLEL: {
                    isParalleleOrInclusive = true;
                }
            }
        }
        if (flowNode == null) {
            consumeInputToken = false;
            createToken = false;
            implicitEnd = false;
        } else if (SFlowNodeType.BOUNDARY_EVENT.equals((Object)child.getType())) {
            consumeInputToken = false;
            createToken = false;
            implicitEnd = false;
            SBoundaryEventInstance boundaryEventInstance = (SBoundaryEventInstance)child;
            if (boundaryEventInstance.isInterrupting()) {
                SToken token = this.tokenService.getToken(boundaryEventInstance.getParentProcessInstanceId(), boundaryEventInstance.getTokenRefId());
                outputTokenRefId = token.getRefId();
                outputParentTokenRefId = token.getParentRefId();
            } else {
                outputTokenRefId = boundaryEventInstance.getId();
                outputParentTokenRefId = null;
            }
        } else if (validOutgoingTransitionDefinitions.size() > 0) {
            SToken token;
            if (isExclusive) {
                consumeInputToken = false;
                outputTokenRefId = child.getTokenRefId();
                createToken = false;
            } else if (inputTransitionsSize <= 1) {
                if (allOutgoingTransitionDefinitions.size() <= 1) {
                    consumeInputToken = false;
                    outputTokenRefId = child.getTokenRefId();
                    createToken = false;
                } else {
                    consumeInputToken = false;
                    outputTokenRefId = child.getId();
                    outputParentTokenRefId = child.getTokenRefId();
                    createToken = true;
                }
            } else if (allOutgoingTransitionDefinitions.size() <= 1) {
                if (isParalleleOrInclusive) {
                    consumeInputToken = true;
                    token = this.tokenService.getToken(sProcessInstance.getId(), child.getTokenRefId());
                    outputTokenRefId = token.getParentRefId();
                    createToken = false;
                } else {
                    consumeInputToken = false;
                    outputTokenRefId = child.getTokenRefId();
                    createToken = false;
                }
            } else if (isParalleleOrInclusive) {
                consumeInputToken = true;
                outputTokenRefId = child.getId();
                token = this.tokenService.getToken(sProcessInstance.getId(), child.getTokenRefId());
                outputParentTokenRefId = token.getParentRefId();
                createToken = true;
            } else {
                consumeInputToken = false;
                outputTokenRefId = child.getId();
                outputParentTokenRefId = child.getTokenRefId();
                createToken = true;
            }
        } else {
            implicitEnd = true;
            consumeInputToken = false;
            createToken = false;
        }
        for (STransitionDefinition sTransitionDefinition : allOutgoingTransitionDefinitions) {
            if (validOutgoingTransitionDefinitions.contains(sTransitionDefinition)) continue;
            this.transitionService.archive(sTransitionDefinition, child, TransitionState.ABORTED);
        }
        for (STransitionDefinition sTransitionDefinition : validOutgoingTransitionDefinitions) {
            SFlowNodeDefinition flowNodeDefinition = this.processDefinitionService.getNextFlowNode(sProcessDefinition, sTransitionDefinition.getName());
            this.transitionService.archive(sTransitionDefinition, child, TransitionState.TAKEN);
            if (flowNodeDefinition instanceof SGatewayDefinition) {
                chosenGatewaysTransitions.add(sTransitionDefinition);
                continue;
            }
            chosenFlowNode.add(flowNodeDefinition);
        }
        if (childId != sProcessInstance.getInterruptingEventId() || SFlowNodeType.SUB_PROCESS.equals((Object)sProcessInstance.getCallerType())) {
            this.flowNodeExecutor.archiveFlowNodeInstance(child, true, sProcessDefinition.getId());
        }
        this.createAndExecuteActivities(sProcessDefinition.getId(), child, parentProcessInstanceId, chosenFlowNode, rootProcessInstanceId, outputTokenRefId);
        for (STransitionDefinition sTransitionDefinition : chosenGatewaysTransitions) {
            this.executeGateway(sProcessDefinition, sTransitionDefinition, child, outputTokenRefId);
        }
        if (consumeInputToken) {
            this.tokenService.deleteTokens(sProcessInstance.getId(), child.getTokenRefId(), numberOfTokenToMerge);
        }
        if (createToken) {
            this.tokenService.createTokens(sProcessInstance.getId(), outputTokenRefId, outputParentTokenRefId, validOutgoingTransitionDefinitions.size());
        }
        if (implicitEnd) {
            Long tokenRefId = child.getTokenRefId();
            if (tokenRefId == null) {
                throw new SObjectNotFoundException("no token ref id set for " + child);
            }
            this.implicitEnd(sProcessDefinition, sProcessInstance.getId(), numberOfTokenToMerge, tokenRefId);
        }
        return this.tokenService.getNumberOfToken(sProcessInstance.getId());
    }

    private void implicitEnd(SProcessDefinition processDefinition, long processInstanceId, int numberOfTokenToMerge, Long tokenRefId) throws SGatewayModificationException, WorkRegisterException, SBonitaException {
        SGatewayInstance gatewayInstance;
        SToken token = this.tokenService.getToken(processInstanceId, tokenRefId);
        this.tokenService.deleteTokens(processInstanceId, tokenRefId, numberOfTokenToMerge);
        if (processDefinition.getProcessContainer().containsInclusiveGateway() && (gatewayInstance = this.gatewayInstanceService.getGatewayMergingToken(processInstanceId, tokenRefId)) != null && this.gatewayInstanceService.checkMergingCondition(processDefinition, gatewayInstance)) {
            this.gatewayInstanceService.setFinish(gatewayInstance);
            this.workService.registerWork(WorkFactory.createExecuteFlowNodeWork(gatewayInstance.getId(), null, null, processInstanceId));
        }
        if (token.getParentRefId() != null && this.tokenService.getNumberOfToken(processInstanceId, tokenRefId) == 0) {
            this.implicitEnd(processDefinition, processInstanceId, 1, token.getParentRefId());
        }
    }

    @Override
    public SProcessInstance start(SProcessDefinition sProcessDefinition, long starterId, long starterDelegateId, List<SOperation> operations, Map<String, Object> context, List<ConnectorDefinitionWithInputValues> connectorsWithInput) throws SProcessInstanceCreationException {
        return this.start(sProcessDefinition, -1L, starterId, starterDelegateId, null, operations, context, connectorsWithInput, -1L, -1L);
    }

    @Override
    public SProcessInstance start(long processDefinitionId, long targetSFlowNodeDefinitionId, long starterId, long starterDelegateId, SExpressionContext expressionContext, List<SOperation> operations, Map<String, Object> context, List<ConnectorDefinitionWithInputValues> connectorsWithInput, long callerId, long subProcessDefinitionId) throws SProcessInstanceCreationException {
        try {
            SProcessDefinition sProcessDefinition = this.processDefinitionService.getProcessDefinition(processDefinitionId);
            return this.start(sProcessDefinition, targetSFlowNodeDefinitionId, starterId, starterDelegateId, expressionContext, operations, context, connectorsWithInput, callerId, subProcessDefinitionId);
        }
        catch (SProcessDefinitionNotFoundException e) {
            throw new SProcessInstanceCreationException(e);
        }
        catch (SProcessDefinitionReadException e) {
            throw new SProcessInstanceCreationException(e);
        }
    }

    @Override
    public SProcessInstance start(SProcessDefinition sProcessDefinition, long targetSFlowNodeDefinitionId, long starterId, long starterDelegateId, SExpressionContext expressionContext, List<SOperation> operations, Map<String, Object> context, List<ConnectorDefinitionWithInputValues> connectors, long callerId, long subProcessDefinitionId) throws SProcessInstanceCreationException {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader localClassLoader = this.classLoaderService.getLocalClassLoader("process", sProcessDefinition.getId());
            Thread.currentThread().setContextClassLoader(localClassLoader);
            try {
                localClassLoader.loadClass(this.getClass().getName());
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            SProcessInstance sProcessInstance = this.createProcessInstance(sProcessDefinition, starterId, starterDelegateId, callerId);
            SFlowElementContainerDefinition processContainer = this.getProcessContainer(sProcessDefinition, subProcessDefinitionId);
            boolean isInitializing = this.initialize(starterId, sProcessDefinition, sProcessInstance, expressionContext, operations != null ? new ArrayList<SOperation>(operations) : operations, context, processContainer, connectors);
            this.handleEventSubProcess(sProcessDefinition, sProcessInstance, subProcessDefinitionId);
            if (isInitializing) {
                this.processInstanceService.setState(sProcessInstance, ProcessInstanceState.INITIALIZING);
                SProcessInstance sProcessInstance2 = sProcessInstance;
                return sProcessInstance2;
            }
            SProcessInstance sProcessInstance3 = this.startElements(sProcessDefinition, sProcessInstance, subProcessDefinitionId, targetSFlowNodeDefinitionId);
            return sProcessInstance3;
        }
        catch (SBonitaException e) {
            throw new SProcessInstanceCreationException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    protected void executeConnectors(SProcessDefinition processDefinition, SProcessInstance sProcessInstance, List<ConnectorDefinitionWithInputValues> connectorsList) throws InvalidEvaluationConnectorConditionException, SBonitaException {
        SExpressionContext expcontext = new SExpressionContext();
        expcontext.setProcessDefinitionId(processDefinition.getId());
        expcontext.setProcessDefinition(processDefinition);
        expcontext.setContainerId(sProcessInstance.getId());
        expcontext.setContainerType(DataInstanceContainer.PROCESS_INSTANCE.name());
        for (ConnectorDefinitionWithInputValues connectorWithInput : connectorsList) {
            ConnectorDefinition connectorDefinition = connectorWithInput.getConnectorDefinition();
            Map contextInputValues = connectorWithInput.getInputValues();
            String connectorId = connectorDefinition.getConnectorId();
            String version = connectorDefinition.getVersion();
            Map inputs = connectorDefinition.getInputs();
            if (contextInputValues.size() != inputs.size()) {
                throw new InvalidEvaluationConnectorConditionException(contextInputValues.size(), inputs.size());
            }
            Map<String, SExpression> connectorsExps = ModelConvertor.constructExpressions(inputs);
            ConnectorResult result = this.connectorService.executeMutipleEvaluation(processDefinition.getId(), connectorId, version, connectorsExps, contextInputValues, Thread.currentThread().getContextClassLoader(), expcontext);
            List outputs = connectorDefinition.getOutputs();
            ArrayList<SOperation> sOperations = new ArrayList<SOperation>(outputs.size());
            for (Operation operation : outputs) {
                sOperations.add(ModelConvertor.constructSOperation(operation));
            }
            this.connectorService.executeOutputOperation(sOperations, expcontext, result);
        }
    }

    protected SFlowElementContainerDefinition getProcessContainer(SProcessDefinition processDefinition, long subProcessDefinitionId) {
        SFlowElementContainerDefinition processContainer = subProcessDefinitionId == -1L ? processDefinition.getProcessContainer() : ((SSubProcessDefinition)processDefinition.getProcessContainer().getFlowNode(subProcessDefinitionId)).getSubProcessContainer();
        return processContainer;
    }

    protected void handleEventSubProcess(SProcessDefinition processDefinition, SProcessInstance sProcessInstance, long subProcessDefinitionId) throws SActivityExecutionException {
        if (subProcessDefinitionId == -1L) {
            try {
                this.eventsHandler.handleEventSubProcess(processDefinition, sProcessInstance);
            }
            catch (SBonitaException e) {
                throw new SActivityExecutionException("Unable to register events for event sub process in process " + processDefinition.getName() + " " + processDefinition.getVersion(), e);
            }
        }
    }

    @Override
    public SProcessInstance startElements(SProcessDefinition sDefinition, SProcessInstance sProcessInstance) throws SProcessInstanceCreationException, SFlowNodeExecutionException {
        return this.startElements(sDefinition, sProcessInstance, -1L, -1L);
    }

    @Override
    public SProcessInstance startElements(SProcessDefinition sDefinition, SProcessInstance sProcessInstance, long subProcessDefinitionId, long targetSFlowNodeDefinitionId) throws SProcessInstanceCreationException, SFlowNodeExecutionException {
        List<SFlowNodeInstance> flowNodeInstances = this.initializeFirstExecutableElements(sProcessInstance, sDefinition, subProcessDefinitionId, targetSFlowNodeDefinitionId);
        int size = flowNodeInstances.size();
        ProcessInstanceState state = size == 0 ? ProcessInstanceState.COMPLETED : ProcessInstanceState.STARTED;
        try {
            this.tokenService.createTokens(sProcessInstance.getId(), sProcessInstance.getProcessDefinitionId(), null, size);
            this.processInstanceService.setState(sProcessInstance, state);
        }
        catch (SBonitaException e) {
            throw new SProcessInstanceCreationException("Unable to set the state on the process", e);
        }
        for (SFlowNodeInstance flowNode : flowNodeInstances) {
            try {
                this.workService.registerWork(WorkFactory.createExecuteFlowNodeWork(flowNode.getId(), null, null, sProcessInstance.getId()));
            }
            catch (WorkRegisterException e) {
                throw new SFlowNodeExecutionException("unable to trigger execution of flow node " + flowNode, e);
            }
        }
        return sProcessInstance;
    }

    @Override
    public String getHandledType() {
        return SFlowElementsContainerType.PROCESS.name();
    }

    private void createAndExecuteActivities(Long processDefinitionId, SFlowNodeInstance flowNodeInstance, long parentProcessInstanceId, List<SFlowNodeDefinition> choosenActivityDefinitions, long rootProcessInstanceId, Long tokenRefId) throws SBonitaException {
        SProcessInstance parentProcessInstance = this.processInstanceService.getProcessInstance(parentProcessInstanceId);
        SStateCategory stateCategory = parentProcessInstance.getStateCategory();
        List<SFlowNodeInstance> sFlowNodeInstances = this.bpmInstancesCreator.createFlowNodeInstances(processDefinitionId, flowNodeInstance.getRootContainerId(), flowNodeInstance.getParentContainerId(), choosenActivityDefinitions, rootProcessInstanceId, parentProcessInstanceId, stateCategory, tokenRefId);
        for (SFlowNodeInstance sFlowNodeInstance : sFlowNodeInstances) {
            this.workService.registerWork(WorkFactory.createExecuteFlowNodeWork(sFlowNodeInstance.getId(), null, null, parentProcessInstanceId));
        }
    }
}

