/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.execution.work;

import java.util.List;
import org.bonitasoft.engine.bpm.connector.ConnectorEvent;
import org.bonitasoft.engine.bpm.process.ProcessInstanceState;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.connector.ConnectorService;
import org.bonitasoft.engine.core.process.definition.ProcessDefinitionService;
import org.bonitasoft.engine.core.process.definition.SProcessDefinitionNotFoundException;
import org.bonitasoft.engine.core.process.definition.exception.SProcessDefinitionReadException;
import org.bonitasoft.engine.core.process.definition.model.SProcessDefinition;
import org.bonitasoft.engine.core.process.instance.api.ProcessInstanceService;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SProcessInstanceReadException;
import org.bonitasoft.engine.core.process.instance.model.SProcessInstance;
import org.bonitasoft.engine.execution.ProcessExecutor;
import org.bonitasoft.engine.execution.work.RestartException;
import org.bonitasoft.engine.execution.work.TenantRestartHandler;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.service.PlatformServiceAccessor;
import org.bonitasoft.engine.service.TenantServiceAccessor;

public class RestartProcessHandler
implements TenantRestartHandler {
    @Override
    public void handleRestart(PlatformServiceAccessor platformServiceAccessor, TenantServiceAccessor tenantServiceAccessor) throws RestartException {
        QueryOptions queryOptions = QueryOptions.defaultQueryOptions();
        ProcessExecutor processExecutor = tenantServiceAccessor.getProcessExecutor();
        ProcessInstanceService processInstanceService = tenantServiceAccessor.getProcessInstanceService();
        ProcessDefinitionService processDefinitionService = tenantServiceAccessor.getProcessDefinitionService();
        ConnectorService connectorService = tenantServiceAccessor.getConnectorService();
        TechnicalLoggerService logger = tenantServiceAccessor.getTechnicalLoggerService();
        boolean info = logger.isLoggable(this.getClass(), TechnicalLogSeverity.INFO);
        if (info) {
            logger.log(this.getClass(), TechnicalLogSeverity.INFO, "restarting connectors of process...");
        }
        try {
            SProcessDefinition processDefinition;
            List<SProcessInstance> processInstances;
            do {
                processInstances = processInstanceService.getProcessInstancesInState(queryOptions, ProcessInstanceState.INITIALIZING);
                queryOptions = QueryOptions.getNextPage(queryOptions);
                for (SProcessInstance processInstance : processInstances) {
                    processDefinition = processDefinitionService.getProcessDefinition(processInstance.getProcessDefinitionId());
                    if (info) {
                        logger.log(this.getClass(), TechnicalLogSeverity.INFO, "executing on enter connectors of process " + processInstance);
                    }
                    processExecutor.executeConnectors(processDefinition, processInstance, ConnectorEvent.ON_ENTER, connectorService);
                }
            } while (processInstances.size() == queryOptions.getNumberOfResults());
            do {
                processInstances = processInstanceService.getProcessInstancesInState(queryOptions, ProcessInstanceState.COMPLETING);
                queryOptions = QueryOptions.getNextPage(queryOptions);
                for (SProcessInstance processInstance : processInstances) {
                    processDefinition = processDefinitionService.getProcessDefinition(processInstance.getProcessDefinitionId());
                    if (info) {
                        logger.log(this.getClass(), TechnicalLogSeverity.INFO, "executing on finish connectors of process " + processInstance);
                    }
                    processExecutor.executeConnectors(processDefinition, processInstance, ConnectorEvent.ON_FINISH, connectorService);
                }
            } while (processInstances.size() == queryOptions.getNumberOfResults());
        }
        catch (SProcessInstanceReadException e) {
            this.handleException(e, "Unable to restart process: can't read process instances");
        }
        catch (SProcessDefinitionNotFoundException e) {
            this.handleException(e, "Unable to restart process: can't find process definition");
        }
        catch (SProcessDefinitionReadException e) {
            this.handleException(e, "Unable to restart process: can't read process definition");
        }
        catch (SBonitaException e) {
            this.handleException(e, "Unable to restart process: can't execute connectors");
        }
    }

    private void handleException(Exception e, String message) throws RestartException {
        throw new RestartException(message, e);
    }
}

