/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.synchro;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import org.bonitasoft.engine.cache.CacheException;
import org.bonitasoft.engine.cache.CommonCacheService;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.synchro.SynchroService;

public abstract class AbstractSynchroService
implements SynchroService {
    protected static final String SYNCHRO_SERVICE_CACHE = "SYNCHRO_SERVICE_CACHE";
    protected final TechnicalLoggerService logger;
    protected final CommonCacheService cacheService;

    protected abstract Map<Map<String, Serializable>, String> getWaitersMap();

    protected abstract Map<String, Serializable> getEventKeyAndIdMap();

    protected abstract void releaseWaiter(String var1);

    protected abstract Lock getServiceLock();

    public AbstractSynchroService(TechnicalLoggerService logger, CommonCacheService cacheService) {
        this.logger = logger;
        this.cacheService = cacheService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fireEvent(Map<String, Serializable> event, Serializable id) {
        block6: {
            this.logger.log(this.getClass(), TechnicalLogSeverity.DEBUG, "Firing event " + event + " with id " + id);
            this.getServiceLock().lock();
            try {
                String semaphoreKey = this.getWaiterAndRemoveIt(event);
                if (semaphoreKey == null) {
                    this.logger.log(this.getClass(), TechnicalLogSeverity.DEBUG, "No waiter found, storing event " + event);
                    try {
                        this.cacheService.store(SYNCHRO_SERVICE_CACHE, (Serializable)((Object)event), id);
                        break block6;
                    }
                    catch (CacheException e) {
                        throw new RuntimeException(e);
                    }
                }
                this.getEventKeyAndIdMap().put(semaphoreKey, id);
                this.logger.log(this.getClass(), TechnicalLogSeverity.DEBUG, "releasing waiter for event " + event + " and id " + id);
                this.releaseWaiter(semaphoreKey);
            }
            finally {
                this.getServiceLock().unlock();
            }
        }
    }

    protected String getWaiterAndRemoveIt(Map<String, Serializable> event) {
        Iterator<Map.Entry<Map<String, Serializable>, String>> iterator = this.getWaitersMap().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Map<String, Serializable>, String> waiter = iterator.next();
            if (!this.matchedAtLeastAllExpectedEntries(waiter.getKey(), event)) continue;
            iterator.remove();
            return waiter.getValue();
        }
        return null;
    }

    protected boolean matchedAtLeastAllExpectedEntries(Map<String, Serializable> expectedEventEntries, Map<String, Serializable> actualEventEntries) {
        for (Map.Entry<String, Serializable> expectedEventEntry : expectedEventEntries.entrySet()) {
            Serializable expectedValue = expectedEventEntry.getValue();
            if (expectedValue.equals(actualEventEntries.get(expectedEventEntry.getKey()))) continue;
            return false;
        }
        return true;
    }

    protected Serializable getFiredAndRemoveIt(Map<String, Serializable> expectedEvent) {
        try {
            List<Object> firedEvents = this.cacheService.getKeys(SYNCHRO_SERVICE_CACHE);
            for (Map map : firedEvents) {
                if (!this.matchedAtLeastAllExpectedEntries(expectedEvent, map)) continue;
                this.cacheService.remove(SYNCHRO_SERVICE_CACHE, map);
                return (Serializable)map.get("id");
            }
        }
        catch (CacheException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    protected void throwTimeout(Map<String, Serializable> event, long timeout) throws TimeoutException {
        throw new TimeoutException("Event '" + event + "' has not been received on time after waiting '" + timeout + " ms'");
    }

    @Override
    public void clearAllEvents() {
        try {
            this.cacheService.clear(SYNCHRO_SERVICE_CACHE);
        }
        catch (CacheException e) {
            throw new RuntimeException(e);
        }
        this.getWaitersMap().clear();
    }

    @Override
    public boolean hasWaiters() {
        return !this.getWaitersMap().isEmpty();
    }
}

