/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine;

import java.util.Properties;
import org.bonitasoft.engine.exception.BonitaRuntimeException;
import org.bonitasoft.engine.home.BonitaHomeServer;

public class EngineInitializerProperties {
    protected static final String PROPERTIES_FILENAME = "platform-tenant-config.properties";
    public static final String PLATFORM_CREATE = "platform.create";
    protected static final String NODE_START = "node.start";
    protected static final String NODE_STOP = "node.stop";
    protected static final String PLATFORM_ADMIN_USERNAME = "platformAdminUsername";
    protected static final String TENANT_ADMIN_USERNAME = "userName";
    private Properties platformProperties;

    public EngineInitializerProperties() {
        try {
            this.platformProperties = BonitaHomeServer.getInstance().getPlatformProperties();
        }
        catch (Exception e) {
            throw new BonitaRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    public boolean shouldCreatePlatform() {
        String needCreate = this.getProperty(PLATFORM_CREATE, this.platformProperties);
        return Boolean.valueOf(needCreate);
    }

    public boolean shouldStartPlatform() {
        String start = this.getProperty(NODE_START, this.platformProperties);
        return Boolean.valueOf(start);
    }

    public boolean shouldStopPlatform() {
        String stop = this.getProperty(NODE_STOP, this.platformProperties);
        return Boolean.valueOf(stop);
    }

    public String getPlatformAdminUsername() {
        String platformAdminUsername = PLATFORM_ADMIN_USERNAME;
        return this.getProperty(platformAdminUsername, this.platformProperties);
    }

    private String getProperty(String propertyName, Properties properties) {
        String property = properties.getProperty(propertyName);
        if (property == null) {
            throw new IllegalStateException("Mandatory property not set in bonita-platform.properties: " + propertyName);
        }
        return property;
    }

    public String getTenantAdminUsername(long tenantId) {
        try {
            return this.getProperty(TENANT_ADMIN_USERNAME, BonitaHomeServer.getInstance().getTenantProperties(tenantId));
        }
        catch (Exception e) {
            throw new BonitaRuntimeException(e.getMessage(), (Throwable)e);
        }
    }
}

