/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bonitasoft.engine.actor.mapping.ActorMappingService;
import org.bonitasoft.engine.actor.mapping.model.SActor;
import org.bonitasoft.engine.api.IdentityAPI;
import org.bonitasoft.engine.api.impl.SessionInfos;
import org.bonitasoft.engine.api.impl.resolver.ActorProcessDependencyResolver;
import org.bonitasoft.engine.api.impl.transaction.actor.GetActor;
import org.bonitasoft.engine.api.impl.transaction.identity.AddUserMembership;
import org.bonitasoft.engine.api.impl.transaction.identity.AddUserMemberships;
import org.bonitasoft.engine.api.impl.transaction.identity.CreateGroup;
import org.bonitasoft.engine.api.impl.transaction.identity.CreateRole;
import org.bonitasoft.engine.api.impl.transaction.identity.CreateUser;
import org.bonitasoft.engine.api.impl.transaction.identity.DeleteGroup;
import org.bonitasoft.engine.api.impl.transaction.identity.DeleteGroups;
import org.bonitasoft.engine.api.impl.transaction.identity.DeleteRole;
import org.bonitasoft.engine.api.impl.transaction.identity.DeleteRoles;
import org.bonitasoft.engine.api.impl.transaction.identity.DeleteUser;
import org.bonitasoft.engine.api.impl.transaction.identity.DeleteUsers;
import org.bonitasoft.engine.api.impl.transaction.identity.GetGroupByPath;
import org.bonitasoft.engine.api.impl.transaction.identity.GetGroups;
import org.bonitasoft.engine.api.impl.transaction.identity.GetNumberOfInstance;
import org.bonitasoft.engine.api.impl.transaction.identity.GetNumberOfUserMemberships;
import org.bonitasoft.engine.api.impl.transaction.identity.GetNumberOfUsersInType;
import org.bonitasoft.engine.api.impl.transaction.identity.GetRole;
import org.bonitasoft.engine.api.impl.transaction.identity.GetRoleByName;
import org.bonitasoft.engine.api.impl.transaction.identity.GetRoles;
import org.bonitasoft.engine.api.impl.transaction.identity.GetSContactInfo;
import org.bonitasoft.engine.api.impl.transaction.identity.GetSGroup;
import org.bonitasoft.engine.api.impl.transaction.identity.GetSUser;
import org.bonitasoft.engine.api.impl.transaction.identity.GetUserMembership;
import org.bonitasoft.engine.api.impl.transaction.identity.GetUserMembershipsOfGroup;
import org.bonitasoft.engine.api.impl.transaction.identity.GetUserMembershipsOfRole;
import org.bonitasoft.engine.api.impl.transaction.identity.GetUsersInGroup;
import org.bonitasoft.engine.api.impl.transaction.identity.GetUsersInRole;
import org.bonitasoft.engine.api.impl.transaction.identity.UpdateGroup;
import org.bonitasoft.engine.api.impl.transaction.identity.UpdateMembershipByRoleIdAndGroupId;
import org.bonitasoft.engine.api.impl.transaction.identity.UpdateRole;
import org.bonitasoft.engine.api.impl.transaction.identity.UpdateUser;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.commons.NullCheckingUtil;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.exceptions.SObjectAlreadyExistsException;
import org.bonitasoft.engine.core.process.definition.ProcessDefinitionService;
import org.bonitasoft.engine.core.process.instance.api.ActivityInstanceService;
import org.bonitasoft.engine.core.process.instance.api.ProcessInstanceService;
import org.bonitasoft.engine.exception.AlreadyExistsException;
import org.bonitasoft.engine.exception.BonitaRuntimeException;
import org.bonitasoft.engine.exception.CreationException;
import org.bonitasoft.engine.exception.DeletionException;
import org.bonitasoft.engine.exception.RetrieveException;
import org.bonitasoft.engine.exception.SearchException;
import org.bonitasoft.engine.exception.UpdateException;
import org.bonitasoft.engine.external.identity.mapping.ExternalIdentityMappingService;
import org.bonitasoft.engine.identity.ContactData;
import org.bonitasoft.engine.identity.ContactDataUpdater;
import org.bonitasoft.engine.identity.Group;
import org.bonitasoft.engine.identity.GroupCreator;
import org.bonitasoft.engine.identity.GroupCriterion;
import org.bonitasoft.engine.identity.GroupNotFoundException;
import org.bonitasoft.engine.identity.GroupUpdater;
import org.bonitasoft.engine.identity.IdentityService;
import org.bonitasoft.engine.identity.ImportPolicy;
import org.bonitasoft.engine.identity.MembershipNotFoundException;
import org.bonitasoft.engine.identity.OrganizationExportException;
import org.bonitasoft.engine.identity.OrganizationImportException;
import org.bonitasoft.engine.identity.Role;
import org.bonitasoft.engine.identity.RoleCreator;
import org.bonitasoft.engine.identity.RoleCriterion;
import org.bonitasoft.engine.identity.RoleNotFoundException;
import org.bonitasoft.engine.identity.RoleUpdater;
import org.bonitasoft.engine.identity.SGroupNotFoundException;
import org.bonitasoft.engine.identity.SIdentityException;
import org.bonitasoft.engine.identity.SRoleNotFoundException;
import org.bonitasoft.engine.identity.SUserNotFoundException;
import org.bonitasoft.engine.identity.User;
import org.bonitasoft.engine.identity.UserCreator;
import org.bonitasoft.engine.identity.UserCriterion;
import org.bonitasoft.engine.identity.UserMembership;
import org.bonitasoft.engine.identity.UserMembershipCriterion;
import org.bonitasoft.engine.identity.UserNotFoundException;
import org.bonitasoft.engine.identity.UserUpdater;
import org.bonitasoft.engine.identity.UserWithContactData;
import org.bonitasoft.engine.identity.impl.UserWithContactDataImpl;
import org.bonitasoft.engine.identity.model.SContactInfo;
import org.bonitasoft.engine.identity.model.SGroup;
import org.bonitasoft.engine.identity.model.SRole;
import org.bonitasoft.engine.identity.model.SUser;
import org.bonitasoft.engine.identity.model.SUserMembership;
import org.bonitasoft.engine.identity.model.builder.SContactInfoUpdateBuilder;
import org.bonitasoft.engine.identity.model.builder.SContactInfoUpdateBuilderFactory;
import org.bonitasoft.engine.identity.model.builder.SGroupBuilderFactory;
import org.bonitasoft.engine.identity.model.builder.SGroupUpdateBuilder;
import org.bonitasoft.engine.identity.model.builder.SGroupUpdateBuilderFactory;
import org.bonitasoft.engine.identity.model.builder.SRoleBuilderFactory;
import org.bonitasoft.engine.identity.model.builder.SRoleUpdateBuilder;
import org.bonitasoft.engine.identity.model.builder.SRoleUpdateBuilderFactory;
import org.bonitasoft.engine.identity.model.builder.SUserBuilderFactory;
import org.bonitasoft.engine.identity.model.builder.SUserMembershipBuilderFactory;
import org.bonitasoft.engine.identity.model.builder.SUserMembershipUpdateBuilderFactory;
import org.bonitasoft.engine.identity.model.builder.SUserUpdateBuilder;
import org.bonitasoft.engine.identity.model.builder.SUserUpdateBuilderFactory;
import org.bonitasoft.engine.identity.xml.ExportOrganization;
import org.bonitasoft.engine.identity.xml.ImportOrganization;
import org.bonitasoft.engine.persistence.OrderByOption;
import org.bonitasoft.engine.persistence.OrderByType;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.profile.ProfileService;
import org.bonitasoft.engine.recorder.model.EntityUpdateDescriptor;
import org.bonitasoft.engine.search.SearchOptions;
import org.bonitasoft.engine.search.SearchResult;
import org.bonitasoft.engine.search.descriptor.SearchEntitiesDescriptor;
import org.bonitasoft.engine.search.identity.SearchGroups;
import org.bonitasoft.engine.search.identity.SearchRoles;
import org.bonitasoft.engine.search.identity.SearchUsers;
import org.bonitasoft.engine.service.ModelConvertor;
import org.bonitasoft.engine.service.TenantServiceAccessor;
import org.bonitasoft.engine.service.TenantServiceSingleton;
import org.bonitasoft.engine.service.impl.ServiceAccessorFactory;
import org.bonitasoft.engine.sessionaccessor.SessionAccessor;
import org.bonitasoft.engine.supervisor.mapping.SupervisorMappingService;

public class IdentityAPIImpl
implements IdentityAPI {
    protected TenantServiceAccessor getTenantAccessor() {
        try {
            SessionAccessor sessionAccessor = ServiceAccessorFactory.getInstance().createSessionAccessor();
            long tenantId = sessionAccessor.getTenantId();
            return TenantServiceSingleton.getInstance(tenantId);
        }
        catch (Exception e) {
            throw new BonitaRuntimeException((Throwable)e);
        }
    }

    public User createUser(String userName, String password) throws AlreadyExistsException, CreationException {
        UserCreator creator = new UserCreator(userName, password);
        creator.setEnabled(true);
        return this.createUser(creator);
    }

    public User createUser(String userName, String password, String firstName, String lastName) throws AlreadyExistsException, CreationException {
        UserCreator creator = new UserCreator(userName, password);
        creator.setFirstName(firstName).setLastName(lastName);
        creator.setEnabled(true);
        return this.createUser(creator);
    }

    public User createUser(UserCreator creator) throws AlreadyExistsException, CreationException {
        if (creator == null) {
            throw new CreationException("Can not create a null user.");
        }
        Map fields = creator.getFields();
        String userName = (String)fields.get(UserCreator.UserField.NAME);
        if (userName == null || userName.trim().isEmpty()) {
            throw new CreationException("The user name cannot be null or empty.");
        }
        String password = (String)fields.get(UserCreator.UserField.PASSWORD);
        if (password == null || password.trim().isEmpty()) {
            throw new CreationException("The password cannot be null or empty.");
        }
        Boolean isEnabled = (Boolean)fields.get(UserCreator.UserField.ENABLED);
        if (isEnabled == null) {
            creator.setEnabled(true);
        }
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        SUser sUser = ModelConvertor.constructSUser(creator);
        SContactInfo sPersoData = ModelConvertor.constructSUserContactInfo(creator, sUser.getId(), true);
        SContactInfo sProlData = ModelConvertor.constructSUserContactInfo(creator, sUser.getId(), false);
        return this.createUser(tenantAccessor, sUser, sPersoData, sProlData);
    }

    public User updateUser(long userId, UserUpdater updater) throws UserNotFoundException, UpdateException {
        if (updater == null || !updater.hasFields()) {
            throw new UpdateException("The update descriptor does not contain field updates");
        }
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        IdentityService identityService = tenantAccessor.getIdentityService();
        EntityUpdateDescriptor userChangeDescriptor = this.getUserUpdateDescriptor(updater);
        EntityUpdateDescriptor persoDataChangeDescriptor = this.getUserContactInfoUpdateDescriptor(updater.getPersoContactUpdater());
        EntityUpdateDescriptor proDataChangeDescriptor = this.getUserContactInfoUpdateDescriptor(updater.getProContactUpdater());
        try {
            UpdateUser updateUserTransaction = new UpdateUser(identityService, userId, userChangeDescriptor, persoDataChangeDescriptor, proDataChangeDescriptor);
            updateUserTransaction.execute();
            return ModelConvertor.toUser(updateUserTransaction.getResult());
        }
        catch (SUserNotFoundException sunfe) {
            throw new UserNotFoundException((Throwable)sunfe);
        }
        catch (SBonitaException e) {
            throw new UpdateException((Throwable)e);
        }
    }

    private EntityUpdateDescriptor getUserUpdateDescriptor(UserUpdater updateDescriptor) {
        SUserUpdateBuilder userUpdateBuilder = BuilderFactory.get(SUserUpdateBuilderFactory.class).createNewInstance();
        if (updateDescriptor != null) {
            Map fields = updateDescriptor.getFields();
            for (Map.Entry field : fields.entrySet()) {
                switch ((UserUpdater.UserField)field.getKey()) {
                    case USER_NAME: {
                        userUpdateBuilder.updateUserName((String)field.getValue());
                        break;
                    }
                    case PASSWORD: {
                        userUpdateBuilder.updatePassword((String)field.getValue());
                        break;
                    }
                    case FIRST_NAME: {
                        userUpdateBuilder.updateFirstName((String)field.getValue());
                        break;
                    }
                    case LAST_NAME: {
                        userUpdateBuilder.updateLastName((String)field.getValue());
                        break;
                    }
                    case MANAGER_ID: {
                        userUpdateBuilder.updateManagerUserId((Long)field.getValue());
                        break;
                    }
                    case ICON_NAME: {
                        userUpdateBuilder.updateIconName((String)field.getValue());
                        break;
                    }
                    case ICON_PATH: {
                        userUpdateBuilder.updateIconPath((String)field.getValue());
                        break;
                    }
                    case TITLE: {
                        userUpdateBuilder.updateTitle((String)field.getValue());
                        break;
                    }
                    case JOB_TITLE: {
                        userUpdateBuilder.updateJobTitle((String)field.getValue());
                        break;
                    }
                    case ENABLED: {
                        userUpdateBuilder.updateEnabled((Boolean)field.getValue());
                    }
                }
            }
            userUpdateBuilder.updateLastUpdate(System.currentTimeMillis());
            return userUpdateBuilder.done();
        }
        return null;
    }

    private EntityUpdateDescriptor getUserContactInfoUpdateDescriptor(ContactDataUpdater updater) {
        SContactInfoUpdateBuilder updateBuilder = BuilderFactory.get(SContactInfoUpdateBuilderFactory.class).createNewInstance();
        if (updater != null) {
            Map fields = updater.getFields();
            for (Map.Entry field : fields.entrySet()) {
                switch ((ContactDataUpdater.ContactDataField)field.getKey()) {
                    case EMAIL: {
                        updateBuilder.updateEmail((String)field.getValue());
                        break;
                    }
                    case PHONE: {
                        updateBuilder.updatePhoneNumber((String)field.getValue());
                        break;
                    }
                    case MOBILE: {
                        updateBuilder.updateMobileNumber((String)field.getValue());
                        break;
                    }
                    case FAX: {
                        updateBuilder.updateFaxNumber((String)field.getValue());
                        break;
                    }
                    case BUILDING: {
                        updateBuilder.updateBuilding((String)field.getValue());
                        break;
                    }
                    case ROOM: {
                        updateBuilder.updateRoom((String)field.getValue());
                        break;
                    }
                    case ADDRESS: {
                        updateBuilder.updateAddress((String)field.getValue());
                        break;
                    }
                    case ZIP_CODE: {
                        updateBuilder.updateZipCode((String)field.getValue());
                        break;
                    }
                    case CITY: {
                        updateBuilder.updateCity((String)field.getValue());
                        break;
                    }
                    case STATE: {
                        updateBuilder.updateState((String)field.getValue());
                        break;
                    }
                    case COUNTRY: {
                        updateBuilder.updateCountry((String)field.getValue());
                        break;
                    }
                    case WEBSITE: {
                        updateBuilder.updateWebsite((String)field.getValue());
                    }
                }
            }
            return updateBuilder.done();
        }
        return null;
    }

    public void deleteUser(long userId) throws DeletionException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        IdentityService identityService = tenantAccessor.getIdentityService();
        ActorMappingService actorMappingService = tenantAccessor.getActorMappingService();
        ProfileService profileService = tenantAccessor.getProfileService();
        try {
            DeleteUser deleteUser = new DeleteUser(identityService, actorMappingService, profileService, userId);
            deleteUser.execute();
            Set<Long> removedActorIds = deleteUser.getRemovedActorIds();
            this.updateActorProcessDependencies(tenantAccessor, actorMappingService, removedActorIds);
        }
        catch (SBonitaException sbe) {
            throw new DeletionException((Throwable)sbe);
        }
    }

    public void deleteUser(String userName) throws DeletionException {
        if (userName == null) {
            throw new DeletionException("User name can not be null!");
        }
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        IdentityService identityService = tenantAccessor.getIdentityService();
        ActorMappingService actorMappingService = tenantAccessor.getActorMappingService();
        ProfileService profileService = tenantAccessor.getProfileService();
        try {
            DeleteUser deleteUser = new DeleteUser(identityService, actorMappingService, profileService, userName);
            deleteUser.execute();
            Set<Long> removedActorIds = deleteUser.getRemovedActorIds();
            this.updateActorProcessDependencies(tenantAccessor, actorMappingService, removedActorIds);
        }
        catch (SBonitaException sbe) {
            throw new DeletionException((Throwable)sbe);
        }
    }

    public void deleteUsers(List<Long> userIds) throws DeletionException {
        if (userIds != null && !userIds.isEmpty()) {
            TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
            IdentityService identityService = tenantAccessor.getIdentityService();
            ActorMappingService actorMappingService = tenantAccessor.getActorMappingService();
            ProfileService profileService = tenantAccessor.getProfileService();
            try {
                DeleteUsers deleteUsers = new DeleteUsers(identityService, actorMappingService, profileService, userIds);
                deleteUsers.execute();
            }
            catch (SBonitaException sbe) {
                throw new DeletionException((Throwable)sbe);
            }
        }
    }

    public User getUser(long userId) throws UserNotFoundException {
        if (userId == -1L) {
            throw new UserNotFoundException("The technical user is not a usable user");
        }
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        IdentityService identityService = tenantAccessor.getIdentityService();
        try {
            GetSUser transactionContent = new GetSUser(identityService, userId);
            transactionContent.execute();
            return ModelConvertor.toUser(transactionContent.getResult());
        }
        catch (SUserNotFoundException sunfe) {
            throw new UserNotFoundException((Throwable)sunfe);
        }
        catch (SBonitaException sbe) {
            throw new RetrieveException((Throwable)sbe);
        }
    }

    public User getUserByUserName(String userName) throws UserNotFoundException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        IdentityService identityService = tenantAccessor.getIdentityService();
        try {
            GetSUser transactionContent = new GetSUser(identityService, userName);
            transactionContent.execute();
            return ModelConvertor.toUser(transactionContent.getResult());
        }
        catch (SUserNotFoundException sunfe) {
            throw new UserNotFoundException((Throwable)sunfe);
        }
        catch (SBonitaException sbe) {
            throw new RetrieveException((Throwable)sbe);
        }
    }

    public UserWithContactData getUserWithProfessionalDetails(long userId) throws UserNotFoundException {
        User user = this.getUser(userId);
        ContactData contactData = this.getUserContactData(userId, false);
        return new UserWithContactDataImpl(user, contactData);
    }

    public ContactData getUserContactData(long userId, boolean personal) throws UserNotFoundException {
        if (userId == -1L) {
            throw new UserNotFoundException("The technical user is not a usable user");
        }
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        IdentityService identityService = tenantAccessor.getIdentityService();
        try {
            GetSContactInfo txContent = new GetSContactInfo(userId, identityService, personal);
            txContent.execute();
            SContactInfo result = txContent.getResult();
            if (result == null) {
                return null;
            }
            return ModelConvertor.toUserContactData(result);
        }
        catch (SBonitaException sbe) {
            throw new RetrieveException((Throwable)sbe);
        }
    }

    public long getNumberOfUsers() {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        IdentityService identityService = tenantAccessor.getIdentityService();
        try {
            GetNumberOfInstance transactionContent = new GetNumberOfInstance("getNumberOfUsers", identityService);
            transactionContent.execute();
            return transactionContent.getResult();
        }
        catch (SBonitaException sbe) {
            throw new RetrieveException((Throwable)sbe);
        }
    }

    public List<User> getUsers(int startIndex, int maxResults, UserCriterion criterion) {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        try {
            IdentityService identityService = tenantAccessor.getIdentityService();
            return this.getUsersWithOrder(startIndex, maxResults, criterion, tenantAccessor, identityService);
        }
        catch (SBonitaException sbe) {
            throw new RetrieveException((Throwable)sbe);
        }
    }

    public Map<Long, User> getUsers(List<Long> userIds) {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        IdentityService identityService = tenantAccessor.getIdentityService();
        HashMap<Long, User> users = new HashMap<Long, User>();
        try {
            List<SUser> sUsers = identityService.getUsers(userIds);
            for (SUser sUser : sUsers) {
                users.put(sUser.getId(), ModelConvertor.toUser(sUser));
            }
            return users;
        }
        catch (SUserNotFoundException sunfe) {
            throw new RetrieveException((Throwable)sunfe);
        }
    }

    public Map<String, User> getUsersByUsernames(List<String> userNames) {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        IdentityService identityService = tenantAccessor.getIdentityService();
        HashMap<String, User> users = new HashMap<String, User>();
        try {
            List<SUser> sUsers = identityService.getUsersByUsername(userNames);
            for (SUser sUser : sUsers) {
                users.put(sUser.getUserName(), ModelConvertor.toUser(sUser));
            }
            return users;
        }
        catch (SIdentityException sunfe) {
            throw new RetrieveException((Throwable)sunfe);
        }
    }

    public SearchResult<User> searchUsers(SearchOptions options) throws SearchException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        IdentityService identityService = tenantAccessor.getIdentityService();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        SearchUsers searchUsers = new SearchUsers(identityService, searchEntitiesDescriptor.getSearchUserDescriptor(), options);
        try {
            searchUsers.execute();
            return searchUsers.getResult();
        }
        catch (SBonitaException sbe) {
            throw new SearchException((Throwable)sbe);
        }
    }

    public long getNumberOfUsersInRole(long roleId) {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        IdentityService identityService = tenantAccessor.getIdentityService();
        try {
            GetNumberOfUsersInType transactionContentWithResult = new GetNumberOfUsersInType(roleId, "getNumberOfUsersInRole", identityService);
            transactionContentWithResult.execute();
            return transactionContentWithResult.getResult();
        }
        catch (SBonitaException sbe) {
            throw new RetrieveException((Throwable)sbe);
        }
    }

    public List<User> getUsersInRole(long roleId, int startIndex, int maxResults, UserCriterion criterion) {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        IdentityService identityService = tenantAccessor.getIdentityService();
        SUserBuilderFactory sUserfactory = BuilderFactory.get(SUserBuilderFactory.class);
        String field = null;
        OrderByType order = null;
        switch (criterion) {
            case FIRST_NAME_ASC: {
                field = sUserfactory.getFirstNameKey();
                order = OrderByType.ASC;
                break;
            }
            case LAST_NAME_ASC: {
                field = sUserfactory.getLastNameKey();
                order = OrderByType.ASC;
                break;
            }
            case USER_NAME_ASC: {
                field = sUserfactory.getUserNameKey();
                order = OrderByType.ASC;
                break;
            }
            case FIRST_NAME_DESC: {
                field = sUserfactory.getFirstNameKey();
                order = OrderByType.DESC;
                break;
            }
            case LAST_NAME_DESC: {
                field = sUserfactory.getLastNameKey();
                order = OrderByType.DESC;
                break;
            }
            case USER_NAME_DESC: {
                field = sUserfactory.getUserNameKey();
                order = OrderByType.DESC;
            }
        }
        try {
            String fieldExecutor = field;
            OrderByType orderExecutor = order;
            GetUsersInRole getUsersInRole = new GetUsersInRole(roleId, startIndex, maxResults, fieldExecutor, orderExecutor, identityService);
            getUsersInRole.execute();
            return ModelConvertor.toUsers((List<SUser>)getUsersInRole.getResult());
        }
        catch (SBonitaException sbe) {
            throw new RetrieveException((Throwable)sbe);
        }
    }

    public long getNumberOfUsersInGroup(long groupId) {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        IdentityService identityService = tenantAccessor.getIdentityService();
        GetNumberOfUsersInType transactionContentWithResult = new GetNumberOfUsersInType(groupId, "getNumberOfUsersInGroup", identityService);
        try {
            transactionContentWithResult.execute();
            return transactionContentWithResult.getResult();
        }
        catch (SBonitaException sbe) {
            throw new RetrieveException((Throwable)sbe);
        }
    }

    public List<User> getUsersInGroup(long groupId, int startIndex, int maxResults, UserCriterion crterion) {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        IdentityService identityService = tenantAccessor.getIdentityService();
        SUserBuilderFactory sUserFact = BuilderFactory.get(SUserBuilderFactory.class);
        String field = null;
        OrderByType order = null;
        switch (crterion) {
            case FIRST_NAME_ASC: {
                field = sUserFact.getFirstNameKey();
                order = OrderByType.ASC;
                break;
            }
            case LAST_NAME_ASC: {
                field = sUserFact.getLastNameKey();
                order = OrderByType.ASC;
                break;
            }
            case USER_NAME_ASC: {
                field = sUserFact.getUserNameKey();
                order = OrderByType.ASC;
                break;
            }
            case FIRST_NAME_DESC: {
                field = sUserFact.getFirstNameKey();
                order = OrderByType.DESC;
                break;
            }
            case LAST_NAME_DESC: {
                field = sUserFact.getLastNameKey();
                order = OrderByType.DESC;
                break;
            }
            case USER_NAME_DESC: {
                field = sUserFact.getUserNameKey();
                order = OrderByType.DESC;
            }
        }
        try {
            GetUsersInGroup getUsersOfGroup = new GetUsersInGroup(groupId, startIndex, maxResults, order, field, identityService);
            getUsersOfGroup.execute();
            return ModelConvertor.toUsers((List<SUser>)getUsersOfGroup.getResult());
        }
        catch (SBonitaException sbe) {
            throw new RetrieveException((Throwable)sbe);
        }
    }

    public Role createRole(String roleName) throws AlreadyExistsException, CreationException {
        return this.createRole(new RoleCreator(roleName));
    }

    public Role createRole(RoleCreator creator) throws AlreadyExistsException, CreationException {
        if (creator == null) {
            throw new CreationException("Unable to create a role with a null RoleCreator object");
        }
        if (creator.getFields().get(RoleCreator.RoleField.NAME) == null) {
            throw new CreationException("Unable to create a role with a null name");
        }
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        IdentityService identityService = tenantAccessor.getIdentityService();
        SRole sRole = ModelConvertor.constructSRole(creator);
        try {
            this.getRoleByName(sRole.getName());
            throw new AlreadyExistsException("A role named \"" + sRole.getName() + "\" already exists");
        }
        catch (RoleNotFoundException rnfe) {
            try {
                CreateRole createRole = new CreateRole(sRole, identityService);
                createRole.execute();
                return ModelConvertor.toRole(sRole);
            }
            catch (SBonitaException sbe) {
                throw new CreationException("Role create exception!", (Throwable)sbe);
            }
        }
    }

    public Role updateRole(long roleId, RoleUpdater updateDescriptor) throws RoleNotFoundException, UpdateException {
        if (updateDescriptor == null || updateDescriptor.getFields().isEmpty()) {
            throw new UpdateException("The update descriptor does not contain field updates");
        }
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        IdentityService identityService = tenantAccessor.getIdentityService();
        try {
            EntityUpdateDescriptor changeDescriptor = this.getRoleUpdateDescriptor(updateDescriptor);
            UpdateRole updateRole = new UpdateRole(changeDescriptor, roleId, identityService);
            updateRole.execute();
            return this.getRole(roleId);
        }
        catch (SRoleNotFoundException srnfe) {
            throw new RoleNotFoundException((Throwable)srnfe);
        }
        catch (SBonitaException e) {
            throw new UpdateException((Throwable)e);
        }
    }

    private EntityUpdateDescriptor getRoleUpdateDescriptor(RoleUpdater updateDescriptor) {
        SRoleUpdateBuilder roleUpdateBuilder = BuilderFactory.get(SRoleUpdateBuilderFactory.class).createNewInstance();
        Map fields = updateDescriptor.getFields();
        for (Map.Entry field : fields.entrySet()) {
            switch ((RoleUpdater.RoleField)field.getKey()) {
                case NAME: {
                    roleUpdateBuilder.updateName((String)field.getValue());
                    break;
                }
                case DISPLAY_NAME: {
                    roleUpdateBuilder.updateDisplayName((String)field.getValue());
                    break;
                }
                case DESCRIPTION: {
                    roleUpdateBuilder.updateDescription((String)field.getValue());
                    break;
                }
                case ICON_NAME: {
                    roleUpdateBuilder.updateIconName((String)field.getValue());
                    break;
                }
                case ICON_PATH: {
                    roleUpdateBuilder.updateIconPath((String)field.getValue());
                    break;
                }
            }
        }
        roleUpdateBuilder.updateLastUpdate(System.currentTimeMillis());
        return roleUpdateBuilder.done();
    }

    public void deleteRole(long roleId) throws DeletionException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        IdentityService identityService = tenantAccessor.getIdentityService();
        ActorMappingService actorMappingService = tenantAccessor.getActorMappingService();
        ProfileService profileService = tenantAccessor.getProfileService();
        DeleteRole deleteRole = new DeleteRole(identityService, actorMappingService, profileService, roleId);
        try {
            deleteRole.execute();
            Set<Long> removedActorIds = deleteRole.getRemovedActorIds();
            this.updateActorProcessDependencies(tenantAccessor, actorMappingService, removedActorIds);
        }
        catch (SRoleNotFoundException srnfe) {
        }
        catch (SBonitaException sbe) {
            throw new DeletionException((Throwable)sbe);
        }
    }

    public void deleteRoles(List<Long> roleIds) throws DeletionException {
        try {
            NullCheckingUtil.checkArgsNotNull(roleIds);
        }
        catch (IllegalArgumentException e) {
            throw new DeletionException((Throwable)e);
        }
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        IdentityService identityService = tenantAccessor.getIdentityService();
        ActorMappingService actorMappingService = tenantAccessor.getActorMappingService();
        ProfileService profileService = tenantAccessor.getProfileService();
        DeleteRoles deleteRoles = new DeleteRoles(identityService, actorMappingService, profileService, roleIds);
        try {
            deleteRoles.execute();
        }
        catch (SBonitaException e) {
            throw new DeletionException((Throwable)e);
        }
    }

    public Role getRole(long roleId) throws RoleNotFoundException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        IdentityService identityService = tenantAccessor.getIdentityService();
        try {
            GetRole getRole = new GetRole(roleId, identityService);
            getRole.execute();
            return ModelConvertor.toRole(getRole.getResult());
        }
        catch (SBonitaException sbe) {
            throw new RoleNotFoundException((Throwable)sbe);
        }
    }

    public Role getRoleByName(String roleName) throws RoleNotFoundException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        IdentityService identityService = tenantAccessor.getIdentityService();
        try {
            GetRoleByName getRoleByName = new GetRoleByName(roleName, identityService);
            getRoleByName.execute();
            return ModelConvertor.toRole(getRoleByName.getResult());
        }
        catch (SBonitaException e) {
            throw new RoleNotFoundException((Throwable)e);
        }
    }

    public long getNumberOfRoles() {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        IdentityService identityService = tenantAccessor.getIdentityService();
        try {
            GetNumberOfInstance getNumberOfInstance = new GetNumberOfInstance("getNumberOfRoles", identityService);
            getNumberOfInstance.execute();
            return getNumberOfInstance.getResult();
        }
        catch (SBonitaException e) {
            return 0L;
        }
    }

    public List<Role> getRoles(int startIndex, int maxResults, RoleCriterion criterion) {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        IdentityService identityService = tenantAccessor.getIdentityService();
        SRoleBuilderFactory sRoleFactory = BuilderFactory.get(SRoleBuilderFactory.class);
        String field = null;
        OrderByType order = null;
        switch (criterion) {
            case NAME_ASC: {
                field = sRoleFactory.getNameKey();
                order = OrderByType.ASC;
                break;
            }
            case NAME_DESC: {
                field = sRoleFactory.getNameKey();
                order = OrderByType.DESC;
                break;
            }
            case DISPLAY_NAME_ASC: {
                field = sRoleFactory.getDisplayNameKey();
                order = OrderByType.ASC;
                break;
            }
            case DISPLAY_NAME_DESC: {
                field = sRoleFactory.getDisplayNameKey();
                order = OrderByType.DESC;
            }
        }
        try {
            String fieldExecutor = field;
            OrderByType orderExecutor = order;
            GetRoles getRolesWithOrder = new GetRoles(identityService, startIndex, maxResults, fieldExecutor, orderExecutor);
            getRolesWithOrder.execute();
            return ModelConvertor.toRoles((List<SRole>)getRolesWithOrder.getResult());
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    public Map<Long, Role> getRoles(List<Long> roleIds) {
        HashMap<Long, Role> roles = new HashMap<Long, Role>();
        for (Long roleId : roleIds) {
            try {
                Role role = this.getRole(roleId);
                roles.put(roleId, role);
            }
            catch (RoleNotFoundException e) {}
        }
        return roles;
    }

    public SearchResult<Role> searchRoles(SearchOptions options) {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        IdentityService identityService = tenantAccessor.getIdentityService();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        SearchRoles searchRoles = new SearchRoles(identityService, searchEntitiesDescriptor.getSearchRoleDescriptor(), options);
        try {
            searchRoles.execute();
            return searchRoles.getResult();
        }
        catch (SBonitaException sbe) {
            throw new BonitaRuntimeException((Throwable)sbe);
        }
    }

    public Group createGroup(String name, String parentPath) throws AlreadyExistsException, CreationException {
        GroupCreator groupCreator = new GroupCreator(name);
        groupCreator.setParentPath(parentPath);
        return this.createGroup(groupCreator);
    }

    public Group createGroup(GroupCreator creator) throws AlreadyExistsException, CreationException {
        if (creator == null) {
            throw new CreationException("Cannot create a null group");
        }
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        IdentityService identityService = tenantAccessor.getIdentityService();
        SGroup sGroup = ModelConvertor.constructSGroup(creator);
        try {
            CreateGroup createGroup = new CreateGroup(sGroup, identityService);
            createGroup.execute();
            return ModelConvertor.toGroup(sGroup);
        }
        catch (SObjectAlreadyExistsException e) {
            throw new AlreadyExistsException(e.getMessage());
        }
        catch (SBonitaException e) {
            throw new CreationException((Throwable)e);
        }
    }

    public Group updateGroup(long groupId, GroupUpdater updater) throws GroupNotFoundException, UpdateException {
        if (updater == null || updater.getFields().isEmpty()) {
            throw new UpdateException("The update descriptor does not contain field updates");
        }
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        IdentityService identityService = tenantAccessor.getIdentityService();
        try {
            SGroup group = this.getSGroup(groupId, tenantAccessor);
            EntityUpdateDescriptor changeDescriptor = this.getGroupUpdateDescriptor(updater);
            UpdateGroup updateGroup = new UpdateGroup(group.getId(), changeDescriptor, identityService);
            updateGroup.execute();
            return this.getGroup(groupId);
        }
        catch (SGroupNotFoundException sgnfe) {
            throw new GroupNotFoundException((Throwable)sgnfe);
        }
        catch (SBonitaException sbe) {
            throw new UpdateException((Throwable)sbe);
        }
    }

    private EntityUpdateDescriptor getGroupUpdateDescriptor(GroupUpdater updateDescriptor) throws UpdateException {
        SGroupUpdateBuilder groupUpdateBuilder = BuilderFactory.get(SGroupUpdateBuilderFactory.class).createNewInstance();
        Map fields = updateDescriptor.getFields();
        block8: for (Map.Entry field : fields.entrySet()) {
            switch ((GroupUpdater.GroupField)field.getKey()) {
                case NAME: {
                    groupUpdateBuilder.updateName((String)field.getValue());
                    continue block8;
                }
                case DISPLAY_NAME: {
                    groupUpdateBuilder.updateDisplayName((String)field.getValue());
                    continue block8;
                }
                case DESCRIPTION: {
                    groupUpdateBuilder.updateDescription((String)field.getValue());
                    continue block8;
                }
                case ICON_NAME: {
                    groupUpdateBuilder.updateIconName((String)field.getValue());
                    continue block8;
                }
                case ICON_PATH: {
                    groupUpdateBuilder.updateIconPath((String)field.getValue());
                    continue block8;
                }
                case PARENT_PATH: {
                    groupUpdateBuilder.updateParentPath((String)field.getValue());
                    continue block8;
                }
            }
            throw new UpdateException("Invalid field: " + ((GroupUpdater.GroupField)field.getKey()).name());
        }
        groupUpdateBuilder.updateLastUpdate(System.currentTimeMillis());
        return groupUpdateBuilder.done();
    }

    public void deleteGroup(long groupId) throws DeletionException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        IdentityService identityService = tenantAccessor.getIdentityService();
        ActorMappingService actorMappingService = tenantAccessor.getActorMappingService();
        ProfileService profileService = tenantAccessor.getProfileService();
        DeleteGroup deleteGroup = new DeleteGroup(identityService, actorMappingService, profileService, groupId);
        try {
            deleteGroup.execute();
            this.updateActorProcessDependencies(tenantAccessor, actorMappingService, deleteGroup.getRemovedActorIds());
        }
        catch (SBonitaException sbe) {
            throw new DeletionException((Throwable)sbe);
        }
    }

    public void deleteGroups(List<Long> groupIds) throws DeletionException {
        if (groupIds == null) {
            throw new IllegalArgumentException("the list of groups is null");
        }
        if (!groupIds.isEmpty()) {
            TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
            IdentityService identityService = tenantAccessor.getIdentityService();
            ActorMappingService actorMappingService = tenantAccessor.getActorMappingService();
            ProfileService profileService = tenantAccessor.getProfileService();
            try {
                DeleteGroups deleteGroups = new DeleteGroups(identityService, actorMappingService, profileService, groupIds);
                deleteGroups.execute();
                this.updateActorProcessDependencies(tenantAccessor, actorMappingService, deleteGroups.getRemovedActorIds());
            }
            catch (SBonitaException e) {
                throw new DeletionException((Throwable)e);
            }
        }
    }

    public Group getGroup(long groupId) throws GroupNotFoundException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        try {
            SGroup sGroup = this.getSGroup(groupId, tenantAccessor);
            return ModelConvertor.toGroup(sGroup);
        }
        catch (SGroupNotFoundException sgnfe) {
            throw new GroupNotFoundException((Throwable)sgnfe);
        }
    }

    private SGroup getSGroup(long groupId, TenantServiceAccessor tenantAccessor) throws SGroupNotFoundException {
        IdentityService identityService = tenantAccessor.getIdentityService();
        try {
            GetSGroup getSGroup = new GetSGroup(groupId, identityService);
            getSGroup.execute();
            return getSGroup.getResult();
        }
        catch (SGroupNotFoundException sgnfe) {
            throw sgnfe;
        }
        catch (SBonitaException sbe) {
            throw new RetrieveException((Throwable)sbe);
        }
    }

    public Group getGroupByPath(String groupPath) throws GroupNotFoundException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        IdentityService identityService = tenantAccessor.getIdentityService();
        try {
            GetGroupByPath getGroup = new GetGroupByPath(groupPath, identityService);
            getGroup.execute();
            return ModelConvertor.toGroup(getGroup.getResult());
        }
        catch (SGroupNotFoundException sgnfe) {
            throw new GroupNotFoundException((Throwable)sgnfe);
        }
        catch (SBonitaException sbe) {
            throw new RetrieveException((Throwable)sbe);
        }
    }

    public long getNumberOfGroups() {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        IdentityService identityService = tenantAccessor.getIdentityService();
        try {
            GetNumberOfInstance getNumberOfInstance = new GetNumberOfInstance("getNumberOfGroups", identityService);
            getNumberOfInstance.execute();
            return getNumberOfInstance.getResult();
        }
        catch (SBonitaException sbe) {
            throw new RetrieveException((Throwable)sbe);
        }
    }

    public Map<Long, Group> getGroups(List<Long> groupIds) {
        HashMap<Long, Group> groups = new HashMap<Long, Group>();
        for (Long groupId : groupIds) {
            try {
                Group group = this.getGroup(groupId);
                groups.put(groupId, group);
            }
            catch (GroupNotFoundException e) {}
        }
        return groups;
    }

    public List<Group> getGroups(int startIndex, int maxResults, GroupCriterion pagingCriterion) {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        IdentityService identityService = tenantAccessor.getIdentityService();
        SGroupBuilderFactory sGroupFactory = BuilderFactory.get(SGroupBuilderFactory.class);
        String field = null;
        OrderByType order = null;
        switch (pagingCriterion) {
            case NAME_ASC: {
                field = sGroupFactory.getNameKey();
                order = OrderByType.ASC;
                break;
            }
            case LABEL_ASC: {
                field = sGroupFactory.getDisplayNameKey();
                order = OrderByType.ASC;
                break;
            }
            case NAME_DESC: {
                field = sGroupFactory.getNameKey();
                order = OrderByType.DESC;
                break;
            }
            case LABEL_DESC: {
                field = sGroupFactory.getDisplayNameKey();
                order = OrderByType.DESC;
            }
        }
        try {
            GetGroups getGroups = new GetGroups(identityService, startIndex, maxResults, order, field);
            getGroups.execute();
            return ModelConvertor.toGroups((List<SGroup>)getGroups.getResult());
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    public SearchResult<Group> searchGroups(SearchOptions options) throws SearchException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        IdentityService identityService = tenantAccessor.getIdentityService();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        SearchGroups searchGroups = new SearchGroups(identityService, searchEntitiesDescriptor.getSearchGroupDescriptor(), options);
        try {
            searchGroups.execute();
            return searchGroups.getResult();
        }
        catch (SBonitaException sbe) {
            throw new SearchException((Throwable)sbe);
        }
    }

    private User createUser(TenantServiceAccessor tenantAccessor, SUser sUser, SContactInfo sPersonalData, SContactInfo sProfessionalData) throws AlreadyExistsException, CreationException {
        try {
            this.getUserByUserName(sUser.getUserName());
            throw new AlreadyExistsException("A user with name \"" + sUser.getUserName() + "\" already exists");
        }
        catch (UserNotFoundException unfe) {
            try {
                CreateUser createUser = new CreateUser(sUser, sPersonalData, sProfessionalData, tenantAccessor.getIdentityService());
                createUser.execute();
                return ModelConvertor.toUser(createUser.getResult());
            }
            catch (SBonitaException sbe) {
                throw new CreationException((Throwable)sbe);
            }
        }
    }

    private void updateActorProcessDependencies(TenantServiceAccessor tenantAccessor, ActorMappingService actorMappingService, Set<Long> removedActorIds) throws SBonitaException {
        HashSet<Long> processDefinitionIds = new HashSet<Long>(removedActorIds.size());
        for (Long actorId : removedActorIds) {
            GetActor getActor = new GetActor(actorMappingService, actorId);
            getActor.execute();
            SActor actor = getActor.getResult();
            Long processDefId = actor.getScopeId();
            if (processDefinitionIds.contains(processDefId)) continue;
            processDefinitionIds.add(processDefId);
            tenantAccessor.getDependencyResolver().resolveDependencies(actor.getScopeId(), tenantAccessor);
        }
    }

    private void updateActorProcessDependenciesForAllActors(TenantServiceAccessor tenantAccessor) throws SBonitaException {
        List<Long> processDefinitionIds;
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        ActorProcessDependencyResolver dependencyResolver = new ActorProcessDependencyResolver();
        do {
            processDefinitionIds = processDefinitionService.getProcessDefinitionIds(0, 20L);
            for (Long processDefinitionId : processDefinitionIds) {
                tenantAccessor.getDependencyResolver().resolveDependencies(processDefinitionId, tenantAccessor, dependencyResolver);
            }
        } while (processDefinitionIds.size() == 20);
    }

    private List<User> getUsersWithOrder(int startIndex, int maxResults, UserCriterion pagingCriterion, TenantServiceAccessor tenantAccessor, IdentityService identityService) throws SIdentityException {
        String field = this.getUserFieldKey(pagingCriterion, tenantAccessor);
        OrderByType order = this.getUserOrderByType(pagingCriterion);
        if (field == null) {
            return ModelConvertor.toUsers(identityService.getUsers(startIndex, maxResults));
        }
        return ModelConvertor.toUsers(identityService.getUsers(startIndex, maxResults, field, order));
    }

    private OrderByType getUserOrderByType(UserCriterion pagingCriterion) {
        OrderByType order = null;
        switch (pagingCriterion) {
            case USER_NAME_ASC: {
                order = OrderByType.ASC;
                break;
            }
            case FIRST_NAME_ASC: {
                order = OrderByType.ASC;
                break;
            }
            case LAST_NAME_ASC: {
                order = OrderByType.ASC;
                break;
            }
            case FIRST_NAME_DESC: {
                order = OrderByType.DESC;
                break;
            }
            case LAST_NAME_DESC: {
                order = OrderByType.DESC;
                break;
            }
            case USER_NAME_DESC: {
                order = OrderByType.DESC;
            }
        }
        return order;
    }

    private String getUserFieldKey(UserCriterion pagingCriterion, TenantServiceAccessor tenantAccessor) {
        SUserBuilderFactory sUserFact = BuilderFactory.get(SUserBuilderFactory.class);
        String field = null;
        switch (pagingCriterion) {
            case USER_NAME_ASC: {
                field = sUserFact.getUserNameKey();
                break;
            }
            case FIRST_NAME_ASC: {
                field = sUserFact.getFirstNameKey();
                break;
            }
            case LAST_NAME_ASC: {
                field = sUserFact.getLastNameKey();
                break;
            }
            case FIRST_NAME_DESC: {
                field = sUserFact.getFirstNameKey();
                break;
            }
            case LAST_NAME_DESC: {
                field = sUserFact.getLastNameKey();
                break;
            }
            case USER_NAME_DESC: {
                field = sUserFact.getUserNameKey();
            }
        }
        return field;
    }

    public UserMembership addUserMembership(long userId, long groupId, long roleId) throws AlreadyExistsException, CreationException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        IdentityService identityService = tenantAccessor.getIdentityService();
        long assignedBy = SessionInfos.getUserIdFromSession();
        try {
            GetUserMembership getUserMembership = new GetUserMembership(userId, groupId, roleId, identityService);
            getUserMembership.execute();
            if (getUserMembership.getResult() != null) {
                throw new AlreadyExistsException("A userMembership with userId \"" + userId + "\", groupId \"" + groupId + "\" and roleId \"" + roleId + "\" already exists");
            }
        }
        catch (SBonitaException e) {
            // empty catch block
        }
        try {
            AddUserMembership createUserMembership = new AddUserMembership(userId, groupId, roleId, assignedBy, identityService);
            createUserMembership.execute();
            SUserMembership sUserMembership = createUserMembership.getResult();
            return ModelConvertor.toUserMembership(sUserMembership);
        }
        catch (SBonitaException sbe) {
            throw new CreationException((Throwable)sbe);
        }
    }

    public void addUserMemberships(List<Long> userIds, long groupId, long roleId) throws AlreadyExistsException, CreationException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        IdentityService identityService = tenantAccessor.getIdentityService();
        long currentUserId = SessionInfos.getUserIdFromSession();
        try {
            AddUserMemberships transactionContent = new AddUserMemberships(groupId, roleId, userIds, identityService, currentUserId);
            transactionContent.execute();
        }
        catch (SBonitaException sbe) {
            throw new CreationException((Throwable)sbe);
        }
    }

    public UserMembership updateUserMembership(long userMembershipId, long newGroupId, long newRoleId) throws UpdateException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        IdentityService identityService = tenantAccessor.getIdentityService();
        EntityUpdateDescriptor changeDescriptor = BuilderFactory.get(SUserMembershipUpdateBuilderFactory.class).createNewInstance().updateGroupId(newGroupId).updateRoleId(newRoleId).done();
        try {
            UpdateMembershipByRoleIdAndGroupId transactionContent = new UpdateMembershipByRoleIdAndGroupId(userMembershipId, identityService, changeDescriptor);
            transactionContent.execute();
            GetUserMembership getMembershipAfterUpdate = new GetUserMembership(userMembershipId, identityService);
            getMembershipAfterUpdate.execute();
            SUserMembership sMembershipAfterUpdate = getMembershipAfterUpdate.getResult();
            return ModelConvertor.toUserMembership(sMembershipAfterUpdate);
        }
        catch (SBonitaException sbe) {
            throw new UpdateException((Throwable)sbe);
        }
    }

    public void deleteUserMembership(long userMembershipId) throws DeletionException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        IdentityService identityService = tenantAccessor.getIdentityService();
        try {
            identityService.deleteUserMembership(userMembershipId);
        }
        catch (SIdentityException e) {
            throw new DeletionException((Throwable)e);
        }
    }

    public void deleteUserMembership(long userId, long groupId, long roleId) throws DeletionException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        IdentityService identityService = tenantAccessor.getIdentityService();
        try {
            identityService.deleteLightUserMembership(identityService.getLightUserMembership(userId, groupId, roleId));
        }
        catch (SIdentityException e) {
            throw new DeletionException((Throwable)e);
        }
    }

    public void deleteUserMemberships(List<Long> userIds, long groupId, long roleId) throws DeletionException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        IdentityService identityService = tenantAccessor.getIdentityService();
        try {
            for (long userId : userIds) {
                SUserMembership userMembership = identityService.getLightUserMembership(userId, groupId, roleId);
                identityService.deleteLightUserMembership(userMembership);
            }
        }
        catch (SIdentityException e) {
            throw new DeletionException((Throwable)e);
        }
    }

    public UserMembership getUserMembership(long userMembershipId) throws MembershipNotFoundException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        IdentityService identityService = tenantAccessor.getIdentityService();
        GetUserMembership getUserMembership = new GetUserMembership(userMembershipId, identityService);
        try {
            getUserMembership.execute();
            SUserMembership sMembership = getUserMembership.getResult();
            return ModelConvertor.toUserMembership(sMembership);
        }
        catch (SBonitaException sbe) {
            throw new MembershipNotFoundException((Throwable)sbe);
        }
    }

    public long getNumberOfUserMemberships(long userId) {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        IdentityService identityService = tenantAccessor.getIdentityService();
        try {
            GetNumberOfUserMemberships transactionContent = new GetNumberOfUserMemberships(userId, identityService);
            transactionContent.execute();
            return (Long)transactionContent.getResult();
        }
        catch (SBonitaException sbe) {
            throw new RetrieveException((Throwable)sbe);
        }
    }

    public List<UserMembership> getUserMemberships(long userId, int startIndex, int maxResults, UserMembershipCriterion pagingCrterion) {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        try {
            IdentityService identityService = tenantAccessor.getIdentityService();
            OrderByOption orderByOption = null;
            switch (pagingCrterion) {
                case ROLE_NAME_DESC: {
                    orderByOption = new OrderByOption(SRole.class, BuilderFactory.get(SRoleBuilderFactory.class).getNameKey(), OrderByType.DESC);
                    break;
                }
                case GROUP_NAME_ASC: {
                    orderByOption = new OrderByOption(SGroup.class, BuilderFactory.get(SGroupBuilderFactory.class).getNameKey(), OrderByType.ASC);
                    break;
                }
                case GROUP_NAME_DESC: {
                    orderByOption = new OrderByOption(SGroup.class, BuilderFactory.get(SGroupBuilderFactory.class).getNameKey(), OrderByType.DESC);
                    break;
                }
                case ASSIGNED_DATE_ASC: {
                    orderByOption = new OrderByOption(SUserMembership.class, BuilderFactory.get(SUserMembershipBuilderFactory.class).getAssignedDateKey(), OrderByType.ASC);
                    break;
                }
                case ASSIGNED_DATE_DESC: {
                    orderByOption = new OrderByOption(SUserMembership.class, BuilderFactory.get(SUserMembershipBuilderFactory.class).getAssignedDateKey(), OrderByType.DESC);
                    break;
                }
                default: {
                    orderByOption = new OrderByOption(SRole.class, BuilderFactory.get(SRoleBuilderFactory.class).getNameKey(), OrderByType.ASC);
                }
            }
            return this.getUserMemberships(userId, startIndex, maxResults, orderByOption, identityService);
        }
        catch (SBonitaException sbe) {
            throw new RetrieveException((Throwable)sbe);
        }
    }

    private List<UserMembership> getUserMemberships(long userId, int startIndex, int maxResults, OrderByOption orderByOption, IdentityService identityService) throws SBonitaException {
        return this.getUserMemberships(userId, startIndex, maxResults, null, null, orderByOption, identityService);
    }

    private List<UserMembership> getUserMemberships(long userId, int startIndex, int maxResults, OrderByType orderExecutor, String fieldExecutor, OrderByOption orderByOption, IdentityService identityService) throws SBonitaException {
        List<SUserMembership> sUserMemberships = userId == -1L ? identityService.getUserMemberships(startIndex, maxResults) : (orderByOption != null ? identityService.getUserMembershipsOfUser(userId, startIndex, maxResults, orderByOption) : (fieldExecutor == null ? identityService.getUserMembershipsOfUser(userId, startIndex, maxResults) : identityService.getUserMembershipsOfUser(userId, startIndex, maxResults, fieldExecutor, orderExecutor)));
        return ModelConvertor.toUserMembership(sUserMemberships);
    }

    public List<UserMembership> getUserMembershipsByGroup(long groupId, int startIndex, int maxResults) {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        IdentityService identityService = tenantAccessor.getIdentityService();
        GetUserMembershipsOfGroup transactionContentWithResult = new GetUserMembershipsOfGroup(groupId, identityService, startIndex, maxResults);
        try {
            transactionContentWithResult.execute();
            return ModelConvertor.toUserMembership((List<SUserMembership>)transactionContentWithResult.getResult());
        }
        catch (SBonitaException sbe) {
            throw new RetrieveException((Throwable)sbe);
        }
    }

    public List<UserMembership> getUserMembershipsByRole(long roleId, int startIndex, int maxResults) {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        IdentityService identityService = tenantAccessor.getIdentityService();
        try {
            GetUserMembershipsOfRole transactionContentWithResult = new GetUserMembershipsOfRole(roleId, identityService, startIndex, maxResults);
            transactionContentWithResult.execute();
            return ModelConvertor.toUserMembership((List<SUserMembership>)transactionContentWithResult.getResult());
        }
        catch (SBonitaException sbe) {
            throw new RetrieveException((Throwable)sbe);
        }
    }

    public void deleteOrganization() throws DeletionException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        IdentityService identityService = tenantAccessor.getIdentityService();
        ActorMappingService actorMappingService = tenantAccessor.getActorMappingService();
        ProfileService profileService = tenantAccessor.getProfileService();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        SupervisorMappingService supervisorService = tenantAccessor.getSupervisorService();
        ExternalIdentityMappingService externalIdentityMappingService = tenantAccessor.getExternalIdentityMappingService();
        ProcessInstanceService processInstanceService = tenantAccessor.getProcessInstanceService();
        QueryOptions queryOptions = new QueryOptions(0, 1);
        try {
            if (processInstanceService.getNumberOfProcessInstances(queryOptions) != 0L || activityInstanceService.getNumberOfHumanTasks(queryOptions) != 0L) {
                throw new DeletionException("Can't delete a organization when a process, a human tasks, or a comment is active !!.");
            }
            actorMappingService.deleteAllActorMembers();
            profileService.deleteAllProfileMembers();
            activityInstanceService.deleteAllPendingMappings();
            activityInstanceService.deleteAllHiddenTasks();
            supervisorService.deleteAllSupervisors();
            externalIdentityMappingService.deleteAllExternalIdentityMappings();
            identityService.deleteAllUserMemberships();
            identityService.deleteAllGroups();
            identityService.deleteAllRoles();
            identityService.deleteAllUsers();
            this.updateActorProcessDependenciesForAllActors(tenantAccessor);
        }
        catch (SBonitaException e) {
            throw new DeletionException((Throwable)e);
        }
    }

    public void importOrganization(String organizationContent) throws OrganizationImportException {
        this.importOrganization(organizationContent, ImportPolicy.MERGE_DUPLICATES);
    }

    public void importOrganization(String organizationContent, ImportPolicy policy) throws OrganizationImportException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        try {
            new ImportOrganization(tenantAccessor, organizationContent, policy).execute();
        }
        catch (SBonitaException e) {
            throw new OrganizationImportException((Throwable)e);
        }
    }

    public String exportOrganization() throws OrganizationExportException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        ExportOrganization exportOrganization = new ExportOrganization(tenantAccessor.getXMLWriter(), tenantAccessor.getIdentityService());
        try {
            exportOrganization.execute();
            return exportOrganization.getResult();
        }
        catch (SBonitaException e) {
            throw new OrganizationExportException((Throwable)e);
        }
    }
}

