/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.api.PlatformCommandAPI;
import org.bonitasoft.engine.api.impl.transaction.dependency.DeleteSDependency;
import org.bonitasoft.engine.api.impl.transaction.platform.AddSPlatformCommandDependency;
import org.bonitasoft.engine.api.impl.transaction.platform.CreateSPlatformCommand;
import org.bonitasoft.engine.api.impl.transaction.platform.DeleteSPlatformCommand;
import org.bonitasoft.engine.api.impl.transaction.platform.GetPlatformCommand;
import org.bonitasoft.engine.api.impl.transaction.platform.GetSPlatformCommand;
import org.bonitasoft.engine.api.impl.transaction.platform.GetSPlatformCommands;
import org.bonitasoft.engine.api.impl.transaction.platform.UpdateSPlatformCommand;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.classloader.ClassLoaderService;
import org.bonitasoft.engine.command.CommandCriterion;
import org.bonitasoft.engine.command.CommandDescriptor;
import org.bonitasoft.engine.command.CommandExecutionException;
import org.bonitasoft.engine.command.CommandNotFoundException;
import org.bonitasoft.engine.command.CommandParameterizationException;
import org.bonitasoft.engine.command.CommandUpdater;
import org.bonitasoft.engine.command.DependencyNotFoundException;
import org.bonitasoft.engine.command.PlatformCommand;
import org.bonitasoft.engine.command.SCommandExecutionException;
import org.bonitasoft.engine.command.SCommandNotFoundException;
import org.bonitasoft.engine.command.SCommandParameterizationException;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.dependency.DependencyService;
import org.bonitasoft.engine.dependency.SDependencyNotFoundException;
import org.bonitasoft.engine.exception.AlreadyExistsException;
import org.bonitasoft.engine.exception.CreationException;
import org.bonitasoft.engine.exception.DeletionException;
import org.bonitasoft.engine.exception.RetrieveException;
import org.bonitasoft.engine.exception.UpdateException;
import org.bonitasoft.engine.platform.command.PlatformCommandService;
import org.bonitasoft.engine.platform.command.SPlatformCommandNotFoundException;
import org.bonitasoft.engine.platform.command.model.SPlatformCommand;
import org.bonitasoft.engine.platform.command.model.SPlatformCommandBuilderFactory;
import org.bonitasoft.engine.service.ModelConvertor;
import org.bonitasoft.engine.service.PlatformServiceAccessor;
import org.bonitasoft.engine.service.impl.ServiceAccessorFactory;

public class PlatformCommandAPIImpl
implements PlatformCommandAPI {
    private static PlatformServiceAccessor getPlatformServiceAccessor() throws RetrieveException {
        try {
            return ServiceAccessorFactory.getInstance().createPlatformServiceAccessor();
        }
        catch (Exception e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    public void addDependency(String name, byte[] jar) throws AlreadyExistsException, CreationException {
        PlatformServiceAccessor platformAccessor = PlatformCommandAPIImpl.getPlatformServiceAccessor();
        DependencyService dependencyService = platformAccessor.getDependencyService();
        ClassLoaderService classLoaderService = platformAccessor.getClassLoaderService();
        long artifactId = classLoaderService.getGlobalClassLoaderId();
        String artifactType = classLoaderService.getGlobalClassLoaderType();
        AddSPlatformCommandDependency addSDependency = new AddSPlatformCommandDependency(dependencyService, name, jar, artifactId, artifactType);
        try {
            addSDependency.execute();
        }
        catch (SBonitaException sbe) {
            throw new CreationException((Throwable)sbe);
        }
    }

    public void removeDependency(String name) throws DependencyNotFoundException, DeletionException {
        PlatformServiceAccessor platformAccessor = PlatformCommandAPIImpl.getPlatformServiceAccessor();
        DependencyService dependencyService = platformAccessor.getDependencyService();
        DeleteSDependency deleteSDependency = new DeleteSDependency(dependencyService, name);
        try {
            deleteSDependency.execute();
        }
        catch (SDependencyNotFoundException sdnfe) {
            throw new DependencyNotFoundException((Throwable)sdnfe);
        }
        catch (SBonitaException sbe) {
            throw new DeletionException((Throwable)sbe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandDescriptor register(String name, String description, String implementation) throws AlreadyExistsException, CreationException {
        CommandDescriptor existingCommandDescriptor = null;
        try {
            existingCommandDescriptor = this.get(name);
        }
        catch (CommandNotFoundException unfe) {
            if (existingCommandDescriptor != null) {
                throw new AlreadyExistsException("A command with name \"" + name + "\" already exists");
            }
        }
        finally {
            if (existingCommandDescriptor != null) {
                throw new AlreadyExistsException("A command with name \"" + name + "\" already exists");
            }
        }
        PlatformServiceAccessor platformAccessor = PlatformCommandAPIImpl.getPlatformServiceAccessor();
        PlatformCommandService platformCommandService = platformAccessor.getPlatformCommandService();
        SPlatformCommand sPlatformCommand = BuilderFactory.get(SPlatformCommandBuilderFactory.class).createNewInstance(name, description, implementation).done();
        try {
            CreateSPlatformCommand createPlatformCommand = new CreateSPlatformCommand(platformCommandService, sPlatformCommand);
            createPlatformCommand.execute();
            return ModelConvertor.toCommandDescriptor(sPlatformCommand);
        }
        catch (SBonitaException sbe) {
            throw new CreationException((Throwable)sbe);
        }
    }

    public Serializable execute(String platformCommandName, Map<String, Serializable> parameters) throws CommandNotFoundException, CommandParameterizationException, CommandExecutionException {
        PlatformServiceAccessor platformAccessor = PlatformCommandAPIImpl.getPlatformServiceAccessor();
        PlatformCommandService platformCommandService = platformAccessor.getPlatformCommandService();
        try {
            GetSPlatformCommand getPlatformCmdTx = new GetSPlatformCommand(platformCommandService, platformCommandName);
            getPlatformCmdTx.execute();
            SPlatformCommand sPlatformCommand = getPlatformCmdTx.getResult();
            GetPlatformCommand getPlatformCommand = new GetPlatformCommand(sPlatformCommand.getImplementation());
            getPlatformCommand.execute();
            PlatformCommand command = getPlatformCommand.getResult();
            return command.execute(parameters, platformAccessor);
        }
        catch (SPlatformCommandNotFoundException scnfe) {
            throw new CommandNotFoundException((Throwable)scnfe);
        }
        catch (SCommandParameterizationException scpe) {
            throw new CommandParameterizationException((Throwable)scpe);
        }
        catch (SCommandExecutionException scee) {
            throw new CommandExecutionException((Throwable)scee);
        }
        catch (SBonitaException sbe) {
            throw new CommandExecutionException((Throwable)sbe);
        }
    }

    public void unregister(String platformCommandName) throws CommandNotFoundException, DeletionException {
        if (platformCommandName == null) {
            throw new DeletionException("Command name can not be null!");
        }
        try {
            PlatformServiceAccessor platformAccessor = PlatformCommandAPIImpl.getPlatformServiceAccessor();
            PlatformCommandService platformCommandService = platformAccessor.getPlatformCommandService();
            DeleteSPlatformCommand deletePlatformCommand = new DeleteSPlatformCommand(platformCommandService, platformCommandName);
            deletePlatformCommand.execute();
        }
        catch (SCommandNotFoundException scnfe) {
            throw new CommandNotFoundException((Throwable)scnfe);
        }
        catch (SBonitaException sbe) {
            throw new DeletionException((Throwable)sbe);
        }
    }

    public CommandDescriptor get(String platformCommandName) throws CommandNotFoundException {
        PlatformServiceAccessor platformAccessor = PlatformCommandAPIImpl.getPlatformServiceAccessor();
        PlatformCommandService platformCommandService = platformAccessor.getPlatformCommandService();
        try {
            GetSPlatformCommand getPlatformComandByName = new GetSPlatformCommand(platformCommandService, platformCommandName);
            getPlatformComandByName.execute();
            SPlatformCommand sPlatformCommand = getPlatformComandByName.getResult();
            return ModelConvertor.toCommandDescriptor(sPlatformCommand);
        }
        catch (SBonitaException e) {
            throw new CommandNotFoundException((Throwable)e);
        }
    }

    public List<CommandDescriptor> getCommands(int startIndex, int maxResults, CommandCriterion sort) {
        PlatformServiceAccessor platformAccessor = PlatformCommandAPIImpl.getPlatformServiceAccessor();
        PlatformCommandService platformCommandService = platformAccessor.getPlatformCommandService();
        try {
            GetSPlatformCommands getPlatformCommands = new GetSPlatformCommands(platformCommandService, startIndex, maxResults, sort);
            getPlatformCommands.execute();
            return ModelConvertor.toPlatformCommandDescriptors((List<SPlatformCommand>)getPlatformCommands.getResult());
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    public void update(String platformCommandName, CommandUpdater updater) throws UpdateException {
        if (updater == null || updater.getFields().isEmpty()) {
            throw new UpdateException("The update descriptor does not contain field updates");
        }
        PlatformServiceAccessor platformAccessor = PlatformCommandAPIImpl.getPlatformServiceAccessor();
        PlatformCommandService platformCommandService = platformAccessor.getPlatformCommandService();
        try {
            UpdateSPlatformCommand updatePlatformCommand = new UpdateSPlatformCommand(platformCommandService, platformCommandName, updater);
            updatePlatformCommand.execute();
        }
        catch (SCommandNotFoundException scnfe) {
            throw new UpdateException((Throwable)scnfe);
        }
        catch (SBonitaException e) {
            throw new UpdateException((Throwable)e);
        }
    }
}

