/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl.resolver;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.bonitasoft.engine.api.ProcessAPI;
import org.bonitasoft.engine.api.impl.resolver.ProcessDependencyResolver;
import org.bonitasoft.engine.api.impl.transaction.dependency.AddSDependency;
import org.bonitasoft.engine.bpm.bar.BusinessArchive;
import org.bonitasoft.engine.bpm.process.ConfigurationState;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.process.definition.ProcessDefinitionService;
import org.bonitasoft.engine.core.process.definition.model.SProcessDefinition;
import org.bonitasoft.engine.core.process.definition.model.SProcessDefinitionDeployInfo;
import org.bonitasoft.engine.core.process.definition.model.builder.SProcessDefinitionDeployInfoUpdateBuilderFactory;
import org.bonitasoft.engine.dependency.DependencyService;
import org.bonitasoft.engine.dependency.SDependencyCreationException;
import org.bonitasoft.engine.dependency.SDependencyException;
import org.bonitasoft.engine.dependency.model.SDependency;
import org.bonitasoft.engine.exception.BonitaException;
import org.bonitasoft.engine.exception.BonitaHomeNotSetException;
import org.bonitasoft.engine.exception.BonitaRuntimeException;
import org.bonitasoft.engine.home.BonitaHomeServer;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.recorder.model.EntityUpdateDescriptor;
import org.bonitasoft.engine.service.TenantServiceAccessor;

public class DependencyResolver {
    private final List<ProcessDependencyResolver> dependencyResolvers;

    public DependencyResolver(List<ProcessDependencyResolver> dependencyResolvers) {
        this.dependencyResolvers = dependencyResolvers;
    }

    public boolean resolveDependencies(ProcessAPI processAPI, BusinessArchive businessArchive, TenantServiceAccessor tenantAccessor, SProcessDefinition sDefinition) {
        List<ProcessDependencyResolver> resolvers = this.getResolvers();
        boolean resolved = true;
        for (ProcessDependencyResolver resolver : resolvers) {
            try {
                resolved &= resolver.resolve(processAPI, tenantAccessor, businessArchive, sDefinition);
            }
            catch (BonitaException e) {
                resolved = false;
            }
        }
        return resolved;
    }

    public void resolveDependencies(long processDefinitionId, TenantServiceAccessor tenantAccessor) {
        List<ProcessDependencyResolver> resolvers = this.getResolvers();
        this.resolveDependencies(processDefinitionId, tenantAccessor, resolvers.toArray(new ProcessDependencyResolver[resolvers.size()]));
    }

    public void resolveDependencies(long processDefinitionId, TenantServiceAccessor tenantAccessor, ProcessDependencyResolver ... resolvers) {
        TechnicalLoggerService loggerService = tenantAccessor.getTechnicalLoggerService();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        DependencyService dependencyService = tenantAccessor.getDependencyService();
        try {
            boolean resolved = true;
            for (ProcessDependencyResolver dependencyResolver : resolvers) {
                SProcessDefinition processDefinition = processDefinitionService.getProcessDefinition(processDefinitionId);
                resolved &= dependencyResolver.checkResolution(tenantAccessor, processDefinition).isEmpty();
            }
            this.changeResolutionStatus(processDefinitionId, tenantAccessor, processDefinitionService, dependencyService, resolved);
        }
        catch (SBonitaException e) {
            Class<DependencyResolver> clazz = DependencyResolver.class;
            if (loggerService.isLoggable(clazz, TechnicalLogSeverity.DEBUG)) {
                loggerService.log(clazz, TechnicalLogSeverity.DEBUG, e);
            }
            if (loggerService.isLoggable(clazz, TechnicalLogSeverity.WARNING)) {
                loggerService.log(clazz, TechnicalLogSeverity.WARNING, "Unable to resolve dependencies after they were modified because of " + e.getMessage() + ". Please retry it manually");
            }
        }
        catch (BonitaHomeNotSetException e) {
            throw new BonitaRuntimeException("Bonita home not set", (Throwable)e);
        }
    }

    private void changeResolutionStatus(long processDefinitionId, TenantServiceAccessor tenantAccessor, ProcessDefinitionService processDefinitionService, DependencyService dependencyService, boolean resolved) throws SBonitaException, BonitaHomeNotSetException {
        SProcessDefinitionDeployInfo processDefinitionDeployInfo = processDefinitionService.getProcessDeploymentInfo(processDefinitionId);
        if (resolved) {
            if (ConfigurationState.UNRESOLVED.name().equals(processDefinitionDeployInfo.getConfigurationState())) {
                this.resolveAndCreateDependencies(new File(new File(BonitaHomeServer.getInstance().getProcessesFolder(tenantAccessor.getTenantId())), String.valueOf(processDefinitionId)), processDefinitionService, dependencyService, processDefinitionId);
            }
        } else if (ConfigurationState.RESOLVED.name().equals(processDefinitionDeployInfo.getConfigurationState())) {
            EntityUpdateDescriptor updateDescriptor = BuilderFactory.get(SProcessDefinitionDeployInfoUpdateBuilderFactory.class).createNewInstance().updateConfigurationState(ConfigurationState.UNRESOLVED).done();
            processDefinitionService.updateProcessDefinitionDeployInfo(processDefinitionId, updateDescriptor);
        }
    }

    public void resolveAndCreateDependencies(File processFolder, ProcessDefinitionService processDefinitionService, DependencyService dependencyService, long processDefinitionId) throws SBonitaException {
        HashMap<String, byte[]> resources = new HashMap<String, byte[]>();
        File file = new File(processFolder, "classpath");
        if (file.exists() && file.isDirectory()) {
            File[] listFiles;
            for (File jarFile : listFiles = file.listFiles()) {
                String name = jarFile.getName();
                try {
                    byte[] jarContent = FileUtils.readFileToByteArray((File)jarFile);
                    resources.put(this.getDependencyName(processDefinitionId, name), jarContent);
                }
                catch (IOException e) {
                    throw new SDependencyCreationException(e);
                }
            }
        }
        this.addDependencies(resources, dependencyService, processDefinitionId);
        processDefinitionService.resolveProcess(processDefinitionId);
    }

    private String getDependencyName(long processDefinitionId, String name) {
        return processDefinitionId + "_" + name;
    }

    private void addDependencies(Map<String, byte[]> resources, DependencyService dependencyService, long processDefinitionId) throws SBonitaException {
        List<Long> dependencyIds = this.getDependencyMappingsOfProcess(dependencyService, processDefinitionId);
        List<String> dependencies = this.getDependenciesOfProcess(dependencyService, dependencyIds);
        for (Map.Entry<String, byte[]> entry : resources.entrySet()) {
            if (dependencies.contains(entry.getKey())) continue;
            this.addDependency(entry.getKey(), entry.getValue(), dependencyService, processDefinitionId);
        }
    }

    private List<String> getDependenciesOfProcess(DependencyService dependencyService, List<Long> dependencyIds) throws SBonitaException {
        if (dependencyIds.isEmpty()) {
            return Collections.emptyList();
        }
        List<SDependency> dependencies = dependencyService.getDependencies(dependencyIds);
        ArrayList<String> dependencyNames = new ArrayList<String>(dependencies.size());
        for (SDependency sDependency : dependencies) {
            dependencyNames.add(sDependency.getName());
        }
        return dependencyNames;
    }

    private List<Long> getDependencyMappingsOfProcess(DependencyService dependencyService, long processDefinitionId) throws SDependencyException {
        List<Long> currentPage;
        ArrayList<Long> dependencyIds = new ArrayList<Long>();
        QueryOptions queryOptions = QueryOptions.defaultQueryOptions();
        do {
            currentPage = dependencyService.getDependencyIds(processDefinitionId, "process", queryOptions);
            dependencyIds.addAll(currentPage);
            queryOptions = QueryOptions.getNextPage(queryOptions);
        } while (currentPage.size() == 20);
        return dependencyIds;
    }

    public void resolveAndCreateDependencies(BusinessArchive businessArchive, ProcessDefinitionService processDefinitionService, DependencyService dependencyService, SProcessDefinition sDefinition) throws SBonitaException {
        Long processDefinitionId = sDefinition.getId();
        if (businessArchive != null) {
            Map resources = businessArchive.getResources("^classpath/.*$");
            HashMap<String, byte[]> resourcesWithRealName = new HashMap<String, byte[]>(resources.size());
            for (Map.Entry resource : resources.entrySet()) {
                String name = ((String)resource.getKey()).substring(10);
                byte[] jarContent = (byte[])resource.getValue();
                resourcesWithRealName.put(this.getDependencyName(processDefinitionId, name), jarContent);
            }
            this.addDependencies(resourcesWithRealName, dependencyService, sDefinition.getId());
        }
        processDefinitionService.resolveProcess(processDefinitionId);
    }

    private void addDependency(String name, byte[] jarContent, DependencyService dependencyService, long processdefinitionId) throws SDependencyException {
        AddSDependency addSDependency = new AddSDependency(dependencyService, name, jarContent, processdefinitionId, "process");
        addSDependency.execute();
    }

    public List<ProcessDependencyResolver> getResolvers() {
        return this.dependencyResolvers;
    }
}

