/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl.transaction.actor;

import org.bonitasoft.engine.actor.mapping.ActorMappingService;
import org.bonitasoft.engine.actor.mapping.model.SActorMember;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.transaction.TransactionContent;
import org.bonitasoft.engine.identity.MemberType;

public class AddActorMember
implements TransactionContent {
    private final ActorMappingService actorMappingService;
    private final long actorId;
    private final long userId;
    private final long groupId;
    private final long roleId;
    private SActorMember actorMember;
    private final MemberType memberType;

    public AddActorMember(ActorMappingService actorMappingService, long actorId, long userId, long groupId, long roleId, MemberType memberType) {
        this.actorMappingService = actorMappingService;
        this.actorId = actorId;
        this.userId = userId;
        this.groupId = groupId;
        this.roleId = roleId;
        this.memberType = memberType;
    }

    @Override
    public void execute() throws SBonitaException {
        switch (this.memberType) {
            case USER: {
                this.actorMember = this.actorMappingService.addUserToActor(this.actorId, this.userId);
                break;
            }
            case GROUP: {
                this.actorMember = this.actorMappingService.addGroupToActor(this.actorId, this.groupId);
                break;
            }
            case ROLE: {
                this.actorMember = this.actorMappingService.addRoleToActor(this.actorId, this.roleId);
                break;
            }
            case MEMBERSHIP: {
                this.actorMember = this.actorMappingService.addRoleAndGroupToActor(this.actorId, this.roleId, this.groupId);
            }
        }
    }

    public SActorMember getActorMember() {
        return this.actorMember;
    }
}

