/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl.transaction.actor;

import java.util.List;
import org.bonitasoft.engine.actor.mapping.ActorMappingService;
import org.bonitasoft.engine.actor.mapping.model.SActor;
import org.bonitasoft.engine.actor.mapping.model.SActorMember;
import org.bonitasoft.engine.actor.xml.Actor;
import org.bonitasoft.engine.actor.xml.ActorMapping;
import org.bonitasoft.engine.actor.xml.ActorMappingNodeBuilder;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.transaction.TransactionContentWithResult;
import org.bonitasoft.engine.identity.IdentityService;
import org.bonitasoft.engine.identity.model.SGroup;
import org.bonitasoft.engine.identity.model.SRole;
import org.bonitasoft.engine.identity.model.SUser;
import org.bonitasoft.engine.xml.XMLNode;
import org.bonitasoft.engine.xml.XMLWriter;

public class ExportActorMapping
implements TransactionContentWithResult<String> {
    private final ActorMappingService actorMappingService;
    private final IdentityService identityService;
    private final XMLWriter writer;
    private final long processDefinitionId;
    private String xmlContent;

    public ExportActorMapping(ActorMappingService actorMappingService, IdentityService identityService, XMLWriter writer, long processDefinitionId) {
        this.actorMappingService = actorMappingService;
        this.identityService = identityService;
        this.writer = writer;
        this.processDefinitionId = processDefinitionId;
    }

    @Override
    public void execute() throws SBonitaException {
        ActorMapping mapping = this.getActorMapping();
        XMLNode node = this.getNode(mapping);
        byte[] bytes = this.writer.write(node);
        this.xmlContent = new String(bytes);
    }

    private ActorMapping getActorMapping() throws SBonitaException {
        ActorMapping actorMapping = new ActorMapping();
        List<SActor> actors = this.actorMappingService.getActors(this.processDefinitionId);
        for (SActor sActor : actors) {
            Actor actor = new Actor(sActor.getName());
            List<SActorMember> actorMembers = this.actorMappingService.getActorMembers(sActor.getId(), 0, Integer.MAX_VALUE);
            for (SActorMember sActorMember : actorMembers) {
                SRole role;
                if (sActorMember.getUserId() > 0L) {
                    SUser user = this.identityService.getUser(sActorMember.getUserId());
                    actor.addUser(user.getUserName());
                }
                if (sActorMember.getGroupId() > 0L && sActorMember.getRoleId() <= 0L) {
                    SGroup group = this.identityService.getGroup(sActorMember.getGroupId());
                    actor.addGroup(group.getPath());
                }
                if (sActorMember.getRoleId() > 0L && sActorMember.getGroupId() <= 0L) {
                    role = this.identityService.getRole(sActorMember.getRoleId());
                    actor.addRole(role.getName());
                }
                if (sActorMember.getRoleId() <= 0L || sActorMember.getGroupId() <= 0L) continue;
                role = this.identityService.getRole(sActorMember.getRoleId());
                SGroup group = this.identityService.getGroup(sActorMember.getGroupId());
                actor.addMembership(group.getPath(), role.getName());
            }
            actorMapping.addActor(actor);
        }
        return actorMapping;
    }

    private XMLNode getNode(ActorMapping mapping) {
        return ActorMappingNodeBuilder.getDocument(mapping);
    }

    @Override
    public String getResult() {
        return this.xmlContent;
    }
}

