/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl.transaction.category;

import org.bonitasoft.engine.commons.transaction.TransactionContentWithResult;
import org.bonitasoft.engine.core.category.CategoryService;
import org.bonitasoft.engine.core.category.exception.SCategoryAlreadyExistsException;
import org.bonitasoft.engine.core.category.exception.SCategoryCreationException;
import org.bonitasoft.engine.core.category.model.SCategory;

public class CreateCategory
implements TransactionContentWithResult<SCategory> {
    private final CategoryService categoryService;
    private final String name;
    private final String description;
    private SCategory sCategory;

    public CreateCategory(String name, String description, CategoryService categoryService) {
        this.name = name;
        this.description = description;
        this.categoryService = categoryService;
    }

    @Override
    public void execute() throws SCategoryAlreadyExistsException, SCategoryCreationException {
        this.sCategory = this.categoryService.createCategory(this.name, this.description);
    }

    @Override
    public SCategory getResult() {
        return this.sCategory;
    }
}

