/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl.transaction.command;

import java.util.Map;
import org.bonitasoft.engine.command.CommandService;
import org.bonitasoft.engine.command.CommandUpdater;
import org.bonitasoft.engine.command.model.SCommand;
import org.bonitasoft.engine.command.model.SCommandUpdateBuilder;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.transaction.TransactionContent;
import org.bonitasoft.engine.recorder.model.EntityUpdateDescriptor;

public class UpdateSCommand
implements TransactionContent {
    private final CommandService commandService;
    private final SCommandUpdateBuilder commandUpdateBuilder;
    private final String name;
    private final CommandUpdater updateDescriptor;
    private long commandId = -1L;

    public UpdateSCommand(CommandService commandService, SCommandUpdateBuilder commandUpdateBuilder, String name, CommandUpdater updateDescriptor) {
        this.commandService = commandService;
        this.commandUpdateBuilder = commandUpdateBuilder;
        this.name = name;
        this.updateDescriptor = updateDescriptor;
    }

    public UpdateSCommand(CommandService commandService, SCommandUpdateBuilder commandUpdateBuilder, long commandId, CommandUpdater updateDescriptor) {
        this.commandService = commandService;
        this.commandUpdateBuilder = commandUpdateBuilder;
        this.commandId = commandId;
        this.updateDescriptor = updateDescriptor;
        this.name = null;
    }

    @Override
    public void execute() throws SBonitaException {
        EntityUpdateDescriptor changeDescriptor = this.getCommandUpdateDescriptor();
        SCommand sCommand = null;
        sCommand = this.commandId != -1L ? this.commandService.get(this.commandId) : this.commandService.get(this.name);
        this.commandService.update(sCommand, changeDescriptor);
    }

    private EntityUpdateDescriptor getCommandUpdateDescriptor() {
        Map fields = this.updateDescriptor.getFields();
        for (Map.Entry field : fields.entrySet()) {
            switch ((CommandUpdater.CommandField)field.getKey()) {
                case NAME: {
                    this.commandUpdateBuilder.updateName((String)field.getValue());
                    break;
                }
                case DESCRIPTION: {
                    this.commandUpdateBuilder.updateDescription((String)field.getValue());
                }
            }
        }
        return this.commandUpdateBuilder.done();
    }
}

