/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl.transaction.dependency;

import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.commons.transaction.TransactionContent;
import org.bonitasoft.engine.dependency.DependencyService;
import org.bonitasoft.engine.dependency.SDependencyException;
import org.bonitasoft.engine.dependency.model.SDependency;
import org.bonitasoft.engine.dependency.model.SDependencyMapping;
import org.bonitasoft.engine.dependency.model.builder.SDependencyBuilderFactory;
import org.bonitasoft.engine.dependency.model.builder.SDependencyMappingBuilderFactory;

public class AddSDependency
implements TransactionContent {
    private final DependencyService dependencyService;
    private final String name;
    private final byte[] jar;
    private final long artifactId;
    private final String artifactType;

    public AddSDependency(DependencyService dependencyService, String name, byte[] jar, long artifactId, String artifactType) {
        this.dependencyService = dependencyService;
        this.name = name;
        this.jar = jar;
        this.artifactId = artifactId;
        this.artifactType = artifactType;
    }

    @Override
    public void execute() throws SDependencyException {
        SDependency sDependency = BuilderFactory.get(SDependencyBuilderFactory.class).createNewInstance(this.name, "1.0", this.name + ".jar", this.jar).done();
        this.dependencyService.createDependency(sDependency);
        SDependencyMapping sDependencyMapping = BuilderFactory.get(SDependencyMappingBuilderFactory.class).createNewInstance(sDependency.getId(), this.artifactId, this.artifactType).done();
        this.dependencyService.createDependencyMapping(sDependencyMapping);
    }
}

