/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl.transaction.flownode;

import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.transaction.TransactionContent;
import org.bonitasoft.engine.core.process.instance.api.ActivityInstanceService;
import org.bonitasoft.engine.core.process.instance.api.exceptions.STaskVisibilityException;

public class HideTasks
implements TransactionContent {
    private final ActivityInstanceService activityInstanceService;
    private final long userId;
    private final Long[] activityInstanceIds;

    public HideTasks(ActivityInstanceService activityInstanceService, long userId, Long ... activityInstanceIds) {
        this.activityInstanceService = activityInstanceService;
        this.userId = userId;
        this.activityInstanceIds = activityInstanceIds;
    }

    @Override
    public void execute() throws SBonitaException {
        boolean found = false;
        long foundActivityInstanceId = 0L;
        for (int i = 0; i < this.activityInstanceIds.length && !found; ++i) {
            long activityInstanceId = this.activityInstanceIds[i];
            try {
                this.activityInstanceService.getHiddenTask(this.userId, activityInstanceId);
                found = true;
                foundActivityInstanceId = activityInstanceId;
                continue;
            }
            catch (STaskVisibilityException vis) {
                // empty catch block
            }
        }
        if (found) {
            throw new STaskVisibilityException("Task with id " + foundActivityInstanceId + " is already hidden");
        }
        this.activityInstanceService.hideTasks(this.userId, this.activityInstanceIds);
    }
}

