/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl.transaction.identity;

import java.util.List;
import org.bonitasoft.engine.actor.mapping.ActorMappingService;
import org.bonitasoft.engine.actor.mapping.SActorMemberDeletionException;
import org.bonitasoft.engine.actor.mapping.SActorMemberNotFoundException;
import org.bonitasoft.engine.actor.mapping.model.SActorMember;
import org.bonitasoft.engine.api.impl.transaction.identity.DeleteWithActorMembers;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.transaction.TransactionContent;
import org.bonitasoft.engine.identity.IdentityService;
import org.bonitasoft.engine.identity.model.SUserMembership;
import org.bonitasoft.engine.persistence.OrderByType;
import org.bonitasoft.engine.persistence.SBonitaReadException;
import org.bonitasoft.engine.profile.ProfileService;
import org.bonitasoft.engine.profile.builder.SProfileMemberBuilderFactory;
import org.bonitasoft.engine.profile.model.SProfileMember;

public class DeleteRole
extends DeleteWithActorMembers
implements TransactionContent {
    private final IdentityService identityService;
    private final ActorMappingService actorMappingService;
    private final ProfileService profileService;
    private final long roleId;

    public DeleteRole(IdentityService identityService, ActorMappingService actorMappingService, ProfileService profileService, long roleId) {
        this.identityService = identityService;
        this.actorMappingService = actorMappingService;
        this.roleId = roleId;
        this.profileService = profileService;
    }

    @Override
    public void execute() throws SBonitaException {
        this.deleteMembershipsByRole(this.roleId);
        this.deleteActorMembers();
        this.deleteProfileMembers();
        this.identityService.deleteRole(this.roleId);
    }

    private void deleteActorMembers() throws SActorMemberNotFoundException, SActorMemberDeletionException, SBonitaReadException {
        List<SActorMember> actorMembers = this.actorMappingService.getActorMembersOfRole(this.roleId);
        for (SActorMember sActorMember : actorMembers) {
            this.setActorIdsOfRemovedElements(this.actorMappingService.removeActorMember(sActorMember.getId()));
        }
    }

    private void deleteProfileMembers() throws SBonitaException {
        List<SProfileMember> profileMembers;
        String field = BuilderFactory.get(SProfileMemberBuilderFactory.class).getIdKey();
        do {
            profileMembers = this.profileService.getProfileMembersOfRole(this.roleId, 0, 20, field, OrderByType.ASC);
            for (SProfileMember sProfileMember : profileMembers) {
                this.profileService.deleteProfileMember(sProfileMember);
            }
        } while (profileMembers.size() == 20);
    }

    private void deleteMembershipsByRole(long roleId) throws SBonitaException {
        List<SUserMembership> memberships;
        int i = 0;
        do {
            memberships = this.identityService.getUserMembershipsOfRole(roleId, i, i + 20);
            i += 20;
            for (SUserMembership sUserMembership : memberships) {
                this.identityService.deleteUserMembership(sUserMembership.getId());
            }
        } while (memberships.size() == 20);
    }
}

