/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl.transaction.identity;

import java.util.List;
import org.bonitasoft.engine.actor.mapping.ActorMappingService;
import org.bonitasoft.engine.actor.mapping.SActorMemberDeletionException;
import org.bonitasoft.engine.actor.mapping.SActorMemberNotFoundException;
import org.bonitasoft.engine.actor.mapping.model.SActorMember;
import org.bonitasoft.engine.api.impl.transaction.identity.DeleteWithActorMembers;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.transaction.TransactionContent;
import org.bonitasoft.engine.identity.IdentityService;
import org.bonitasoft.engine.identity.model.SUserMembership;
import org.bonitasoft.engine.persistence.OrderByType;
import org.bonitasoft.engine.persistence.SBonitaReadException;
import org.bonitasoft.engine.profile.ProfileService;
import org.bonitasoft.engine.profile.builder.SProfileMemberBuilderFactory;
import org.bonitasoft.engine.profile.model.SProfileMember;

public class DeleteRoles
extends DeleteWithActorMembers
implements TransactionContent {
    private final IdentityService identityService;
    private final ActorMappingService actorMappingService;
    private final ProfileService profileService;
    private final List<Long> roleIds;

    public DeleteRoles(IdentityService identityService, ActorMappingService actorMappingService, ProfileService profileService, List<Long> roleIds) {
        this.identityService = identityService;
        this.actorMappingService = actorMappingService;
        this.roleIds = roleIds;
        this.profileService = profileService;
    }

    @Override
    public void execute() throws SBonitaException {
        for (Long roleId : this.roleIds) {
            this.deleteMembershipsByRole(roleId);
            this.deleteActorMembers(roleId);
            this.deleteProfileMembers(roleId);
            this.identityService.deleteRole(roleId);
        }
    }

    private void deleteActorMembers(Long roleId) throws SActorMemberNotFoundException, SActorMemberDeletionException, SBonitaReadException {
        List<SActorMember> actorMembers = this.actorMappingService.getActorMembersOfRole(roleId);
        for (SActorMember sActorMember : actorMembers) {
            this.setActorIdsOfRemovedElements(this.actorMappingService.removeActorMember(sActorMember.getId()));
        }
    }

    private void deleteProfileMembers(Long roleId) throws SBonitaException {
        int numberOfElements = 1000;
        String field = BuilderFactory.get(SProfileMemberBuilderFactory.class).getIdKey();
        List<SProfileMember> profileMembers = this.profileService.getProfileMembersOfRole(roleId, 0, 1000, field, OrderByType.ASC);
        while (profileMembers != null && !profileMembers.isEmpty()) {
            for (SProfileMember sProfileMember : profileMembers) {
                this.profileService.deleteProfileMember(sProfileMember);
            }
            profileMembers = this.profileService.getProfileMembersOfRole(roleId, 0, 1000, field, OrderByType.ASC);
        }
    }

    private void deleteMembershipsByRole(long roleId) throws SBonitaException {
        List<SUserMembership> memberships;
        int i = 0;
        do {
            memberships = this.identityService.getUserMembershipsOfRole(roleId, i, i + 20);
            i += 20;
            for (SUserMembership sUserMembership : memberships) {
                this.identityService.deleteUserMembership(sUserMembership.getId());
            }
        } while (memberships.size() == 20);
    }
}

