/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl.transaction.platform;

import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.transaction.TransactionContent;
import org.bonitasoft.engine.home.BonitaHomeServer;
import org.bonitasoft.engine.platform.PlatformService;
import org.bonitasoft.engine.platform.model.SPlatform;
import org.bonitasoft.engine.platform.model.SPlatformProperties;

public class CheckPlatformVersion
implements TransactionContent {
    private final PlatformService platformService;
    private boolean same;
    private SPlatform platform;
    private SPlatformProperties platformProperties;
    private final BonitaHomeServer bonitaHomeServer;
    private String errorMessage;

    public CheckPlatformVersion(PlatformService platformService, BonitaHomeServer bonitaHomeServer) {
        this.platformService = platformService;
        this.bonitaHomeServer = bonitaHomeServer;
    }

    @Override
    public void execute() throws SBonitaException {
        this.platform = this.platformService.getPlatform();
        String dbVersion = this.platform.getVersion();
        this.platformProperties = this.platformService.getSPlatformProperties();
        String jarVersion = this.platformProperties.getPlatformVersion();
        String bonitaHomeVersion = this.bonitaHomeServer.getVersion();
        String platformMinorVersion = this.format(dbVersion);
        String propertiesMinorVersion = this.format(jarVersion);
        this.same = platformMinorVersion.equals(propertiesMinorVersion);
        if (!this.same) {
            this.errorMessage = "The version of the platform in database is not the same as expected: bonita-server version is <" + jarVersion + "> and database version is <" + dbVersion + ">";
        } else {
            this.same = bonitaHomeVersion.equals(jarVersion);
            if (!this.same) {
                this.errorMessage = "The version of the bonita home is not the same as expected: bonita-server version is <" + jarVersion + "> and bonita home version is <" + bonitaHomeVersion + ">";
            }
        }
    }

    private String format(String version) {
        String trimVersion = version.trim();
        int endIndex = trimVersion.indexOf(".", 2);
        if (endIndex == -1) {
            return trimVersion;
        }
        return trimVersion.substring(0, endIndex);
    }

    public Boolean sameVersion() {
        return this.same;
    }

    public SPlatform getPlatform() {
        return this.platform;
    }

    public SPlatformProperties getPlatformProperties() {
        return this.platformProperties;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }
}

