/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl.transaction.platform;

import java.util.ArrayList;
import java.util.List;
import org.bonitasoft.engine.classloader.ClassLoaderService;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.transaction.TransactionContentWithResult;
import org.bonitasoft.engine.dependency.DependencyService;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.platform.PlatformService;
import org.bonitasoft.engine.platform.model.STenant;
import org.bonitasoft.engine.service.PlatformServiceAccessor;

public class RefreshPlatformClassLoader
implements TransactionContentWithResult<List<Long>> {
    private final PlatformServiceAccessor platformAccessor;
    private List<Long> tenantIds;

    public RefreshPlatformClassLoader(PlatformServiceAccessor platformAccessor) {
        this.platformAccessor = platformAccessor;
    }

    @Override
    public void execute() throws SBonitaException {
        List<STenant> tenants;
        DependencyService platformDependencyService = this.platformAccessor.getDependencyService();
        ClassLoaderService classLoaderService = this.platformAccessor.getClassLoaderService();
        platformDependencyService.refreshClassLoader(classLoaderService.getGlobalClassLoaderType(), classLoaderService.getGlobalClassLoaderId());
        PlatformService platformService = this.platformAccessor.getPlatformService();
        int maxResults = 100;
        int i = 0;
        this.tenantIds = new ArrayList<Long>();
        do {
            tenants = platformService.getTenants(new QueryOptions(i, 100));
            i += 100;
            for (STenant sTenant : tenants) {
                this.tenantIds.add(sTenant.getId());
            }
        } while (tenants.size() == 100);
        platformService.getPlatform();
    }

    @Override
    public List<Long> getResult() {
        return this.tenantIds;
    }
}

