/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl.transaction.platform;

import java.util.Map;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.command.CommandUpdater;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.transaction.TransactionContent;
import org.bonitasoft.engine.platform.command.PlatformCommandService;
import org.bonitasoft.engine.platform.command.model.SPlatformCommand;
import org.bonitasoft.engine.platform.command.model.SPlatformCommandUpdateBuilder;
import org.bonitasoft.engine.platform.command.model.SPlatformCommandUpdateBuilderFactory;
import org.bonitasoft.engine.recorder.model.EntityUpdateDescriptor;

public class UpdateSPlatformCommand
implements TransactionContent {
    private final PlatformCommandService platformCommandService;
    private final String name;
    private final CommandUpdater updateDescriptor;

    public UpdateSPlatformCommand(PlatformCommandService platformCommandService, String name, CommandUpdater updateDescriptor) {
        this.platformCommandService = platformCommandService;
        this.name = name;
        this.updateDescriptor = updateDescriptor;
    }

    @Override
    public void execute() throws SBonitaException {
        EntityUpdateDescriptor changeDescriptor = this.getCommandUpdateDescriptor();
        SPlatformCommand sPlatformCommand = this.platformCommandService.getPlatformCommand(this.name);
        this.platformCommandService.update(sPlatformCommand, changeDescriptor);
    }

    private EntityUpdateDescriptor getCommandUpdateDescriptor() {
        SPlatformCommandUpdateBuilder platformCommandUpdateBuilder = BuilderFactory.get(SPlatformCommandUpdateBuilderFactory.class).createNewInstance();
        Map fields = this.updateDescriptor.getFields();
        for (Map.Entry field : fields.entrySet()) {
            switch ((CommandUpdater.CommandField)field.getKey()) {
                case NAME: {
                    platformCommandUpdateBuilder.updateName((String)field.getValue());
                    break;
                }
                case DESCRIPTION: {
                    platformCommandUpdateBuilder.updateDescription((String)field.getValue());
                }
            }
        }
        return platformCommandUpdateBuilder.done();
    }
}

