/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl.transaction.profile;

import java.util.Collections;
import java.util.List;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.transaction.TransactionContent;
import org.bonitasoft.engine.persistence.FilterOption;
import org.bonitasoft.engine.persistence.OrderByOption;
import org.bonitasoft.engine.persistence.OrderByType;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.profile.ProfileService;
import org.bonitasoft.engine.profile.model.SProfile;

public class DeleteAllExistingProfiles
implements TransactionContent {
    private final ProfileService profileService;
    private List<SProfile> profiles;

    public DeleteAllExistingProfiles(ProfileService profileService) {
        this.profileService = profileService;
    }

    @Override
    public void execute() throws SBonitaException {
        QueryOptions queryOptions = new QueryOptions(0, 100, Collections.singletonList(new OrderByOption(SProfile.class, "name", OrderByType.ASC)), Collections.<FilterOption>emptyList(), null);
        do {
            this.profiles = this.profileService.searchProfiles(queryOptions);
            for (SProfile sProfile : this.profiles) {
                this.profileService.deleteProfile(sProfile);
            }
        } while (!this.profiles.isEmpty());
    }
}

