/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl.transaction.profile;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bonitasoft.engine.profile.model.SProfileMember;

public class ProfileMemberUtils {
    public static final String PROFILE_ID = "profileId";
    public static final String USER_ID = "userId";
    public static final String GROUP_ID = "groupId";
    public static final String ROLE_ID = "roleId";
    public static final String PROFILE_MEMBER_ID = "profileMemberId";
    public static final String DISPLAY_NAME_PART1 = "displayNamePart1";
    public static final String DISPLAY_NAME_PART2 = "displayNamePart2";
    public static final String DISPLAY_NAME_PART3 = "displayNamePart3";
    public static final String ROLE_AND_GROUP_TYPE = "roleAndGroup";
    public static final String ROLE_TYPE = "role";
    public static final String GROUP_TYPE = "group";
    public static final String USER_TYPE = "user";
    public static final String PROFILE_MEMBER_SEARCH_INDEX = "fromIndex";
    public static final String PROFILE_MEMBER_SEARCH_NUMBER = "numberOfProfiles";
    public static final String PROFILE_MEMBER_SEARCH_FIELD = "field";
    public static final String PROFILE_MEMBER_SEARCH_ORDER = "order";
    public static final String PROFILE_MEMBER_SEARCH_OPTIONS_KEY = "searchOptions";
    public static final String PROFILE_MEMBER_TYPE = "memberType";
    public static final String USER_SUFFIX = "ForUser";
    public static final String GROUP_SUFFIX = "ForGroup";
    public static final String ROLE_SUFFIX = "ForRole";
    public static final String ROLE_AND_GROUP_SUFFIX = "ForRoleAndGroup";

    public static HashMap<String, Serializable> memberAsProfileMembersMap(SProfileMember profileMember) {
        HashMap<String, Serializable> profileMemeber = new HashMap<String, Serializable>();
        profileMemeber.put(PROFILE_ID, Long.valueOf(profileMember.getProfileId()));
        profileMemeber.put(USER_ID, Long.valueOf(profileMember.getUserId()));
        profileMemeber.put(GROUP_ID, Long.valueOf(profileMember.getGroupId()));
        profileMemeber.put(ROLE_ID, Long.valueOf(profileMember.getRoleId()));
        profileMemeber.put(PROFILE_MEMBER_ID, Long.valueOf(profileMember.getId()));
        profileMemeber.put(DISPLAY_NAME_PART1, (Serializable)((Object)profileMember.getDisplayNamePart1()));
        profileMemeber.put(DISPLAY_NAME_PART2, (Serializable)((Object)profileMember.getDisplayNamePart2()));
        profileMemeber.put(DISPLAY_NAME_PART3, (Serializable)((Object)profileMember.getDisplayNamePart3()));
        return profileMemeber;
    }

    public static List<HashMap<String, Serializable>> membersAsProfileMembersMapList(List<SProfileMember> serverObjects) {
        ArrayList<HashMap<String, Serializable>> profileMemberMaps = new ArrayList<HashMap<String, Serializable>>();
        for (SProfileMember profileMember : serverObjects) {
            profileMemberMaps.add(ProfileMemberUtils.memberAsProfileMembersMap(profileMember));
        }
        return profileMemberMaps;
    }
}

