/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.authentication.impl;

import org.bonitasoft.engine.authentication.AuthenticationService;
import org.bonitasoft.engine.commons.LogUtil;
import org.bonitasoft.engine.identity.IdentityService;
import org.bonitasoft.engine.identity.SUserNotFoundException;
import org.bonitasoft.engine.identity.model.SUser;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;

public class AuthenticationServiceImpl
implements AuthenticationService {
    private final IdentityService identityService;
    private final TechnicalLoggerService logger;

    public AuthenticationServiceImpl(IdentityService identityService, TechnicalLoggerService logger) {
        this.identityService = identityService;
        this.logger = logger;
    }

    @Override
    public boolean checkUserCredentials(String userName, String password) {
        try {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "checkUserCredentials"));
            }
            SUser user = this.identityService.getUserByUserName(userName);
            boolean valid = this.identityService.chechCredentials(user, password);
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "checkUserCredentials"));
            }
            return valid;
        }
        catch (SUserNotFoundException sunfe) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "checkUserCredentials", sunfe));
            }
            return false;
        }
    }
}

