/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.commons.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.bonitasoft.engine.commons.ClassDataUtil;
import org.bonitasoft.engine.commons.NullCheckingUtil;

public class IOUtil {
    private static final int BUFF_SIZE = 100000;

    public static File createDirectory(String path) {
        File file = new File(path);
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    public static File createTempFile(String prefix, String suffix, File directory) throws IOException {
        File tmpDir = null;
        int retryNumber = 10;
        int j = 0;
        boolean succeded = false;
        do {
            try {
                int lastIndexOfSeparatorChar = prefix.lastIndexOf(47);
                String fileName = prefix;
                if (lastIndexOfSeparatorChar > -1) {
                    String dirToCreate = prefix.substring(0, lastIndexOfSeparatorChar);
                    new File(directory.getAbsolutePath() + File.separator + dirToCreate).mkdirs();
                    fileName = prefix.substring(lastIndexOfSeparatorChar, prefix.length());
                }
                tmpDir = File.createTempFile(fileName, suffix, directory);
                succeded = true;
            }
            catch (IOException e) {
                if (j == 10) {
                    throw e;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e1) {
                    // empty catch block
                }
                ++j;
            }
        } while (!succeded);
        return tmpDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(File file, byte[] fileContent) throws IOException {
        NullCheckingUtil.checkArgsNotNull(file, fileContent);
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            file.createNewFile();
        }
        FileOutputStream os = new FileOutputStream(file);
        try {
            ((OutputStream)os).write(fileContent);
            os.flush();
        }
        finally {
            ((OutputStream)os).close();
        }
    }

    public static byte[] generateJar(Class<?> ... classes) throws IOException {
        return IOUtil.generateJar(IOUtil.getResources(classes));
    }

    public static Map<String, byte[]> getResources(Class<?> ... classes) throws IOException {
        if (classes == null || classes.length == 0) {
            String message = "No classes available";
            throw new IOException("No classes available");
        }
        HashMap<String, byte[]> resources = new HashMap<String, byte[]>();
        for (Class<?> clazz : classes) {
            resources.put(clazz.getName().replace(".", "/") + ".class", ClassDataUtil.getClassData(clazz));
            for (Class<?> internalClass : clazz.getDeclaredClasses()) {
                resources.put(internalClass.getName().replace(".", "/") + ".class", ClassDataUtil.getClassData(internalClass));
            }
        }
        return resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] generateJar(Map<String, byte[]> resources) throws IOException {
        if (resources == null || resources.size() == 0) {
            String message = "No resources available";
            throw new IOException("No resources available");
        }
        ByteArrayOutputStream baos = null;
        ZipOutputStream jarOutStream = null;
        try {
            baos = new ByteArrayOutputStream();
            jarOutStream = new JarOutputStream(new BufferedOutputStream(baos));
            for (Map.Entry<String, byte[]> resource : resources.entrySet()) {
                ((JarOutputStream)jarOutStream).putNextEntry(new JarEntry(resource.getKey()));
                jarOutStream.write(resource.getValue());
            }
            jarOutStream.flush();
            baos.flush();
        }
        finally {
            if (jarOutStream != null) {
                jarOutStream.close();
            }
            if (baos != null) {
                baos.close();
            }
        }
        return baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getAllContentFrom(InputStream in) throws IOException {
        byte[] resultArray;
        if (in == null) {
            throw new IOException("The InputStream is null!");
        }
        byte[] buffer = new byte[100000];
        BufferedInputStream bis = null;
        ByteArrayOutputStream result = null;
        try {
            int amountRead;
            bis = new BufferedInputStream(in);
            result = new ByteArrayOutputStream();
            while ((amountRead = bis.read(buffer)) > 0) {
                result.write(buffer, 0, amountRead);
            }
            resultArray = result.toByteArray();
            result.flush();
        }
        finally {
            if (bis != null) {
                bis.close();
            }
            if (result != null) {
                result.close();
            }
        }
        return resultArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getAllContentFrom(File file) throws IOException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            byte[] byArray = IOUtil.getAllContentFrom(in);
            return byArray;
        }
        finally {
            if (in != null) {
                ((InputStream)in).close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getAllContentFrom(URL url) throws IOException {
        InputStream in = url.openStream();
        try {
            byte[] byArray = IOUtil.getAllContentFrom(in);
            return byArray;
        }
        finally {
            in.close();
        }
    }

    public static boolean deleteDir(File dir) throws IOException {
        return IOUtil.deleteDir(dir, 1, 0L);
    }

    public static boolean deleteDir(File dir, int attempts, long sleepTime) throws IOException {
        boolean result = true;
        if (!dir.exists()) {
            return false;
        }
        if (!dir.isDirectory()) {
            throw new IOException("Unable to delete directory: " + dir + ", it is not a directory");
        }
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                IOUtil.deleteDir(files[i], attempts, sleepTime);
                continue;
            }
            result = result && IOUtil.deleteFile(files[i], attempts, sleepTime);
        }
        result = result && IOUtil.deleteFile(dir, attempts, sleepTime);
        return result;
    }

    public static boolean deleteFile(File f, int attempts, long sleepTime) {
        int retries = attempts;
        while (retries > 0 && !f.delete()) {
            --retries;
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException e) {}
        }
        return retries > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileContent(File file) {
        StringBuilder sb = new StringBuilder();
        try {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            try {
                String line = null;
                while ((line = reader.readLine()) != null) {
                    sb.append(line);
                    sb.append(System.getProperty("line.separator"));
                }
            }
            finally {
                reader.close();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(File file, String fileContent) throws FileNotFoundException, IOException {
        if (file == null) {
            throw new IllegalArgumentException("File should not be null.");
        }
        if (!file.exists()) {
            throw new FileNotFoundException("File does not exist: " + file);
        }
        if (!file.isFile()) {
            throw new IllegalArgumentException("Should not be a directory: " + file);
        }
        if (!file.canWrite()) {
            throw new IllegalArgumentException("File cannot be written: " + file);
        }
        BufferedWriter output = new BufferedWriter(new FileWriter(file));
        try {
            output.write(fileContent);
        }
        finally {
            ((Writer)output).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(ZipInputStream inputStream, File target) throws IOException {
        FileOutputStream fos = new FileOutputStream(target);
        int BUFF_SIZE = 1024;
        byte[] buf = new byte[1024];
        try {
            int n;
            while ((n = inputStream.read(buf)) > 0) {
                fos.write(buf, 0, n);
            }
        }
        finally {
            fos.close();
        }
    }
}

