/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.connector;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.connector.ConnectorResult;
import org.bonitasoft.engine.core.connector.ConnectorService;
import org.bonitasoft.engine.core.connector.exception.SConnectorException;
import org.bonitasoft.engine.core.connector.exception.SInvalidConnectorImplementationException;
import org.bonitasoft.engine.core.connector.parser.SConnectorImplementationDescriptor;
import org.bonitasoft.engine.core.expression.control.model.SExpressionContext;
import org.bonitasoft.engine.core.operation.model.SOperation;
import org.bonitasoft.engine.core.process.definition.model.SProcessDefinition;
import org.bonitasoft.engine.core.process.instance.model.SConnectorInstance;
import org.bonitasoft.engine.expression.EngineConstantExpressionBuilder;
import org.bonitasoft.engine.expression.exception.SExpressionDependencyMissingException;
import org.bonitasoft.engine.expression.exception.SExpressionEvaluationException;
import org.bonitasoft.engine.expression.exception.SExpressionTypeUnknownException;
import org.bonitasoft.engine.expression.exception.SInvalidExpressionException;
import org.bonitasoft.engine.expression.model.SExpression;
import org.bonitasoft.engine.persistence.OrderByType;

public class ConnectorServiceDecorator
implements ConnectorService {
    private final ConnectorService connectorService;

    public ConnectorServiceDecorator(ConnectorService connectorService) {
        this.connectorService = connectorService;
    }

    @Override
    public ConnectorResult executeMutipleEvaluation(long processDefinitionId, String connectorDefinitionId, String connectorDefinitionVersion, Map<String, SExpression> connectorInputParameters, Map<String, Map<String, Serializable>> inputValues, ClassLoader classLoader, SExpressionContext sexpContext) throws SConnectorException {
        SExpression apiAccessorExpression;
        try {
            apiAccessorExpression = EngineConstantExpressionBuilder.getConnectorAPIAccessorExpression();
        }
        catch (SInvalidExpressionException e) {
            throw new SConnectorException("Error creation apiAccessor Expression", e);
        }
        HashMap<String, SExpression> parameters = new HashMap<String, SExpression>(connectorInputParameters);
        parameters.put("connectorApiAccessor", apiAccessorExpression);
        return this.connectorService.executeMutipleEvaluation(processDefinitionId, connectorDefinitionId, connectorDefinitionVersion, parameters, inputValues, classLoader, sexpContext);
    }

    @Override
    public boolean loadConnectors(SProcessDefinition sDefinition, long tenantId) throws SConnectorException {
        return this.connectorService.loadConnectors(sDefinition, tenantId);
    }

    @Override
    public void setConnectorImplementation(SProcessDefinition sProcessDefinition, long tenantId, String connectorId, String connectorVersion, byte[] connectorImplementationArchive) throws SConnectorException, SInvalidConnectorImplementationException {
        this.connectorService.setConnectorImplementation(sProcessDefinition, tenantId, connectorId, connectorVersion, connectorImplementationArchive);
    }

    @Override
    public List<SConnectorImplementationDescriptor> getConnectorImplementations(long processDefinitionId, long tenantId, int fromIndex, int numberPerPage, String field, OrderByType order) throws SConnectorException {
        return this.connectorService.getConnectorImplementations(processDefinitionId, tenantId, fromIndex, numberPerPage, field, order);
    }

    @Override
    public SConnectorImplementationDescriptor getConnectorImplementation(long processDefinitionId, String connectorId, String connectorVersion, long tenantId) throws SConnectorException {
        return this.connectorService.getConnectorImplementation(processDefinitionId, connectorId, connectorVersion, tenantId);
    }

    @Override
    public Map<String, Object> evaluateInputParameters(Map<String, SExpression> parameters, SExpressionContext sExpressionContext, Map<String, Map<String, Serializable>> inputValues) throws SExpressionTypeUnknownException, SExpressionEvaluationException, SExpressionDependencyMissingException, SInvalidExpressionException {
        SExpression apiAccessorExpression = EngineConstantExpressionBuilder.getConnectorAPIAccessorExpression();
        SExpression engineExecutionContext = EngineConstantExpressionBuilder.getEngineExecutionContext();
        HashMap<String, SExpression> newParameters = new HashMap<String, SExpression>(parameters);
        newParameters.put("connectorApiAccessor", apiAccessorExpression);
        newParameters.put("engineExecutionContext", engineExecutionContext);
        return this.connectorService.evaluateInputParameters(newParameters, sExpressionContext, inputValues);
    }

    @Override
    public void executeOutputOperation(List<SOperation> outputs, SExpressionContext expressionContext, ConnectorResult connectorOutput) throws SBonitaException {
        this.connectorService.executeOutputOperation(outputs, expressionContext, connectorOutput);
    }

    @Override
    public ConnectorResult executeConnector(long rootDefinitionId, SConnectorInstance sConnectorInstance, ClassLoader classLoader, Map<String, Object> inputParameters) throws SConnectorException {
        return this.connectorService.executeConnector(rootDefinitionId, sConnectorInstance, classLoader, inputParameters);
    }

    @Override
    public void disconnect(ConnectorResult result) throws SConnectorException {
        this.connectorService.disconnect(result);
    }

    @Override
    public Long getNumberOfConnectorImplementations(long processDefinitionId, long tenantId) throws SConnectorException {
        return this.connectorService.getNumberOfConnectorImplementations(processDefinitionId, tenantId);
    }
}

