/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.core.filter.impl;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.bonitasoft.engine.cache.CacheException;
import org.bonitasoft.engine.cache.CacheService;
import org.bonitasoft.engine.connector.ConnectorExecutor;
import org.bonitasoft.engine.connector.exception.SConnectorException;
import org.bonitasoft.engine.core.expression.control.api.ExpressionResolverService;
import org.bonitasoft.engine.core.expression.control.model.SExpressionContext;
import org.bonitasoft.engine.core.filter.FilterResult;
import org.bonitasoft.engine.core.filter.UserFilterImplementationDescriptor;
import org.bonitasoft.engine.core.filter.UserFilterService;
import org.bonitasoft.engine.core.filter.exception.SUserFilterExecutionException;
import org.bonitasoft.engine.core.filter.exception.SUserFilterLoadingException;
import org.bonitasoft.engine.core.filter.impl.FilterResultImpl;
import org.bonitasoft.engine.core.filter.impl.JarDependenciesBinding;
import org.bonitasoft.engine.core.filter.impl.SConnectorUserFilterAdapter;
import org.bonitasoft.engine.core.filter.impl.UserFilterImplementationBinding;
import org.bonitasoft.engine.core.process.definition.model.SUserFilterDefinition;
import org.bonitasoft.engine.exception.BonitaHomeNotSetException;
import org.bonitasoft.engine.exception.BonitaRuntimeException;
import org.bonitasoft.engine.expression.exception.SExpressionDependencyMissingException;
import org.bonitasoft.engine.expression.exception.SExpressionEvaluationException;
import org.bonitasoft.engine.expression.exception.SExpressionTypeUnknownException;
import org.bonitasoft.engine.expression.exception.SInvalidExpressionException;
import org.bonitasoft.engine.expression.model.SExpression;
import org.bonitasoft.engine.filter.UserFilter;
import org.bonitasoft.engine.home.BonitaHomeServer;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.sessionaccessor.ReadSessionAccessor;
import org.bonitasoft.engine.xml.ElementBinding;
import org.bonitasoft.engine.xml.Parser;
import org.bonitasoft.engine.xml.ParserFactory;
import org.bonitasoft.engine.xml.SXMLParseException;

public class UserFilterServiceImpl
implements UserFilterService {
    private static final String FILTER_CACHE_NAME = "USER_FILTER";
    private final ConnectorExecutor connectorExecutor;
    private final CacheService cacheService;
    private final ReadSessionAccessor sessionAccessor;
    private final ExpressionResolverService expressionResolverService;
    private final Parser parser;
    private final TechnicalLoggerService logger;

    public UserFilterServiceImpl(ConnectorExecutor connectorExecutor, CacheService cacheService, ReadSessionAccessor sessionAccessor, ExpressionResolverService expressionResolverService, ParserFactory parserFactory, TechnicalLoggerService logger) {
        this.connectorExecutor = connectorExecutor;
        this.cacheService = cacheService;
        this.sessionAccessor = sessionAccessor;
        this.expressionResolverService = expressionResolverService;
        this.logger = logger;
        ArrayList<Class<? extends ElementBinding>> bindings = new ArrayList<Class<? extends ElementBinding>>(2);
        bindings.add(JarDependenciesBinding.class);
        bindings.add(UserFilterImplementationBinding.class);
        this.parser = parserFactory.createParser(bindings);
    }

    @Override
    public FilterResult executeFilter(long processDefinitionId, SUserFilterDefinition sUserFilterDefinition, Map<String, SExpression> inputs, ClassLoader classLoader, SExpressionContext expressionContext, String actorName) throws SUserFilterExecutionException {
        FilterResult filterResult;
        try {
            UserFilterImplementationDescriptor descriptor = this.getDescriptor(processDefinitionId, sUserFilterDefinition);
            if (descriptor == null) {
                String tenantId = String.valueOf(this.sessionAccessor.getTenantId());
                this.loadUserFilters(processDefinitionId, Long.valueOf(tenantId));
                descriptor = this.getDescriptor(processDefinitionId, sUserFilterDefinition);
                if (descriptor == null) {
                    throw new SUserFilterExecutionException("unable to load descriptor for filter " + sUserFilterDefinition.getUserFilterId());
                }
            }
            String implementationClassName = descriptor.getImplementationClassName();
            filterResult = this.executeFilterInClassloader(implementationClassName, inputs, classLoader, expressionContext, actorName);
        }
        catch (SConnectorException e) {
            throw new SUserFilterExecutionException(e.getCause());
        }
        catch (Throwable e) {
            throw new SUserFilterExecutionException(e);
        }
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.DEBUG)) {
            StringBuilder stb = new StringBuilder();
            stb.append("Executed userFilter [name: <");
            stb.append(sUserFilterDefinition.getName());
            stb.append(">, user filter id: <");
            stb.append(sUserFilterDefinition.getUserFilterId());
            stb.append(">, version: <");
            stb.append(sUserFilterDefinition.getVersion());
            stb.append(">] on flow node instance with id: <");
            stb.append(expressionContext.getContainerId());
            stb.append(">");
            this.logger.log(this.getClass(), TechnicalLogSeverity.DEBUG, stb.toString());
        }
        return filterResult;
    }

    private UserFilterImplementationDescriptor getDescriptor(long processDefinitionId, SUserFilterDefinition sUserFilterDefinition) throws CacheException {
        UserFilterImplementationDescriptor descriptor = (UserFilterImplementationDescriptor)this.cacheService.get(FILTER_CACHE_NAME, this.getUserFilterImplementationIdInCache(processDefinitionId, sUserFilterDefinition.getUserFilterId(), sUserFilterDefinition.getVersion()));
        return descriptor;
    }

    private String getUserFilterImplementationIdInCache(long processDefinitionId, String userFilterId, String version) {
        return processDefinitionId + 58L + userFilterId + '-' + version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FilterResult executeFilterInClassloader(String implementationClassName, Map<String, SExpression> parameters, ClassLoader classLoader, SExpressionContext expressionContext, String actorName) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SUserFilterExecutionException, SExpressionTypeUnknownException, SExpressionEvaluationException, SExpressionDependencyMissingException, SInvalidExpressionException, SConnectorException {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(classLoader);
            UserFilter filter = (UserFilter)Class.forName(implementationClassName, true, classLoader).newInstance();
            if (filter == null) {
                throw new SUserFilterExecutionException("Can not instantiate UserFilter " + implementationClassName + ". It is null.");
            }
            SConnectorUserFilterAdapter sConnectorAdapter = new SConnectorUserFilterAdapter(filter, actorName);
            HashMap<String, Object> inputParameters = new HashMap<String, Object>(parameters.size());
            for (Map.Entry<String, SExpression> input : parameters.entrySet()) {
                if (expressionContext != null) {
                    inputParameters.put(input.getKey(), this.expressionResolverService.evaluate(input.getValue(), expressionContext));
                    continue;
                }
                inputParameters.put(input.getKey(), this.expressionResolverService.evaluate(input.getValue()));
            }
            this.connectorExecutor.execute(sConnectorAdapter, inputParameters);
            FilterResultImpl filterResultImpl = new FilterResultImpl(sConnectorAdapter.getUserIds(), sConnectorAdapter.shouldAutoAssignTaskIfSingleResult());
            return filterResultImpl;
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    @Override
    public boolean loadUserFilters(long processDefinitionId, long tenantId) throws SUserFilterLoadingException {
        boolean resolved = true;
        try {
            String processesFolder = BonitaHomeServer.getInstance().getProcessesFolder(tenantId);
            File connectorsFolder = new File(new File(processesFolder, String.valueOf(processDefinitionId)), "userFilters");
            File[] listFiles = connectorsFolder.listFiles();
            Pattern pattern = Pattern.compile("^.*\\.impl$");
            for (File file : listFiles) {
                String name = file.getName();
                if (!pattern.matcher(name).matches()) continue;
                UserFilterImplementationDescriptor userFilterImplementationDescriptor = null;
                try {
                    Object objectFromXML = this.parser.getObjectFromXML(file);
                    userFilterImplementationDescriptor = (UserFilterImplementationDescriptor)objectFromXML;
                    if (userFilterImplementationDescriptor == null) {
                        throw new SUserFilterLoadingException("Can not parse ConnectorImplementation XML. The file name is " + name);
                    }
                    this.cacheService.store(FILTER_CACHE_NAME, (Serializable)((Object)this.getUserFilterImplementationIdInCache(processDefinitionId, userFilterImplementationDescriptor.getDefinitionId(), userFilterImplementationDescriptor.getDefinitionVersion())), userFilterImplementationDescriptor);
                }
                catch (IOException e) {
                    throw new SUserFilterLoadingException("Can not load userFilterImplementationDescriptor XML. The file name is " + name, e);
                }
                catch (SXMLParseException e) {
                    throw new SUserFilterLoadingException("Can not load userFilterImplementationDescriptor XML. The file name is " + name, e);
                }
                catch (CacheException e) {
                    throw new SUserFilterLoadingException("Unable to cache the user filter implementation" + name, e);
                }
                resolved = true;
            }
        }
        catch (BonitaHomeNotSetException e) {
            throw new BonitaRuntimeException("Bonita home is not set");
        }
        return resolved;
    }
}

