/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.core.operation.impl;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.bonitasoft.engine.core.expression.control.model.SExpressionContext;
import org.bonitasoft.engine.core.operation.exception.SOperationExecutionException;
import org.bonitasoft.engine.core.operation.impl.UpdateOperationExecutorStrategy;
import org.bonitasoft.engine.core.operation.model.SOperation;
import org.bonitasoft.engine.data.instance.api.DataInstanceService;

public class JavaMethodOperationExecutorStrategy
extends UpdateOperationExecutorStrategy {
    public static final String TYPE_JAVA_METHOD = "JAVA_METHOD";
    protected static Map<String, Class<?>> primitiveTypes = new HashMap(8);
    private static Map<String, Class<?>> autoboxableTypes;

    public JavaMethodOperationExecutorStrategy(DataInstanceService dataInstanceService) {
        super(dataInstanceService);
    }

    private Method getMethod(SOperation operation, Class<?> dataType) throws NoSuchMethodException, ClassNotFoundException {
        String[] split = operation.getOperator().split(":", 2);
        String operator = split[0];
        if (split.length > 1) {
            String className = split[1];
            try {
                return dataType.getDeclaredMethod(operator, this.getClass(className));
            }
            catch (NoSuchMethodException e) {
                if (autoboxableTypes.containsKey(className)) {
                    return dataType.getDeclaredMethod(operator, autoboxableTypes.get(className));
                }
                throw e;
            }
        }
        return dataType.getDeclaredMethod(operator, new Class[0]);
    }

    protected Class<?> getClass(String type) throws ClassNotFoundException {
        if (primitiveTypes.containsKey(type)) {
            return primitiveTypes.get(type);
        }
        return Class.forName(type);
    }

    @Override
    public Object getValue(SOperation operation, Object valueToSetObjectWith, long containerId, String containerType, SExpressionContext expressionContext) throws SOperationExecutionException {
        String dataToSet = operation.getLeftOperand().getName();
        Object objectToInvokeJavaMethodOn = expressionContext.getInputValues().get(dataToSet);
        if (objectToInvokeJavaMethodOn == null) {
            throw new SOperationExecutionException("data " + dataToSet + " does not exist in the context " + containerId + " " + containerType);
        }
        try {
            Class<?> expressionResultType = Thread.currentThread().getContextClassLoader().loadClass(operation.getRightOperand().getReturnType());
            Class<?> dataType = Thread.currentThread().getContextClassLoader().loadClass(objectToInvokeJavaMethodOn.getClass().getName());
            Method method = this.getMethod(operation, dataType);
            Object o = dataType.cast(objectToInvokeJavaMethodOn);
            method.invoke(o, expressionResultType.cast(valueToSetObjectWith));
            return o;
        }
        catch (Exception e) {
            throw new SOperationExecutionException("Unable to evaluate operation " + operation, e);
        }
    }

    @Override
    public String getOperationType() {
        return TYPE_JAVA_METHOD;
    }

    static {
        primitiveTypes.put("char", Character.TYPE);
        primitiveTypes.put("byte", Byte.TYPE);
        primitiveTypes.put("long", Long.TYPE);
        primitiveTypes.put("int", Integer.TYPE);
        primitiveTypes.put("float", Float.TYPE);
        primitiveTypes.put("double", Double.TYPE);
        primitiveTypes.put("short", Short.TYPE);
        primitiveTypes.put("boolean", Boolean.TYPE);
        autoboxableTypes = new HashMap(8);
        autoboxableTypes.put(Character.class.getName(), Character.TYPE);
        autoboxableTypes.put(Byte.class.getName(), Byte.TYPE);
        autoboxableTypes.put(Long.class.getName(), Long.TYPE);
        autoboxableTypes.put(Integer.class.getName(), Integer.TYPE);
        autoboxableTypes.put(Float.class.getName(), Float.TYPE);
        autoboxableTypes.put(Double.class.getName(), Double.TYPE);
        autoboxableTypes.put(Short.class.getName(), Short.TYPE);
        autoboxableTypes.put(Boolean.class.getName(), Boolean.TYPE);
    }
}

