/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.core.process.definition.model.builder;

import java.util.ArrayList;
import java.util.List;
import org.bonitasoft.engine.bpm.data.DataDefinition;
import org.bonitasoft.engine.bpm.data.TextDataDefinition;
import org.bonitasoft.engine.bpm.data.XMLDataDefinition;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.core.operation.model.SOperation;
import org.bonitasoft.engine.core.operation.model.SOperatorType;
import org.bonitasoft.engine.core.operation.model.builder.SLeftOperandBuilderFactory;
import org.bonitasoft.engine.core.operation.model.builder.SOperationBuilderFactory;
import org.bonitasoft.engine.data.definition.model.SDataDefinition;
import org.bonitasoft.engine.data.definition.model.builder.SDataDefinitionBuilder;
import org.bonitasoft.engine.data.definition.model.builder.SDataDefinitionBuilderFactory;
import org.bonitasoft.engine.data.definition.model.builder.SXMLDataDefinitionBuilder;
import org.bonitasoft.engine.data.definition.model.builder.SXMLDataDefinitionBuilderFactory;
import org.bonitasoft.engine.expression.Expression;
import org.bonitasoft.engine.expression.exception.SInvalidExpressionException;
import org.bonitasoft.engine.expression.model.SExpression;
import org.bonitasoft.engine.expression.model.builder.SExpressionBuilderFactory;
import org.bonitasoft.engine.operation.Operation;

public class ServerModelConvertor {
    public static SExpression convertExpression(Expression value) {
        if (value == null) {
            return null;
        }
        ArrayList<SExpression> dependencies = new ArrayList<SExpression>();
        for (Expression expression : value.getDependencies()) {
            dependencies.add(ServerModelConvertor.convertExpression(expression));
        }
        try {
            return BuilderFactory.get(SExpressionBuilderFactory.class).createNewInstance().setName(value.getName()).setContent(value.getContent()).setExpressionType(value.getExpressionType()).setInterpreter(value.getInterpreter()).setReturnType(value.getReturnType()).setDependencies(dependencies).done();
        }
        catch (SInvalidExpressionException e) {
            throw new IllegalArgumentException("Error building SExpression", e);
        }
    }

    public static SOperation convertOperation(Operation operation) {
        return BuilderFactory.get(SOperationBuilderFactory.class).createNewInstance().setOperator(operation.getOperator()).setType(SOperatorType.valueOf(operation.getType().name())).setRightOperand(ServerModelConvertor.convertExpression(operation.getRightOperand())).setLeftOperand(BuilderFactory.get(SLeftOperandBuilderFactory.class).createNewInstance().setName(operation.getLeftOperand().getName()).done()).done();
    }

    public static List<SOperation> convertOperations(List<Operation> operations) {
        ArrayList<SOperation> sOperations = new ArrayList<SOperation>(operations.size());
        for (Operation operation : operations) {
            sOperations.add(ServerModelConvertor.convertOperation(operation));
        }
        return sOperations;
    }

    public static SDataDefinition convertDataDefinition(DataDefinition dataDefinition) {
        if (dataDefinition instanceof XMLDataDefinition) {
            XMLDataDefinition xmlDataDef = (XMLDataDefinition)dataDefinition;
            SXMLDataDefinitionBuilderFactory fact = BuilderFactory.get(SXMLDataDefinitionBuilderFactory.class);
            SXMLDataDefinitionBuilder builder = fact.createNewXMLData(dataDefinition.getName()).setElement(xmlDataDef.getElement()).setNamespace(xmlDataDef.getNamespace());
            builder.setDefaultValue(ServerModelConvertor.convertExpression(dataDefinition.getDefaultValueExpression()));
            builder.setDescription(dataDefinition.getDescription());
            builder.setTransient(dataDefinition.isTransientData());
            return builder.done();
        }
        SDataDefinitionBuilderFactory fact = BuilderFactory.get(SDataDefinitionBuilderFactory.class);
        SDataDefinitionBuilder builder = null;
        if (dataDefinition instanceof TextDataDefinition) {
            TextDataDefinition textDataDefinition = (TextDataDefinition)dataDefinition;
            builder = fact.createNewTextData(dataDefinition.getName()).setAsLongText(textDataDefinition.isLongText());
        } else {
            builder = fact.createNewInstance(dataDefinition.getName(), dataDefinition.getClassName());
        }
        builder.setDefaultValue(ServerModelConvertor.convertExpression(dataDefinition.getDefaultValueExpression()));
        builder.setDescription(dataDefinition.getDescription());
        builder.setTransient(dataDefinition.isTransientData());
        return builder.done();
    }
}

