/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.core.process.definition.model.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bonitasoft.engine.bpm.connector.ConnectorDefinition;
import org.bonitasoft.engine.bpm.connector.ConnectorEvent;
import org.bonitasoft.engine.bpm.data.DataDefinition;
import org.bonitasoft.engine.bpm.document.DocumentDefinition;
import org.bonitasoft.engine.bpm.flownode.ActivityDefinition;
import org.bonitasoft.engine.bpm.flownode.CallActivityDefinition;
import org.bonitasoft.engine.bpm.flownode.CatchEventDefinition;
import org.bonitasoft.engine.bpm.flownode.EndEventDefinition;
import org.bonitasoft.engine.bpm.flownode.GatewayDefinition;
import org.bonitasoft.engine.bpm.flownode.IntermediateCatchEventDefinition;
import org.bonitasoft.engine.bpm.flownode.IntermediateThrowEventDefinition;
import org.bonitasoft.engine.bpm.flownode.ManualTaskDefinition;
import org.bonitasoft.engine.bpm.flownode.StartEventDefinition;
import org.bonitasoft.engine.bpm.flownode.ThrowEventDefinition;
import org.bonitasoft.engine.bpm.flownode.TransitionDefinition;
import org.bonitasoft.engine.bpm.flownode.UserTaskDefinition;
import org.bonitasoft.engine.bpm.flownode.impl.AutomaticTaskDefinitionImpl;
import org.bonitasoft.engine.bpm.flownode.impl.FlowElementContainerDefinition;
import org.bonitasoft.engine.bpm.flownode.impl.HumanTaskDefinitionImpl;
import org.bonitasoft.engine.bpm.flownode.impl.ManualTaskDefinitionImpl;
import org.bonitasoft.engine.bpm.flownode.impl.ReceiveTaskDefinitionImpl;
import org.bonitasoft.engine.bpm.flownode.impl.SendTaskDefinitionImpl;
import org.bonitasoft.engine.bpm.flownode.impl.UserTaskDefinitionImpl;
import org.bonitasoft.engine.bpm.process.SubProcessDefinition;
import org.bonitasoft.engine.bpm.userfilter.UserFilterDefinition;
import org.bonitasoft.engine.core.process.definition.model.SActivityDefinition;
import org.bonitasoft.engine.core.process.definition.model.SConnectorDefinition;
import org.bonitasoft.engine.core.process.definition.model.SDocumentDefinition;
import org.bonitasoft.engine.core.process.definition.model.SFlowElementContainerDefinition;
import org.bonitasoft.engine.core.process.definition.model.SFlowNodeDefinition;
import org.bonitasoft.engine.core.process.definition.model.SFlowNodeType;
import org.bonitasoft.engine.core.process.definition.model.SGatewayDefinition;
import org.bonitasoft.engine.core.process.definition.model.SGatewayType;
import org.bonitasoft.engine.core.process.definition.model.SNamedElement;
import org.bonitasoft.engine.core.process.definition.model.SSubProcessDefinition;
import org.bonitasoft.engine.core.process.definition.model.STransitionDefinition;
import org.bonitasoft.engine.core.process.definition.model.builder.ServerModelConvertor;
import org.bonitasoft.engine.core.process.definition.model.event.SBoundaryEventDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.SEndEventDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.SIntermediateCatchEventDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.SIntermediateThrowEventDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.SStartEventDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.impl.SEndEventDefinitionImpl;
import org.bonitasoft.engine.core.process.definition.model.event.impl.SIntermediateCatchEventDefinitionImpl;
import org.bonitasoft.engine.core.process.definition.model.event.impl.SIntermediateThrowEventDefinitionImpl;
import org.bonitasoft.engine.core.process.definition.model.event.impl.SStartEventDefinitionImpl;
import org.bonitasoft.engine.core.process.definition.model.impl.SActivityDefinitionImpl;
import org.bonitasoft.engine.core.process.definition.model.impl.SAutomaticTaskDefinitionImpl;
import org.bonitasoft.engine.core.process.definition.model.impl.SBaseElementImpl;
import org.bonitasoft.engine.core.process.definition.model.impl.SCallActivityDefinitionImpl;
import org.bonitasoft.engine.core.process.definition.model.impl.SConnectorDefinitionImpl;
import org.bonitasoft.engine.core.process.definition.model.impl.SDocumentDefinitionImpl;
import org.bonitasoft.engine.core.process.definition.model.impl.SGatewayDefinitionImpl;
import org.bonitasoft.engine.core.process.definition.model.impl.SHumanTaskDefinitionImpl;
import org.bonitasoft.engine.core.process.definition.model.impl.SManualTaskDefinitionImpl;
import org.bonitasoft.engine.core.process.definition.model.impl.SReceiveTaskDefinitionImpl;
import org.bonitasoft.engine.core.process.definition.model.impl.SSendTaskDefinitionImpl;
import org.bonitasoft.engine.core.process.definition.model.impl.SSubProcessDefinitionImpl;
import org.bonitasoft.engine.core.process.definition.model.impl.STransitionDefinitionImpl;
import org.bonitasoft.engine.core.process.definition.model.impl.SUserFilterDefinitionImpl;
import org.bonitasoft.engine.core.process.definition.model.impl.SUserTaskDefinitionImpl;
import org.bonitasoft.engine.data.definition.model.SDataDefinition;
import org.bonitasoft.engine.exception.BonitaRuntimeException;

public class SFlowElementContainerDefinitionImpl
extends SBaseElementImpl
implements SFlowElementContainerDefinition {
    private static final long serialVersionUID = -40122166157566478L;
    private final Map<ConnectorEvent, List<SConnectorDefinition>> connectorsMap;
    private final Map<String, SFlowNodeDefinition> allElementsMapString;
    private final Map<String, SGatewayDefinition> gatewaysMap;
    private final Map<Long, SFlowNodeDefinition> allElementsMap;
    private final Map<String, SConnectorDefinition> allConnectorsMap;
    private final Map<String, STransitionDefinition> transitionsMap;
    private final Set<SActivityDefinition> activities;
    private final Set<STransitionDefinition> transitions;
    private final Set<SGatewayDefinition> gateways;
    private final Set<SFlowNodeDefinition> allElements;
    private final List<SConnectorDefinition> connectors;
    private final List<SStartEventDefinition> sStartEvents;
    private final List<SIntermediateCatchEventDefinition> sIntermediateCatchEvents;
    private final List<SBoundaryEventDefinition> sBoundaryEvents;
    private final List<SEndEventDefinition> sEndEvents;
    private final List<SIntermediateThrowEventDefinition> sIntermediateThrowEvents;
    private final List<SDataDefinition> sDataDefinitions;
    private final List<SDocumentDefinition> sDocumentDefinitions;
    private SNamedElement elementContainer;
    private boolean containsInclusiveGateway = false;

    public SFlowElementContainerDefinitionImpl() {
        this.activities = new HashSet<SActivityDefinition>();
        this.transitions = new HashSet<STransitionDefinition>();
        this.transitionsMap = new HashMap<String, STransitionDefinition>();
        this.gateways = new HashSet<SGatewayDefinition>();
        this.gatewaysMap = new HashMap<String, SGatewayDefinition>();
        this.allElements = new HashSet<SFlowNodeDefinition>();
        this.allElementsMap = new HashMap<Long, SFlowNodeDefinition>();
        this.allElementsMapString = new HashMap<String, SFlowNodeDefinition>();
        this.connectors = new ArrayList<SConnectorDefinition>();
        this.connectorsMap = new HashMap<ConnectorEvent, List<SConnectorDefinition>>(2);
        this.connectorsMap.put(ConnectorEvent.ON_ENTER, new ArrayList());
        this.connectorsMap.put(ConnectorEvent.ON_FINISH, new ArrayList());
        this.allConnectorsMap = new HashMap<String, SConnectorDefinition>(2);
        this.sStartEvents = new ArrayList<SStartEventDefinition>();
        this.sIntermediateCatchEvents = new ArrayList<SIntermediateCatchEventDefinition>();
        this.sIntermediateThrowEvents = new ArrayList<SIntermediateThrowEventDefinition>();
        this.sEndEvents = new ArrayList<SEndEventDefinition>();
        this.sDataDefinitions = new ArrayList<SDataDefinition>();
        this.sDocumentDefinitions = new ArrayList<SDocumentDefinition>();
        this.sBoundaryEvents = new ArrayList<SBoundaryEventDefinition>();
    }

    public SFlowElementContainerDefinitionImpl(SNamedElement elementContainer, FlowElementContainerDefinition container) {
        this.elementContainer = elementContainer;
        this.transitions = new HashSet<STransitionDefinition>();
        this.transitionsMap = new HashMap<String, STransitionDefinition>();
        for (TransitionDefinition transition : container.getTransitions()) {
            STransitionDefinitionImpl sTransitionDefinitionImpl = new STransitionDefinitionImpl(transition);
            this.addTransition(sTransitionDefinitionImpl);
        }
        this.allElements = new HashSet<SFlowNodeDefinition>();
        this.allElementsMap = new HashMap<Long, SFlowNodeDefinition>();
        this.allElementsMapString = new HashMap<String, SFlowNodeDefinition>();
        List activities2 = container.getActivities();
        this.sBoundaryEvents = new ArrayList<SBoundaryEventDefinition>();
        this.activities = new HashSet<SActivityDefinition>(activities2.size());
        this.initializeActivities(activities2);
        List gateways2 = container.getGatewaysList();
        this.gateways = new HashSet<SGatewayDefinition>(gateways2.size());
        this.gatewaysMap = new HashMap<String, SGatewayDefinition>(gateways2.size());
        for (GatewayDefinition gatewayDefinition : gateways2) {
            SGatewayDefinitionImpl gateway = new SGatewayDefinitionImpl(gatewayDefinition, this.transitionsMap);
            this.addGateway(gateway);
        }
        List connectors2 = container.getConnectors();
        ArrayList<SConnectorDefinitionImpl> mConnectors = new ArrayList<SConnectorDefinitionImpl>(connectors2.size());
        this.connectorsMap = new HashMap<ConnectorEvent, List<SConnectorDefinition>>(2);
        this.connectorsMap.put(ConnectorEvent.ON_ENTER, new ArrayList());
        this.connectorsMap.put(ConnectorEvent.ON_FINISH, new ArrayList());
        for (ConnectorDefinition connector : connectors2) {
            SConnectorDefinitionImpl e = new SConnectorDefinitionImpl(connector);
            mConnectors.add(e);
            this.connectorsMap.get(e.getActivationEvent()).add(e);
        }
        this.allConnectorsMap = new HashMap<String, SConnectorDefinition>(2);
        this.connectors = Collections.unmodifiableList(mConnectors);
        this.sStartEvents = this.initializeStartEvents(container.getStartEvents(), this.transitionsMap);
        this.sIntermediateCatchEvents = this.initializeIntermediateCatchEvents(container.getIntermediateCatchEvents(), this.transitionsMap);
        this.sIntermediateThrowEvents = this.initializeIntermediateThrowEvents(container.getIntermediateThrowEvents(), this.transitionsMap);
        this.sEndEvents = this.initializeEndEvents(container.getEndEvents(), this.transitionsMap);
        List processDataDefinitions = container.getDataDefinitions();
        ArrayList<SDataDefinition> mDataDefinitions = new ArrayList<SDataDefinition>(processDataDefinitions.size());
        for (DataDefinition dataDefinition : processDataDefinitions) {
            mDataDefinitions.add(ServerModelConvertor.convertDataDefinition(dataDefinition));
        }
        this.sDataDefinitions = Collections.unmodifiableList(mDataDefinitions);
        List documentDefinitions2 = container.getDocumentDefinitions();
        ArrayList<SDocumentDefinitionImpl> mDocumentDefinitions = new ArrayList<SDocumentDefinitionImpl>(documentDefinitions2.size());
        for (DocumentDefinition documentDefinition : documentDefinitions2) {
            mDocumentDefinitions.add(new SDocumentDefinitionImpl(documentDefinition));
        }
        this.sDocumentDefinitions = Collections.unmodifiableList(mDocumentDefinitions);
    }

    private void initializeActivities(List<ActivityDefinition> activities2) {
        for (ActivityDefinition activityDefinition : activities2) {
            SActivityDefinitionImpl activity;
            if (activityDefinition instanceof AutomaticTaskDefinitionImpl) {
                activity = new SAutomaticTaskDefinitionImpl(activityDefinition, this.transitionsMap);
            } else if (activityDefinition instanceof HumanTaskDefinitionImpl) {
                activity = activityDefinition instanceof UserTaskDefinitionImpl ? new SUserTaskDefinitionImpl((UserTaskDefinition)((UserTaskDefinitionImpl)activityDefinition), this.transitionsMap) : new SManualTaskDefinitionImpl((ManualTaskDefinition)((ManualTaskDefinitionImpl)activityDefinition), this.transitionsMap);
                HumanTaskDefinitionImpl humanTaskDefinitionImpl = (HumanTaskDefinitionImpl)activityDefinition;
                UserFilterDefinition userFilter = humanTaskDefinitionImpl.getUserFilter();
                SHumanTaskDefinitionImpl sHumanTaskDefinitionImpl = (SHumanTaskDefinitionImpl)activity;
                if (userFilter != null) {
                    sHumanTaskDefinitionImpl.setUserFilter(new SUserFilterDefinitionImpl(userFilter));
                }
                sHumanTaskDefinitionImpl.setPriority(humanTaskDefinitionImpl.getPriority());
                sHumanTaskDefinitionImpl.setExpectedDuration(humanTaskDefinitionImpl.getExpectedDuration());
            } else if (activityDefinition instanceof ReceiveTaskDefinitionImpl) {
                activity = new SReceiveTaskDefinitionImpl((ReceiveTaskDefinitionImpl)activityDefinition, this.transitionsMap);
            } else if (activityDefinition instanceof SendTaskDefinitionImpl) {
                activity = new SSendTaskDefinitionImpl((SendTaskDefinitionImpl)activityDefinition, this.transitionsMap);
            } else if (activityDefinition instanceof CallActivityDefinition) {
                activity = new SCallActivityDefinitionImpl((CallActivityDefinition)activityDefinition, this.transitionsMap);
            } else if (activityDefinition instanceof SubProcessDefinition) {
                activity = new SSubProcessDefinitionImpl((SubProcessDefinition)activityDefinition);
            } else {
                throw new BonitaRuntimeException("Can't find the client type for " + activityDefinition.getClass().getName());
            }
            this.addActivity(activity);
        }
    }

    private List<SEndEventDefinition> initializeEndEvents(List<EndEventDefinition> endEvents, Map<String, STransitionDefinition> transitionsMap) {
        ArrayList<SEndEventDefinition> sEndEvents = new ArrayList<SEndEventDefinition>(endEvents.size());
        for (EndEventDefinition endEventDefinition : endEvents) {
            SEndEventDefinitionImpl sEndEvent = new SEndEventDefinitionImpl(endEventDefinition, transitionsMap);
            sEndEvents.add(sEndEvent);
            this.allElements.add(sEndEvent);
            this.allElementsMap.put(sEndEvent.getId(), sEndEvent);
            this.allElementsMapString.put(sEndEvent.getName(), sEndEvent);
        }
        return sEndEvents;
    }

    private List<SStartEventDefinition> initializeStartEvents(List<StartEventDefinition> startEvents, Map<String, STransitionDefinition> transitionsMap) {
        ArrayList<SStartEventDefinition> sStartEvents = new ArrayList<SStartEventDefinition>(startEvents.size());
        for (StartEventDefinition startEventDefinition : startEvents) {
            SStartEventDefinitionImpl sStartEvent = new SStartEventDefinitionImpl(startEventDefinition, transitionsMap);
            sStartEvents.add(sStartEvent);
            this.allElements.add(sStartEvent);
            this.allElementsMap.put(sStartEvent.getId(), sStartEvent);
            this.allElementsMapString.put(sStartEvent.getName(), sStartEvent);
        }
        return sStartEvents;
    }

    private List<SIntermediateCatchEventDefinition> initializeIntermediateCatchEvents(List<IntermediateCatchEventDefinition> intermediateCatchEvents, Map<String, STransitionDefinition> transitionsMap) {
        ArrayList<SIntermediateCatchEventDefinition> sIntermediateCatchEvents = new ArrayList<SIntermediateCatchEventDefinition>(intermediateCatchEvents.size());
        for (IntermediateCatchEventDefinition intermediateCatchEventDefinition : intermediateCatchEvents) {
            SIntermediateCatchEventDefinitionImpl sIntermediateCatchEvent = new SIntermediateCatchEventDefinitionImpl((CatchEventDefinition)intermediateCatchEventDefinition, transitionsMap);
            sIntermediateCatchEvents.add(sIntermediateCatchEvent);
            this.allElements.add(sIntermediateCatchEvent);
            this.allElementsMap.put(sIntermediateCatchEvent.getId(), sIntermediateCatchEvent);
            this.allElementsMapString.put(sIntermediateCatchEvent.getName(), sIntermediateCatchEvent);
        }
        return sIntermediateCatchEvents;
    }

    private List<SIntermediateThrowEventDefinition> initializeIntermediateThrowEvents(List<IntermediateThrowEventDefinition> intermediateThrowEvents, Map<String, STransitionDefinition> transitionsMap) {
        ArrayList<SIntermediateThrowEventDefinition> sIntermediateThrowEvents = new ArrayList<SIntermediateThrowEventDefinition>(intermediateThrowEvents.size());
        for (IntermediateThrowEventDefinition intermediateThrowEventDefinition : intermediateThrowEvents) {
            SIntermediateThrowEventDefinitionImpl sIntermediateThrowEvent = new SIntermediateThrowEventDefinitionImpl((ThrowEventDefinition)intermediateThrowEventDefinition, transitionsMap);
            sIntermediateThrowEvents.add(sIntermediateThrowEvent);
            this.allElements.add(sIntermediateThrowEvent);
            this.allElementsMap.put(sIntermediateThrowEvent.getId(), sIntermediateThrowEvent);
            this.allElementsMapString.put(sIntermediateThrowEvent.getName(), sIntermediateThrowEvent);
        }
        return sIntermediateThrowEvents;
    }

    public void addTransition(STransitionDefinition transition) {
        this.transitions.add(transition);
        this.transitionsMap.put(transition.getName(), transition);
    }

    public void addActivity(SActivityDefinition activity) {
        this.sBoundaryEvents.addAll(activity.getBoundaryEventDefinitions());
        for (SBoundaryEventDefinition boundary : activity.getBoundaryEventDefinitions()) {
            this.sBoundaryEvents.add(boundary);
            this.allElements.add(boundary);
            this.allElementsMap.put(boundary.getId(), boundary);
        }
        this.activities.add(activity);
        this.allElements.add(activity);
        this.allElementsMap.put(activity.getId(), activity);
        this.allElementsMapString.put(activity.getName(), activity);
    }

    public void addGateway(SGatewayDefinition gateway) {
        this.gateways.add(gateway);
        if (gateway.getGatewayType() == SGatewayType.INCLUSIVE) {
            this.containsInclusiveGateway = true;
        }
        this.gatewaysMap.put(gateway.getName(), gateway);
        this.allElements.add(gateway);
        this.allElementsMap.put(gateway.getId(), gateway);
        this.allElementsMapString.put(gateway.getName(), gateway);
    }

    public void addConnector(SConnectorDefinition sConnectorDefinition) {
        this.connectors.add(sConnectorDefinition);
        this.connectorsMap.get(sConnectorDefinition.getActivationEvent()).add(sConnectorDefinition);
        this.allConnectorsMap.put(sConnectorDefinition.getName(), sConnectorDefinition);
    }

    public void addStartEvent(SStartEventDefinition startEvent) {
        this.sStartEvents.add(startEvent);
        this.allElements.add(startEvent);
        this.allElementsMap.put(startEvent.getId(), startEvent);
        this.allElementsMapString.put(startEvent.getName(), startEvent);
    }

    public void addIntemediateCatchEvent(SIntermediateCatchEventDefinition event) {
        this.sIntermediateCatchEvents.add(event);
        this.allElements.add(event);
        this.allElementsMap.put(event.getId(), event);
        this.allElementsMapString.put(event.getName(), event);
    }

    public void addEndEvent(SEndEventDefinition endEvent) {
        this.sEndEvents.add(endEvent);
        this.allElements.add(endEvent);
        this.allElementsMap.put(endEvent.getId(), endEvent);
        this.allElementsMapString.put(endEvent.getName(), endEvent);
    }

    public void addIntermediateThrowEvent(SIntermediateThrowEventDefinition intermediateThrowEvent) {
        this.sIntermediateThrowEvents.add(intermediateThrowEvent);
        this.allElements.add(intermediateThrowEvent);
        this.allElementsMap.put(intermediateThrowEvent.getId(), intermediateThrowEvent);
        this.allElementsMapString.put(intermediateThrowEvent.getName(), intermediateThrowEvent);
    }

    public void addDataDefinition(SDataDefinition dataDefinition) {
        this.sDataDefinitions.add(dataDefinition);
    }

    @Override
    public Set<SGatewayDefinition> getGateways() {
        return this.gateways;
    }

    @Override
    public SGatewayDefinition getGateway(String name) {
        SGatewayDefinition sGatewayDefinition = this.gatewaysMap.get(name);
        if (sGatewayDefinition == null) {
            sGatewayDefinition = this.getGatewayFromSubProcesses(name);
        }
        return sGatewayDefinition;
    }

    private SGatewayDefinition getGatewayFromSubProcesses(String name) {
        boolean found = false;
        SGatewayDefinition gateway = null;
        Iterator<SActivityDefinition> iterator = this.activities.iterator();
        while (iterator.hasNext() && !found) {
            SActivityDefinition activityDefinition = iterator.next();
            if (!SFlowNodeType.SUB_PROCESS.equals((Object)activityDefinition.getType()) || (gateway = ((SSubProcessDefinition)activityDefinition).getSubProcessContainer().getGateway(name)) == null) continue;
            found = true;
        }
        return gateway;
    }

    @Override
    public Set<SFlowNodeDefinition> getFlowNodes() {
        return this.allElements;
    }

    @Override
    public SFlowNodeDefinition getFlowNode(long id) {
        SFlowNodeDefinition flowNodeDefinition = this.allElementsMap.get(id);
        if (flowNodeDefinition == null) {
            flowNodeDefinition = this.getFlowNodeFromSubProcesses(id);
        }
        return flowNodeDefinition;
    }

    @Override
    public SFlowNodeDefinition getFlowNode(String targetFlowNode) {
        SFlowNodeDefinition flowNodeDefinition = this.allElementsMapString.get(targetFlowNode);
        if (flowNodeDefinition == null) {
            flowNodeDefinition = this.getFlowNodeFromSubProcesses(targetFlowNode);
        }
        return flowNodeDefinition;
    }

    private SFlowNodeDefinition getFlowNodeFromSubProcesses(long id) {
        boolean found = false;
        SFlowNodeDefinition flowNode = null;
        Iterator<SActivityDefinition> iterator = this.activities.iterator();
        while (iterator.hasNext() && !found) {
            SActivityDefinition activityDefinition = iterator.next();
            if (!SFlowNodeType.SUB_PROCESS.equals((Object)activityDefinition.getType()) || (flowNode = ((SSubProcessDefinition)activityDefinition).getSubProcessContainer().getFlowNode(id)) == null) continue;
            found = true;
        }
        return flowNode;
    }

    private SFlowNodeDefinition getFlowNodeFromSubProcesses(String targetFlowNode) {
        boolean found = false;
        SFlowNodeDefinition flowNode = null;
        Iterator<SActivityDefinition> iterator = this.activities.iterator();
        while (iterator.hasNext() && !found) {
            SActivityDefinition activityDefinition = iterator.next();
            if (!SFlowNodeType.SUB_PROCESS.equals((Object)activityDefinition.getType()) || (flowNode = ((SSubProcessDefinition)activityDefinition).getSubProcessContainer().getFlowNode(targetFlowNode)) == null) continue;
            found = true;
        }
        return flowNode;
    }

    @Override
    public STransitionDefinition getTransition(String name) {
        STransitionDefinition transitionDefinition = this.transitionsMap.get(name);
        if (transitionDefinition == null) {
            transitionDefinition = this.getTransitionFromSubProcesses(name);
        }
        return transitionDefinition;
    }

    private STransitionDefinition getTransitionFromSubProcesses(String name) {
        boolean found = false;
        STransitionDefinition transition = null;
        Iterator<SActivityDefinition> iterator = this.activities.iterator();
        while (iterator.hasNext() && !found) {
            SActivityDefinition activityDefinition = iterator.next();
            if (!SFlowNodeType.SUB_PROCESS.equals((Object)activityDefinition.getType()) || (transition = ((SSubProcessDefinition)activityDefinition).getSubProcessContainer().getTransition(name)) == null) continue;
            found = true;
        }
        return transition;
    }

    @Override
    public List<SConnectorDefinition> getConnectors() {
        return this.connectors;
    }

    @Override
    public SConnectorDefinition getConnectorDefinition(String name) {
        return this.allConnectorsMap.get(name);
    }

    @Override
    public List<SConnectorDefinition> getConnectors(ConnectorEvent connectorEvent) {
        return this.connectorsMap.get(connectorEvent);
    }

    @Override
    public List<SStartEventDefinition> getStartEvents() {
        return this.sStartEvents;
    }

    @Override
    public List<SIntermediateCatchEventDefinition> getIntermediateCatchEvents() {
        return this.sIntermediateCatchEvents;
    }

    @Override
    public List<SEndEventDefinition> getEndEvents() {
        return this.sEndEvents;
    }

    @Override
    public List<SDataDefinition> getDataDefinitions() {
        return this.sDataDefinitions;
    }

    @Override
    public List<SIntermediateThrowEventDefinition> getIntermdiateThrowEvents() {
        return Collections.unmodifiableList(this.sIntermediateThrowEvents);
    }

    @Override
    public List<SDocumentDefinition> getDocumentDefinitions() {
        return this.sDocumentDefinitions;
    }

    public void addDocumentDefinition(SDocumentDefinition documentDefinition) {
        this.sDocumentDefinitions.add(documentDefinition);
    }

    @Override
    public Set<SActivityDefinition> getActivities() {
        return this.activities;
    }

    @Override
    public Set<STransitionDefinition> getTransitions() {
        return this.transitions;
    }

    @Override
    public SNamedElement getElementContainer() {
        return this.elementContainer;
    }

    public void setElementContainer(SNamedElement elementContainer) {
        this.elementContainer = elementContainer;
    }

    @Override
    public List<SBoundaryEventDefinition> getBoundaryEvents() {
        return Collections.unmodifiableList(this.sBoundaryEvents);
    }

    @Override
    public SBoundaryEventDefinition getBoundaryEvent(String name) {
        boolean found = false;
        SBoundaryEventDefinition boundaryEvent = null;
        Iterator<SBoundaryEventDefinition> iterator = this.sBoundaryEvents.iterator();
        while (iterator.hasNext() && !found) {
            SBoundaryEventDefinition currentBoundaryEvent = iterator.next();
            if (!currentBoundaryEvent.getName().equals(name)) continue;
            found = true;
            boundaryEvent = currentBoundaryEvent;
        }
        return boundaryEvent;
    }

    @Override
    public boolean containsInclusiveGateway() {
        return this.containsInclusiveGateway;
    }
}

