/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.core.process.instance.impl;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.process.instance.api.FlowNodeInstanceService;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SFlowNodeDeletionException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SFlowNodeModificationException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SFlowNodeNotFoundException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SFlowNodeReadException;
import org.bonitasoft.engine.core.process.instance.api.states.FlowNodeState;
import org.bonitasoft.engine.core.process.instance.model.SFlowElementInstance;
import org.bonitasoft.engine.core.process.instance.model.SFlowNodeInstance;
import org.bonitasoft.engine.core.process.instance.model.SStateCategory;
import org.bonitasoft.engine.core.process.instance.model.STaskPriority;
import org.bonitasoft.engine.core.process.instance.model.archive.SAFlowNodeInstance;
import org.bonitasoft.engine.core.process.instance.model.builder.SFlowNodeInstanceLogBuilder;
import org.bonitasoft.engine.core.process.instance.model.builder.SFlowNodeInstanceLogBuilderFactory;
import org.bonitasoft.engine.core.process.instance.model.builder.SUserTaskInstanceBuilderFactory;
import org.bonitasoft.engine.core.process.instance.recorder.SelectDescriptorBuilder;
import org.bonitasoft.engine.events.EventActionType;
import org.bonitasoft.engine.events.EventService;
import org.bonitasoft.engine.events.model.SDeleteEvent;
import org.bonitasoft.engine.events.model.SUpdateEvent;
import org.bonitasoft.engine.events.model.builders.SEventBuilderFactory;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.persistence.PersistentObject;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.persistence.ReadPersistenceService;
import org.bonitasoft.engine.persistence.SBonitaReadException;
import org.bonitasoft.engine.persistence.SBonitaSearchException;
import org.bonitasoft.engine.persistence.SelectListDescriptor;
import org.bonitasoft.engine.queriablelogger.model.SQueriableLogSeverity;
import org.bonitasoft.engine.queriablelogger.model.builder.ActionType;
import org.bonitasoft.engine.queriablelogger.model.builder.HasCRUDEAction;
import org.bonitasoft.engine.queriablelogger.model.builder.SLogBuilder;
import org.bonitasoft.engine.recorder.Recorder;
import org.bonitasoft.engine.recorder.SRecorderException;
import org.bonitasoft.engine.recorder.model.DeleteRecord;
import org.bonitasoft.engine.recorder.model.EntityUpdateDescriptor;
import org.bonitasoft.engine.recorder.model.UpdateRecord;
import org.bonitasoft.engine.services.QueriableLoggerService;

public abstract class FlowNodeInstanceServiceImpl
implements FlowNodeInstanceService {
    private final SUserTaskInstanceBuilderFactory activityInstanceKeyProvider;
    private final EventService eventService;
    private final Recorder recorder;
    private final ReadPersistenceService persistenceRead;
    private final TechnicalLoggerService logger;

    public FlowNodeInstanceServiceImpl(Recorder recorder, ReadPersistenceService persistenceRead, EventService eventService, QueriableLoggerService queriableLoggerService, TechnicalLoggerService logger) {
        this.recorder = recorder;
        this.persistenceRead = persistenceRead;
        this.logger = logger;
        this.activityInstanceKeyProvider = BuilderFactory.get(SUserTaskInstanceBuilderFactory.class);
        this.eventService = eventService;
    }

    protected <T extends SLogBuilder> void initializeLogBuilder(T logBuilder, String message) {
        logBuilder.actionStatus(0).severity(SQueriableLogSeverity.INTERNAL).rawMessage(message);
    }

    protected <T extends HasCRUDEAction> void updateLog(ActionType actionType, T logBuilder) {
        logBuilder.setActionType(actionType);
    }

    protected SFlowNodeInstanceLogBuilder getQueriableLog(ActionType actionType, String message, SFlowElementInstance flowElementInstance) {
        SFlowNodeInstanceLogBuilder logBuilder = BuilderFactory.get(SFlowNodeInstanceLogBuilderFactory.class).createNewInstance();
        this.initializeLogBuilder(logBuilder, message);
        this.updateLog(actionType, logBuilder);
        logBuilder.processInstanceId(flowElementInstance.getRootContainerId());
        return logBuilder;
    }

    @Override
    public void setState(SFlowNodeInstance flowNodeInstance, FlowNodeState state) throws SFlowNodeModificationException {
        long now = System.currentTimeMillis();
        EntityUpdateDescriptor descriptor = new EntityUpdateDescriptor();
        descriptor.addField(this.activityInstanceKeyProvider.getPreviousStateIdKey(), flowNodeInstance.getStateId());
        descriptor.addField(this.activityInstanceKeyProvider.getStateIdKey(), state.getId());
        descriptor.addField(this.activityInstanceKeyProvider.getStateNameKey(), state.getName());
        descriptor.addField(this.activityInstanceKeyProvider.getStableKey(), state.isStable());
        descriptor.addField(this.activityInstanceKeyProvider.getTerminalKey(), state.isTerminal());
        descriptor.addField(this.activityInstanceKeyProvider.getReachStateDateKey(), now);
        descriptor.addField(this.activityInstanceKeyProvider.getLastUpdateDateKey(), now);
        descriptor.addField(this.activityInstanceKeyProvider.getStateExecutingKey(), false);
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.DEBUG)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.DEBUG, MessageFormat.format("[{0} with id {1}] changed state {2}->{3}(new={4})", flowNodeInstance.getClass().getSimpleName(), flowNodeInstance.getId(), flowNodeInstance.getStateId(), state.getId(), state.getClass().getSimpleName()));
        }
        UpdateRecord updateRecord = UpdateRecord.buildSetFields((PersistentObject)flowNodeInstance, descriptor);
        SUpdateEvent updateEvent = (SUpdateEvent)BuilderFactory.get(SEventBuilderFactory.class).createUpdateEvent("ACTIVITYINSTANCE_STATE").setObject(flowNodeInstance).done();
        try {
            this.recorder.recordUpdate(updateRecord, updateEvent);
        }
        catch (SRecorderException e) {
            throw new SFlowNodeModificationException(e);
        }
    }

    @Override
    public void setExecuting(SFlowNodeInstance flowNodeInstance) throws SFlowNodeModificationException {
        long now = System.currentTimeMillis();
        EntityUpdateDescriptor descriptor = new EntityUpdateDescriptor();
        descriptor.addField(this.activityInstanceKeyProvider.getStateExecutingKey(), true);
        descriptor.addField(this.activityInstanceKeyProvider.getLastUpdateDateKey(), now);
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.DEBUG)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.DEBUG, MessageFormat.format("[{0} with id {1}] have executing flag set to true", flowNodeInstance.getClass().getSimpleName(), flowNodeInstance.getId()));
        }
        UpdateRecord updateRecord = UpdateRecord.buildSetFields((PersistentObject)flowNodeInstance, descriptor);
        SUpdateEvent updateEvent = (SUpdateEvent)BuilderFactory.get(SEventBuilderFactory.class).createUpdateEvent("ACTIVITYINSTANCE_STATE").setObject(flowNodeInstance).done();
        try {
            this.recorder.recordUpdate(updateRecord, updateEvent);
        }
        catch (SRecorderException e) {
            throw new SFlowNodeModificationException(e);
        }
    }

    @Override
    public void updateDisplayName(SFlowNodeInstance flowNodeInstance, String displayName) throws SFlowNodeModificationException {
        if (displayName != null && !displayName.equals(flowNodeInstance.getDisplayName())) {
            String event = "ACTIVITYINSTANCE_DISPLAY_NAME";
            String key = this.activityInstanceKeyProvider.getDisplayNameKey();
            this.updateOneField(flowNodeInstance, displayName, "ACTIVITYINSTANCE_DISPLAY_NAME", key);
        }
    }

    private void updateOneField(SFlowNodeInstance flowNodeInstance, String displayDescription, String event, String lastUpdateKey) throws SFlowNodeModificationException {
        EntityUpdateDescriptor descriptor = new EntityUpdateDescriptor();
        descriptor.addField(lastUpdateKey, displayDescription);
        UpdateRecord updateRecord = UpdateRecord.buildSetFields((PersistentObject)flowNodeInstance, descriptor);
        SUpdateEvent updateEvent = (SUpdateEvent)BuilderFactory.get(SEventBuilderFactory.class).createUpdateEvent(event).setObject(flowNodeInstance).done();
        try {
            this.recorder.recordUpdate(updateRecord, updateEvent);
        }
        catch (SRecorderException e) {
            throw new SFlowNodeModificationException(e);
        }
    }

    @Override
    public void updateDisplayDescription(SFlowNodeInstance flowNodeInstance, String displayDescription) throws SFlowNodeModificationException {
        if (displayDescription != null && !displayDescription.equals(flowNodeInstance.getDisplayDescription())) {
            String event = "ACTIVITYINSTANCE_DISPLAY_DESCRIPTION";
            String key = this.activityInstanceKeyProvider.getDisplayDescriptionKey();
            this.updateOneField(flowNodeInstance, displayDescription, "ACTIVITYINSTANCE_DISPLAY_DESCRIPTION", key);
        }
    }

    @Override
    public void setTaskPriority(SFlowNodeInstance flowNodeInstance, STaskPriority priority) throws SFlowNodeModificationException {
        EntityUpdateDescriptor descriptor = new EntityUpdateDescriptor();
        descriptor.addField(this.activityInstanceKeyProvider.getPriorityKey(), priority);
        UpdateRecord updateRecord = UpdateRecord.buildSetFields((PersistentObject)flowNodeInstance, descriptor);
        SUpdateEvent updateEvent = (SUpdateEvent)BuilderFactory.get(SEventBuilderFactory.class).createUpdateEvent("ACTIVITYINSTANCE_STATE").setObject(flowNodeInstance).done();
        try {
            this.recorder.recordUpdate(updateRecord, updateEvent);
        }
        catch (SRecorderException e) {
            throw new SFlowNodeModificationException(e);
        }
    }

    @Override
    public List<SFlowNodeInstance> getActiveFlowNodes(long rootContainerId) throws SFlowNodeReadException {
        try {
            SelectListDescriptor<SFlowNodeInstance> selectListDescriptor = SelectDescriptorBuilder.getActiveFlowNodes(rootContainerId);
            return this.persistenceRead.selectList(selectListDescriptor);
        }
        catch (SBonitaReadException bre) {
            throw new SFlowNodeReadException(bre);
        }
    }

    @Override
    public SFlowNodeInstance getFlowNodeInstance(long flowNodeInstanceId) throws SFlowNodeNotFoundException, SFlowNodeReadException {
        SFlowNodeInstance selectOne;
        try {
            selectOne = this.persistenceRead.selectById(SelectDescriptorBuilder.getElementById(SFlowNodeInstance.class, "SFlowNodeInstance", flowNodeInstanceId));
        }
        catch (SBonitaReadException e) {
            throw new SFlowNodeReadException(e);
        }
        if (selectOne == null) {
            throw new SFlowNodeNotFoundException(flowNodeInstanceId);
        }
        return selectOne;
    }

    @Override
    public List<SFlowNodeInstance> getFlowNodeInstances(long rootContainerId, int fromIndex, int maxResults) throws SFlowNodeReadException {
        List<SFlowNodeInstance> selectList;
        try {
            selectList = this.getPersistenceRead().selectList(SelectDescriptorBuilder.getFlowNodesFromProcessInstance(rootContainerId, fromIndex, maxResults));
        }
        catch (SBonitaReadException e) {
            throw new SFlowNodeReadException(e);
        }
        return this.getUnmodifiableList(selectList);
    }

    @Override
    public List<SAFlowNodeInstance> getArchivedFlowNodeInstances(long rootContainerId, int fromIndex, int maxResults) throws SFlowNodeReadException {
        List<SAFlowNodeInstance> selectList;
        try {
            selectList = this.getPersistenceRead().selectList(SelectDescriptorBuilder.getArchivedFlowNodesFromProcessInstance(rootContainerId, fromIndex, maxResults));
        }
        catch (SBonitaReadException e) {
            throw new SFlowNodeReadException(e);
        }
        return this.getUnmodifiableList(selectList);
    }

    @Override
    public SAFlowNodeInstance getArchivedFlowNodeInstance(long archivedFlowNodeInstanceId, ReadPersistenceService persistenceService) throws SFlowNodeReadException, SFlowNodeNotFoundException {
        SAFlowNodeInstance selectOne;
        try {
            selectOne = persistenceService.selectById(SelectDescriptorBuilder.getElementById(SAFlowNodeInstance.class, "SArchivedFlowNodeInstance", archivedFlowNodeInstanceId));
        }
        catch (SBonitaReadException e) {
            throw new SFlowNodeReadException(e);
        }
        if (selectOne == null) {
            throw new SFlowNodeNotFoundException(archivedFlowNodeInstanceId);
        }
        return selectOne;
    }

    @Override
    public void setStateCategory(SFlowElementInstance flowElementInstance, SStateCategory stateCategory) throws SFlowNodeModificationException {
        EntityUpdateDescriptor descriptor = new EntityUpdateDescriptor();
        descriptor.addField(this.activityInstanceKeyProvider.getStateCategoryKey(), (Object)stateCategory);
        UpdateRecord updateRecord = UpdateRecord.buildSetFields((PersistentObject)flowElementInstance, descriptor);
        SUpdateEvent updateEvent = (SUpdateEvent)BuilderFactory.get(SEventBuilderFactory.class).createUpdateEvent("STATE_CATEGORY").setObject(flowElementInstance).done();
        try {
            this.getRecorder().recordUpdate(updateRecord, updateEvent);
        }
        catch (SRecorderException sre) {
            throw new SFlowNodeModificationException(sre);
        }
    }

    @Override
    public void setExecutedBy(SFlowNodeInstance flowNodeInstance, long userId) throws SFlowNodeModificationException {
        EntityUpdateDescriptor descriptor = new EntityUpdateDescriptor();
        descriptor.addField(this.activityInstanceKeyProvider.getExecutedBy(), userId);
        this.updateFlowNode(flowNodeInstance, "EXECUTED_BY_MODIFIED", descriptor);
    }

    @Override
    public void setExecutedByDelegate(SFlowNodeInstance flowNodeInstance, long executerDelegateId) throws SFlowNodeModificationException {
        EntityUpdateDescriptor descriptor = new EntityUpdateDescriptor();
        descriptor.addField(this.activityInstanceKeyProvider.getExecutedByDelegate(), executerDelegateId);
        this.updateFlowNode(flowNodeInstance, "EXECUTED_BY_DELEGATE_MODIFIED", descriptor);
    }

    @Override
    public void setExpectedEndDate(SFlowNodeInstance flowNodeInstance, long dueDate) throws SFlowNodeModificationException {
        EntityUpdateDescriptor descriptor = new EntityUpdateDescriptor();
        descriptor.addField(this.activityInstanceKeyProvider.getExpectedEndDateKey(), dueDate);
        this.updateFlowNode(flowNodeInstance, "EXPECTED_END_DATE_MODIFIED", descriptor);
    }

    protected void updateFlowNode(SFlowNodeInstance flowNodeInstance, String eventName, EntityUpdateDescriptor descriptor) throws SFlowNodeModificationException {
        UpdateRecord updateRecord = UpdateRecord.buildSetFields((PersistentObject)flowNodeInstance, descriptor);
        SUpdateEvent updateEvent = (SUpdateEvent)BuilderFactory.get(SEventBuilderFactory.class).createUpdateEvent(eventName).setObject(flowNodeInstance).done();
        try {
            this.getRecorder().recordUpdate(updateRecord, updateEvent);
        }
        catch (SRecorderException sre) {
            throw new SFlowNodeModificationException(sre);
        }
    }

    protected <T> List<T> getUnmodifiableList(List<T> selectList) {
        if (selectList == null) {
            selectList = new ArrayList<T>();
        }
        return Collections.unmodifiableList(selectList);
    }

    @Override
    public long getNumberOfFlowNodeInstances(Class<? extends PersistentObject> entityClass, QueryOptions countOptions) throws SBonitaSearchException {
        try {
            return this.getPersistenceRead().getNumberOfEntities(entityClass, countOptions, null);
        }
        catch (SBonitaReadException e) {
            throw new SBonitaSearchException(e);
        }
    }

    @Override
    public List<SFlowNodeInstance> searchFlowNodeInstances(Class<? extends PersistentObject> entityClass, QueryOptions searchOptions) throws SBonitaSearchException {
        try {
            return this.getPersistenceRead().searchEntity(entityClass, searchOptions, null);
        }
        catch (SBonitaReadException e) {
            throw new SBonitaSearchException(e);
        }
    }

    @Override
    public long getNumberOfArchivedFlowNodeInstances(Class<? extends SAFlowNodeInstance> entityClass, QueryOptions countOptions) throws SBonitaSearchException {
        try {
            return this.getPersistenceRead().getNumberOfEntities(entityClass, countOptions, null);
        }
        catch (SBonitaReadException e) {
            throw new SBonitaSearchException(e);
        }
    }

    @Override
    public List<SAFlowNodeInstance> searchArchivedFlowNodeInstances(Class<? extends SAFlowNodeInstance> entityClass, QueryOptions searchOptions) throws SBonitaSearchException {
        try {
            return this.getPersistenceRead().searchEntity(entityClass, searchOptions, null);
        }
        catch (SBonitaReadException e) {
            throw new SBonitaSearchException(e);
        }
    }

    protected EventService getEventService() {
        return this.eventService;
    }

    protected Recorder getRecorder() {
        return this.recorder;
    }

    protected ReadPersistenceService getPersistenceRead() {
        return this.persistenceRead;
    }

    protected TechnicalLoggerService getLogger() {
        return this.logger;
    }

    @Override
    public void deleteFlowNodeInstance(SFlowNodeInstance sFlowNodeInstance) throws SFlowNodeReadException, SFlowNodeDeletionException {
        try {
            DeleteRecord deleteRecord = new DeleteRecord(sFlowNodeInstance);
            SDeleteEvent deleteEvent = null;
            if (this.eventService.hasHandlers("FLOWNODE_INSTANCE", EventActionType.DELETED)) {
                deleteEvent = (SDeleteEvent)BuilderFactory.get(SEventBuilderFactory.class).createDeleteEvent("FLOWNODE_INSTANCE").setObject(sFlowNodeInstance).done();
            }
            this.recorder.recordDelete(deleteRecord, deleteEvent);
        }
        catch (SBonitaException e) {
            throw new SFlowNodeDeletionException(e);
        }
    }

    @Override
    public void deleteArchivedFlowNodeInstance(SAFlowNodeInstance saFlowNodeInstance) throws SFlowNodeReadException, SFlowNodeDeletionException {
        DeleteRecord deleteRecord = new DeleteRecord(saFlowNodeInstance);
        SDeleteEvent deleteEvent = null;
        if (this.eventService.hasHandlers("ARCHIVED_FLOWNODE_INSTANCE", EventActionType.DELETED)) {
            deleteEvent = (SDeleteEvent)BuilderFactory.get(SEventBuilderFactory.class).createDeleteEvent("ARCHIVED_FLOWNODE_INSTANCE").setObject(saFlowNodeInstance).done();
        }
        try {
            this.recorder.recordDelete(deleteRecord, deleteEvent);
        }
        catch (SRecorderException e) {
            throw new SFlowNodeDeletionException(e);
        }
    }

    @Override
    public List<SFlowNodeInstance> getFlowNodeInstancesToRestart(QueryOptions queryOptions) throws SFlowNodeReadException {
        List selectList;
        try {
            HashMap<String, Object> parameters = new HashMap<String, Object>(1);
            selectList = this.getPersistenceRead().selectList(new SelectListDescriptor("getFlowNodeInstancesToRestart", parameters, SFlowNodeInstance.class, queryOptions));
        }
        catch (SBonitaReadException e) {
            throw new SFlowNodeReadException(e);
        }
        return this.getUnmodifiableList(selectList);
    }
}

