/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.execution.state;

import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.process.definition.model.SProcessDefinition;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SActivityExecutionException;
import org.bonitasoft.engine.core.process.instance.api.states.FlowNodeState;
import org.bonitasoft.engine.core.process.instance.api.states.StateCode;
import org.bonitasoft.engine.core.process.instance.model.SFlowNodeInstance;
import org.bonitasoft.engine.core.process.instance.model.SHumanTaskInstance;
import org.bonitasoft.engine.core.process.instance.model.SStateCategory;
import org.bonitasoft.engine.execution.StateBehaviors;

public class CompletingSubTaskStateImpl
implements FlowNodeState {
    private final StateBehaviors stateBehaviors;

    public CompletingSubTaskStateImpl(StateBehaviors stateBehaviors) {
        this.stateBehaviors = stateBehaviors;
    }

    @Override
    public StateCode execute(SProcessDefinition processDefinition, SFlowNodeInstance flowNodeInstance) {
        return StateCode.DONE;
    }

    @Override
    public int getId() {
        return 13;
    }

    @Override
    public boolean isInterrupting() {
        return false;
    }

    @Override
    public boolean isStable() {
        return true;
    }

    @Override
    public boolean isTerminal() {
        return false;
    }

    @Override
    public String getName() {
        return "cancelling subtasks";
    }

    @Override
    public boolean hit(SProcessDefinition processDefinition, SFlowNodeInstance parentInstance, SFlowNodeInstance childInstance) {
        SHumanTaskInstance sHumanTaskInstance = (SHumanTaskInstance)parentInstance;
        return sHumanTaskInstance.getTokenCount() == 0;
    }

    @Override
    public boolean shouldExecuteState(SProcessDefinition processDefinition, SFlowNodeInstance flowNodeInstance) throws SActivityExecutionException {
        SHumanTaskInstance sHumanTaskInstance = (SHumanTaskInstance)flowNodeInstance;
        if (sHumanTaskInstance.getTokenCount() > 0) {
            try {
                this.stateBehaviors.interruptSubActivities(flowNodeInstance.getId(), SStateCategory.ABORTING);
            }
            catch (SBonitaException e) {
                throw new SActivityExecutionException(e);
            }
        }
        return sHumanTaskInstance.getTokenCount() > 0;
    }

    @Override
    public SStateCategory getStateCategory() {
        return SStateCategory.NORMAL;
    }

    @Override
    public boolean mustAddSystemComment(SFlowNodeInstance flowNodeInstance) {
        return false;
    }

    @Override
    public String getSystemComment(SFlowNodeInstance flowNodeInstance) {
        return "";
    }
}

