/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.expression.impl;

import groovy.lang.Binding;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.GroovyShell;
import groovy.lang.MissingPropertyException;
import groovy.lang.Script;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.cache.CacheException;
import org.bonitasoft.engine.cache.CacheService;
import org.bonitasoft.engine.classloader.ClassLoaderException;
import org.bonitasoft.engine.classloader.ClassLoaderService;
import org.bonitasoft.engine.expression.NonEmptyContentExpressionExecutorStrategy;
import org.bonitasoft.engine.expression.exception.SExpressionEvaluationException;
import org.bonitasoft.engine.expression.model.ExpressionKind;
import org.bonitasoft.engine.expression.model.SExpression;

public class GroovyScriptExpressionExecutorCacheStrategy
extends NonEmptyContentExpressionExecutorStrategy {
    private static final String GROOVY_SCRIPT_CACHE_NAME = "GROOVY_SCRIPT_CACHE_NAME";
    private static final String SCRIPT_KEY = "SCRIPT_";
    private static final String SHELL_KEY = "SHELL_";
    private final CacheService cacheService;
    private final ClassLoaderService classLoaderService;

    public GroovyScriptExpressionExecutorCacheStrategy(CacheService cacheService, ClassLoaderService classLoaderService) {
        this.cacheService = cacheService;
        this.classLoaderService = classLoaderService;
    }

    private Script getScriptFromCache(String expressionContent, Long definitionId) throws CacheException, ClassLoaderException {
        GroovyShell shell = this.getShell(definitionId);
        String key = Thread.currentThread().getId() + SCRIPT_KEY + definitionId + expressionContent.hashCode();
        Script script = (Script)this.cacheService.get(GROOVY_SCRIPT_CACHE_NAME, key);
        if (script == null) {
            script = shell.parse(expressionContent);
            this.cacheService.store(GROOVY_SCRIPT_CACHE_NAME, (Serializable)((Object)key), script);
        }
        return script;
    }

    private GroovyShell getShell(Long definitionId) throws ClassLoaderException, CacheException {
        String key = SHELL_KEY + definitionId;
        GroovyShell shell = (GroovyShell)this.cacheService.get(GROOVY_SCRIPT_CACHE_NAME, key);
        if (shell == null) {
            ClassLoader classLoader = definitionId != null ? this.classLoaderService.getLocalClassLoader("process", definitionId) : Thread.currentThread().getContextClassLoader();
            shell = new GroovyShell(classLoader);
            this.cacheService.store(GROOVY_SCRIPT_CACHE_NAME, (Serializable)((Object)key), shell);
        }
        return shell;
    }

    @Override
    public Object evaluate(SExpression expression, Map<String, Object> dependencyValues, Map<Integer, Object> resolvedExpressions) throws SExpressionEvaluationException {
        String expressionContent = expression.getContent();
        try {
            Script script = this.getScriptFromCache(expressionContent, (Long)dependencyValues.get("processDefinitionId"));
            Binding binding = new Binding(dependencyValues);
            script.setBinding(binding);
            return script.run();
        }
        catch (MissingPropertyException e) {
            String property = e.getProperty();
            StringBuilder builder = new StringBuilder("Expression ");
            builder.append(expression.getName()).append(" with content: ").append(expressionContent).append(" depends on ").append(property).append(" is neither defined in the script nor in dependencies");
            throw new SExpressionEvaluationException(builder.toString(), e);
        }
        catch (GroovyRuntimeException e) {
            throw new SExpressionEvaluationException(e);
        }
        catch (CacheException e) {
            throw new SExpressionEvaluationException("Problem accessing the Script Cache from GroovyScriptExpressionExecutorCacheStrategy", e);
        }
        catch (ClassLoaderException e) {
            throw new SExpressionEvaluationException("Unable to retrieve the correct classloader to execute the groovy script: " + expression, e);
        }
        catch (Throwable e) {
            throw new SExpressionEvaluationException("Script throws an exception" + expression, e);
        }
    }

    @Override
    public ExpressionKind getExpressionKind() {
        return KIND_READ_ONLY_SCRIPT_GROOVY;
    }

    @Override
    public List<Object> evaluate(List<SExpression> expressions, Map<String, Object> dependencyValues, Map<Integer, Object> resolvedExpressions) throws SExpressionEvaluationException {
        ArrayList<Object> list = new ArrayList<Object>(expressions.size());
        for (SExpression expression : expressions) {
            list.add(this.evaluate(expression, dependencyValues, resolvedExpressions));
        }
        return list;
    }

    @Override
    public boolean mustPutEvaluatedExpressionInContext() {
        return false;
    }
}

