/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.expression.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.expression.ExpressionExecutorStrategy;
import org.bonitasoft.engine.expression.model.ExpressionKind;
import org.bonitasoft.engine.expression.model.SExpression;

public class ListExpressionExecutorStrategy
implements ExpressionExecutorStrategy {
    @Override
    public void validate(SExpression expression) {
    }

    @Override
    public ExpressionKind getExpressionKind() {
        return KIND_LIST;
    }

    @Override
    public Serializable evaluate(SExpression expression, Map<String, Object> dependencyValues, Map<Integer, Object> resolvedExpressions) {
        ArrayList<Object> result = new ArrayList<Object>(expression.getDependencies().size());
        for (SExpression exp : expression.getDependencies()) {
            result.add(resolvedExpressions.get(exp.getDiscriminant()));
        }
        resolvedExpressions.put(expression.getDiscriminant(), result);
        return result;
    }

    @Override
    public List<Object> evaluate(List<SExpression> expressions, Map<String, Object> dependencyValues, Map<Integer, Object> resolvedExpressions) {
        ArrayList<Object> list = new ArrayList<Object>(expressions.size());
        for (SExpression expression : expressions) {
            list.add(this.evaluate(expression, (Map)dependencyValues, (Map)resolvedExpressions));
        }
        return list;
    }

    @Override
    public boolean mustPutEvaluatedExpressionInContext() {
        return false;
    }
}

