/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.expression.model.builder.impl;

import java.util.List;
import org.bonitasoft.engine.expression.exception.SInvalidExpressionException;
import org.bonitasoft.engine.expression.model.SExpression;
import org.bonitasoft.engine.expression.model.builder.SExpressionBuilder;
import org.bonitasoft.engine.expression.model.impl.SExpressionImpl;

public class SExpressionBuilderImpl
implements SExpressionBuilder {
    private final SExpressionImpl expression;

    public SExpressionBuilderImpl(SExpressionImpl expression) {
        this.expression = expression;
    }

    @Override
    public SExpression done() throws SInvalidExpressionException {
        if (this.expression.getReturnType() == null) {
            throw new SInvalidExpressionException("Expression return type must be set");
        }
        return this.expression;
    }

    @Override
    public SExpressionBuilder setName(String name) {
        this.expression.setName(name);
        return this;
    }

    @Override
    public SExpressionBuilder setContent(String content) {
        this.expression.setContent(content);
        return this;
    }

    @Override
    public SExpressionBuilder setExpressionType(String expressionType) {
        this.expression.setExpressionType(expressionType);
        return this;
    }

    @Override
    public SExpressionBuilder setReturnType(String returnType) {
        this.expression.setReturnType(returnType);
        return this;
    }

    @Override
    public SExpressionBuilder setInterpreter(String interpreter) {
        this.expression.setInterpreter(interpreter);
        return this;
    }

    @Override
    public SExpressionBuilder setDependencies(List<SExpression> dependencies) {
        this.expression.setDependencies(dependencies);
        return this;
    }
}

