/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.external.actor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bonitasoft.engine.actor.mapping.ActorMappingService;
import org.bonitasoft.engine.actor.mapping.model.SActor;
import org.bonitasoft.engine.api.impl.transaction.identity.GetUsersByManager;
import org.bonitasoft.engine.api.impl.transaction.process.GetAllProcessDefinitionsIds;
import org.bonitasoft.engine.command.SCommandExecutionException;
import org.bonitasoft.engine.command.SCommandParameterizationException;
import org.bonitasoft.engine.command.TenantCommand;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.transaction.TransactionContentWithResult;
import org.bonitasoft.engine.core.process.definition.ProcessDefinitionService;
import org.bonitasoft.engine.identity.model.SUser;
import org.bonitasoft.engine.service.TenantServiceAccessor;

public class GetActorIdsForUserIdIncludingTeam
extends TenantCommand {
    private static final String USER_ID_KEY = "USER_ID_KEY";
    private TenantServiceAccessor serviceAccessor;

    @Override
    public Serializable execute(Map<String, Serializable> parameters, TenantServiceAccessor serviceAccessor) throws SCommandParameterizationException, SCommandExecutionException {
        long userId;
        this.serviceAccessor = serviceAccessor;
        Serializable sUserId = parameters.get(USER_ID_KEY);
        try {
            userId = (Long)sUserId;
        }
        catch (Exception e) {
            throw new SCommandParameterizationException("Mandatory parameter USER_ID_KEY is missing or not convertible to long.");
        }
        try {
            return (Serializable)((Object)this.getActorIdsForUserIdIncludingTeam(userId));
        }
        catch (SBonitaException e) {
            throw new SCommandExecutionException("Error executing command 'Map<Long, List<Long>> getActorIdsForUserIdIncludingTeam(long userId)'", e);
        }
    }

    private Map<Long, Set<Long>> getActorIdsForUserIdIncludingTeam(long managerId) throws SBonitaException {
        ProcessDefinitionService processDefinitionService = this.serviceAccessor.getProcessDefinitionService();
        GetUsersByManager getUsersByManager = new GetUsersByManager(this.serviceAccessor.getIdentityService(), managerId);
        getUsersByManager.execute();
        List users = (List)getUsersByManager.getResult();
        ArrayList<Long> userIds = new ArrayList<Long>(users.size() + 1);
        for (SUser sUser : users) {
            userIds.add(sUser.getId());
        }
        userIds.add(managerId);
        HashMap<Long, Set<Long>> map = new HashMap<Long, Set<Long>>();
        GetAllProcessDefinitionsIds getAllPD = new GetAllProcessDefinitionsIds(processDefinitionService);
        getAllPD.execute();
        Object processDefinitionIds = getAllPD.getResult();
        Iterator i$ = processDefinitionIds.iterator();
        while (i$.hasNext()) {
            Long processDefinition = (Long)i$.next();
            HashSet actorIdsForProcessDef = new HashSet();
            Iterator i$2 = userIds.iterator();
            while (i$2.hasNext()) {
                long userId = (Long)i$2.next();
                GetActors getActors = new GetActors(processDefinition, userId, this.serviceAccessor.getActorMappingService());
                getActors.execute();
                Object actorIds = getActors.getResult();
                actorIdsForProcessDef.addAll(actorIds);
            }
            map.put(processDefinition, actorIdsForProcessDef);
        }
        return map;
    }

    class GetActors
    implements TransactionContentWithResult<List<Long>> {
        private final long processDefinitionId;
        private final long userId;
        private final ActorMappingService actorMappingService;
        private List<Long> actorIds = null;

        private GetActors(long processDefinitionId, long userId, ActorMappingService actorMappingService) {
            this.processDefinitionId = processDefinitionId;
            this.userId = userId;
            this.actorMappingService = actorMappingService;
        }

        @Override
        public void execute() throws SBonitaException {
            List<SActor> actors = this.actorMappingService.getActors(Collections.singleton(this.processDefinitionId), this.userId);
            this.actorIds = new ArrayList<Long>(actors.size());
            for (SActor actor : actors) {
                this.actorIds.add(actor.getId());
            }
        }

        @Override
        public List<Long> getResult() {
            return this.actorIds != null ? this.actorIds : Collections.emptyList();
        }
    }
}

