/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.external.identitymapping;

import java.io.Serializable;
import java.util.Map;
import org.bonitasoft.engine.command.SCommandExecutionException;
import org.bonitasoft.engine.command.SCommandParameterizationException;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.external.identity.mapping.model.SExternalIdentityMapping;
import org.bonitasoft.engine.external.identitymapping.EntityMemberCommand;
import org.bonitasoft.engine.identity.MemberType;
import org.bonitasoft.engine.service.TenantServiceAccessor;

public class AddEntityMemberCommand
extends EntityMemberCommand {
    @Override
    public Serializable execute(Map<String, Serializable> parameters, TenantServiceAccessor serviceAccessor) throws SCommandParameterizationException, SCommandExecutionException {
        this.serviceAccessor = serviceAccessor;
        String externalId = this.getStringMandadoryParameter(parameters, "EXTERNAL_ID_KEY");
        String kind = this.getStringMandadoryParameter(parameters, "DISCRIMINATOR_ID_KEY");
        Long userId = this.getUserIdParameter(parameters);
        Long groupId = this.getGroupIdParameter(parameters);
        Long roleId = this.getRoleIdParameter(parameters);
        if (userId == null && groupId == null && roleId == null) {
            throw new SCommandParameterizationException("At least one of the following parameters must be set: userId, groupId, roleId");
        }
        long lUserId = userId != null ? userId : -1L;
        long lGroupId = groupId != null ? groupId : -1L;
        long lRoleId = roleId != null ? roleId : -1L;
        try {
            MemberType memberType = this.getMemberType(userId, groupId, roleId);
            SExternalIdentityMapping mapp = this.addExternalIdentityMapping(externalId, lUserId, lRoleId, lGroupId, kind, memberType);
            return this.toEntityMember(mapp);
        }
        catch (SBonitaException e) {
            throw new SCommandExecutionException("Error executing command 'AddEntityMemberCommand'", e);
        }
    }
}

