/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.identity.xml;

import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.transaction.TransactionContentWithResult;
import org.bonitasoft.engine.identity.ExportedUser;
import org.bonitasoft.engine.identity.Group;
import org.bonitasoft.engine.identity.IdentityService;
import org.bonitasoft.engine.identity.Role;
import org.bonitasoft.engine.identity.SIdentityException;
import org.bonitasoft.engine.identity.UserMembership;
import org.bonitasoft.engine.identity.model.SContactInfo;
import org.bonitasoft.engine.identity.model.SGroup;
import org.bonitasoft.engine.identity.model.SRole;
import org.bonitasoft.engine.identity.model.SUser;
import org.bonitasoft.engine.identity.model.SUserMembership;
import org.bonitasoft.engine.identity.xml.OrganizationNodeBuilder;
import org.bonitasoft.engine.service.ModelConvertor;
import org.bonitasoft.engine.xml.XMLNode;
import org.bonitasoft.engine.xml.XMLWriter;

public class ExportOrganization
implements TransactionContentWithResult<String> {
    private final XMLWriter xmlWriter;
    private final IdentityService identityService;
    private Map<Long, String> userNames;
    private String organization;

    public ExportOrganization(XMLWriter xmlWriter, IdentityService identityService) {
        this.xmlWriter = xmlWriter;
        this.identityService = identityService;
    }

    @Override
    public void execute() throws SBonitaException {
        this.userNames = new HashMap<Long, String>(20);
        int numberPerPage = 20;
        List<ExportedUser> users = this.getAllUsers(20);
        this.userNames = new HashMap<Long, String>();
        for (ExportedUser user : users) {
            this.userNames.put(user.getId(), user.getUserName());
        }
        List<Role> roles = this.getAllRoles(20);
        List<SGroup> groups = this.getAllGroups(20);
        HashMap<Long, String> groupIdParentPath = new HashMap<Long, String>(groups.size());
        for (SGroup group : groups) {
            groupIdParentPath.put(group.getId(), group.getParentPath());
        }
        List<SUserMembership> userMemberships = this.getAllUserMemberships(20);
        List<Group> clientGroups = ModelConvertor.toGroups(groups);
        List<UserMembership> clientUserMemberships = ModelConvertor.toUserMembership(userMemberships, this.userNames, groupIdParentPath);
        XMLNode document = OrganizationNodeBuilder.getDocument(users, this.userNames, clientGroups, groupIdParentPath, roles, clientUserMemberships);
        StringWriter writer = new StringWriter();
        try {
            this.xmlWriter.write(document, writer);
            writer.close();
        }
        catch (IOException e) {
            throw new SIdentityException(e);
        }
        this.organization = writer.toString();
    }

    @Override
    public String getResult() {
        return this.organization;
    }

    private List<SUserMembership> getAllUserMemberships(int numberPerPage) throws SIdentityException {
        long numberOfUserMemberships = this.identityService.getNumberOfUserMemberships();
        ArrayList<SUserMembership> sUserMemberships = new ArrayList<SUserMembership>();
        int i = 0;
        while ((long)i < numberOfUserMemberships) {
            sUserMemberships.addAll(this.identityService.getUserMemberships(i, numberPerPage));
            i += numberPerPage;
        }
        return sUserMemberships;
    }

    private List<SGroup> getAllGroups(int numberPerPage) throws SIdentityException {
        long groupNumber = this.identityService.getNumberOfGroups();
        ArrayList<SGroup> groups = new ArrayList<SGroup>(Long.valueOf(groupNumber).intValue());
        int i = 0;
        while ((long)i < groupNumber) {
            groups.addAll(this.identityService.getGroups(i, numberPerPage));
            i += numberPerPage;
        }
        return groups;
    }

    private List<Role> getAllRoles(int numberPerPage) throws SIdentityException {
        long roleNumber = this.identityService.getNumberOfRoles();
        ArrayList<Role> roles = new ArrayList<Role>(Long.valueOf(roleNumber).intValue());
        int i = 0;
        while ((long)i < roleNumber) {
            List<SRole> sRoles = this.identityService.getRoles(i, numberPerPage);
            roles.addAll(ModelConvertor.toRoles(sRoles));
            i += numberPerPage;
        }
        return roles;
    }

    private List<ExportedUser> getAllUsers(int numberPerPage) throws SIdentityException {
        long userNumber = this.identityService.getNumberOfUsers();
        ArrayList<ExportedUser> users = new ArrayList<ExportedUser>(Long.valueOf(userNumber).intValue());
        int i = 0;
        while ((long)i <= userNumber) {
            List<SUser> sUsers = this.identityService.getUsers(i, numberPerPage);
            for (SUser sUser : sUsers) {
                SContactInfo persoInfo = this.identityService.getUserContactInfo(sUser.getId(), true);
                SContactInfo proInfo = this.identityService.getUserContactInfo(sUser.getId(), false);
                long managerUserId = sUser.getManagerUserId();
                String managerUserName = null;
                if (managerUserId > 0L && (managerUserName = this.userNames.get(managerUserId)) == null) {
                    SUser manager = this.identityService.getUser(sUser.getManagerUserId());
                    this.userNames.put(manager.getId(), manager.getUserName());
                    managerUserName = manager.getUserName();
                }
                this.userNames.put(sUser.getId(), sUser.getUserName());
                users.add(ModelConvertor.toExportedUser(sUser, persoInfo, proInfo, managerUserName));
            }
            i += numberPerPage;
        }
        return users;
    }
}

